/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.concord.energy2d.undo.UndoTranslateManipulable;
import org.concord.energy2d.util.ColorComboBox;
import org.concord.energy2d.util.ColorRectangle;
import org.concord.energy2d.util.ComboBoxRenderer;
import org.concord.energy2d.util.MiscUtil;
import org.concord.energy2d.view.TextBox;
import org.concord.energy2d.view.View2D;

class TextBoxPanel
extends JPanel {
    private static final String[] FONT_FAMILY_NAMES = new String[]{"Arial", "Arial Black", "Book Antiqua", "Comic Sans MS", "Courier New", "Default", "Dialog", "DialogInput", "Monospaced", "SansSerif", "Serif", "Times New Roman", "Verdana"};
    private static final Integer[] FONT_SIZE = new Integer[]{8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 36, 48};
    private static final DecimalFormat FORMAT = new DecimalFormat("####.####");
    private View2D view;
    private TextBox textBox;
    private JDialog dialog;
    private static Point offset;
    private boolean cancelled;
    private JTextField uidField;
    private JCheckBox borderCheckBox;
    private JCheckBox draggableCheckBox;
    private JTextField xField;
    private JTextField yField;
    private JComboBox<String> fontNameComboBox;
    private JComboBox<Integer> fontSizeComboBox;
    private ColorComboBox fontColorComboBox;
    private JToggleButton boldButton;
    private JToggleButton italicButton;
    private JTextArea textArea;
    private TextBox copy;

    TextBoxPanel(TextBox t, View2D v) {
        super(new BorderLayout(5, 5));
        if (t == null) {
            throw new IllegalArgumentException("input cannot be null");
        }
        this.textBox = t;
        this.view = v;
        this.storeSettings();
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String uid;
                boolean moved;
                float x = TextBoxPanel.this.parse(TextBoxPanel.this.xField.getText());
                if (Float.isNaN(x)) {
                    return;
                }
                float y = TextBoxPanel.this.parse(TextBoxPanel.this.yField.getText());
                if (Float.isNaN(y)) {
                    return;
                }
                float dx = 1.0E-6f * ((TextBoxPanel)TextBoxPanel.this).view.model.getLx();
                float dy = 1.0E-6f * ((TextBoxPanel)TextBoxPanel.this).view.model.getLy();
                boolean bl = moved = Math.abs(x - TextBoxPanel.this.textBox.getX()) > dx || Math.abs(y - TextBoxPanel.this.textBox.getY()) > dy;
                if (moved) {
                    TextBoxPanel.this.view.getUndoManager().addEdit(new UndoTranslateManipulable(TextBoxPanel.this.view));
                }
                if ((uid = TextBoxPanel.this.uidField.getText()) != null && !uid.trim().equals("")) {
                    TextBoxPanel.this.textBox.setUid(uid.trim());
                } else {
                    TextBoxPanel.this.textBox.setUid(null);
                }
                TextBoxPanel.this.textBox.setLabel(TextBoxPanel.this.textArea.getText());
                TextBoxPanel.this.textBox.setX(x);
                TextBoxPanel.this.textBox.setY(y);
                if (TextBoxPanel.this.dialog != null) {
                    offset = TextBoxPanel.this.dialog.getLocationOnScreen();
                    TextBoxPanel.this.dialog.dispose();
                }
                TextBoxPanel.this.view.repaint();
                TextBoxPanel.this.view.notifyManipulationListeners(TextBoxPanel.this.textBox, (byte)7);
            }
        };
        this.textArea = new JTextArea(this.textBox.getLabel(), 5, 10);
        this.textArea.setForeground(this.textBox.getColor());
        this.textArea.setFont(this.textBox.getFont());
        this.textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TextBoxPanel.this.textBox.setLabel(TextBoxPanel.this.textArea.getText());
                TextBoxPanel.this.view.repaint();
            }
        });
        this.add((Component)new JScrollPane(this.textArea), "Center");
        JPanel p = new JPanel(new BorderLayout(5, 5));
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)p, "North");
        JPanel p2 = new JPanel(new FlowLayout(0, 5, 0));
        p.add((Component)p2, "North");
        JLabel label = new JLabel("Unique ID:");
        p2.add(label);
        this.uidField = new JTextField(this.textBox.getUid(), 8);
        this.uidField.addActionListener(okListener);
        p2.add(this.uidField);
        label = new JLabel("X:");
        p2.add(label);
        this.xField = new JTextField(FORMAT.format(t.getX()), 10);
        this.xField.addActionListener(okListener);
        p2.add(this.xField);
        label = new JLabel("Y:");
        p2.add(label);
        this.yField = new JTextField(FORMAT.format(t.getY()), 10);
        this.yField.addActionListener(okListener);
        p2.add(this.yField);
        ActionListener styleListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int style = (TextBoxPanel.this.boldButton.isSelected() ? 1 : 0) | (TextBoxPanel.this.italicButton.isSelected() ? 2 : 0);
                TextBoxPanel.this.textBox.setStyle(style);
                TextBoxPanel.this.textArea.setFont(TextBoxPanel.this.textBox.getFont());
                TextBoxPanel.this.view.repaint();
            }
        };
        this.boldButton = new JToggleButton("<html><b>B</b></html>");
        this.boldButton.setSelected((this.textBox.getFont().getStyle() & 1) == 1);
        this.boldButton.addActionListener(styleListener);
        p2.add(this.boldButton);
        this.italicButton = new JToggleButton("<html><b><i>I</i></b></html>");
        this.italicButton.setSelected((this.textBox.getFont().getStyle() & 2) == 2);
        this.italicButton.addActionListener(styleListener);
        p2.add(this.italicButton);
        p2 = new JPanel(new FlowLayout(0, 5, 0));
        p.add((Component)p2, "Center");
        this.borderCheckBox = new JCheckBox("Border");
        this.borderCheckBox.setSelected(this.textBox.hasBorder());
        this.borderCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TextBoxPanel.this.textBox.setBorder(e.getStateChange() == 1);
                TextBoxPanel.this.view.repaint();
            }
        });
        p2.add(this.borderCheckBox);
        this.draggableCheckBox = new JCheckBox("Draggable");
        this.draggableCheckBox.setSelected(this.textBox.isDraggable());
        this.draggableCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TextBoxPanel.this.textBox.setDraggable(e.getStateChange() == 1);
                TextBoxPanel.this.view.repaint();
            }
        });
        p2.add(this.draggableCheckBox);
        p2.add(new JLabel("Font face:"));
        this.fontNameComboBox = TextBoxPanel.createFontNameComboBox();
        this.fontNameComboBox.setSelectedItem(this.textBox.getFont().getFamily());
        this.fontNameComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextBoxPanel.this.textBox.setFace((String)TextBoxPanel.this.fontNameComboBox.getSelectedItem());
                TextBoxPanel.this.textArea.setFont(TextBoxPanel.this.textBox.getFont());
                TextBoxPanel.this.view.repaint();
            }
        });
        p2.add(this.fontNameComboBox);
        p2.add(new JLabel("Size:"));
        this.fontSizeComboBox = TextBoxPanel.createFontSizeComboBox();
        this.fontSizeComboBox.setSelectedItem(new Integer(this.textBox.getFont().getSize()));
        this.fontSizeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextBoxPanel.this.textBox.setSize((Integer)TextBoxPanel.this.fontSizeComboBox.getSelectedItem());
                TextBoxPanel.this.textArea.setFont(TextBoxPanel.this.textBox.getFont());
                TextBoxPanel.this.view.repaint();
            }
        });
        p2.add(this.fontSizeComboBox);
        p2.add(new JLabel("Color:"));
        this.fontColorComboBox = new ColorComboBox(this);
        this.fontColorComboBox.setColor(this.textBox.getColor());
        this.fontColorComboBox.setRenderer(new ComboBoxRenderer.ColorCell(this.textBox.getColor()));
        this.fontColorComboBox.setToolTipText("Font color");
        this.fontColorComboBox.setPreferredSize(new Dimension(80, this.fontSizeComboBox.getPreferredSize().height));
        this.fontColorComboBox.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TextBoxPanel.this.fontColorComboBox.getSelectedIndex() >= ColorRectangle.COLORS.length + 1) {
                    TextBoxPanel.this.fontColorComboBox.updateColor(new Runnable(){

                        @Override
                        public void run() {
                            TextBoxPanel.this.textBox.setColor(TextBoxPanel.this.fontColorComboBox.getMoreColor());
                            TextBoxPanel.this.textArea.setForeground(TextBoxPanel.this.textBox.getColor());
                        }
                    });
                } else {
                    TextBoxPanel.this.textBox.setColor(TextBoxPanel.this.fontColorComboBox.getSelectedColor());
                    TextBoxPanel.this.textArea.setForeground(TextBoxPanel.this.textBox.getColor());
                }
                TextBoxPanel.this.view.repaint();
            }
        });
        p2.add(this.fontColorComboBox);
        p = new JPanel(new FlowLayout(2));
        this.add((Component)p, "South");
        p.add(new JLabel("Note: HTML is not supported."));
        JButton button = new JButton("OK");
        button.addActionListener(okListener);
        p.add(button);
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextBoxPanel.this.restoreSettings();
                TextBoxPanel.this.cancelled = true;
                if (TextBoxPanel.this.dialog != null) {
                    offset = TextBoxPanel.this.dialog.getLocationOnScreen();
                    TextBoxPanel.this.dialog.dispose();
                }
            }
        });
        p.add(button);
    }

    boolean isCancelled() {
        return this.cancelled;
    }

    static void setOffset(Point p) {
        offset = p;
    }

    static Point getOffset() {
        return offset;
    }

    void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    void storeSettings() {
        if (this.copy == null) {
            this.copy = new TextBox(new Rectangle2D.Float());
        }
        this.copy.set(this.textBox);
    }

    void restoreSettings() {
        if (this.copy == null) {
            return;
        }
        this.textBox.set(this.copy);
    }

    void handleWindowActivation(Color c) {
        this.textArea.setBackground(c);
        this.textArea.setCaretColor(new Color(255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue()));
        this.textArea.selectAll();
        this.textArea.requestFocusInWindow();
    }

    JDialog createDialog(boolean modal) {
        final JDialog dialog = new JDialog(JOptionPane.getFrameForComponent(this.view), "Text Box Properties", modal);
        dialog.setContentPane(this);
        this.setDialog(dialog);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                dialog.dispose();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                TextBoxPanel.this.handleWindowActivation(TextBoxPanel.this.view.getTemperatureColor(TextBoxPanel.this.view.getBackgroundTemperature()));
            }
        });
        if (TextBoxPanel.getOffset() == null) {
            dialog.setLocationRelativeTo(this.view);
        } else {
            dialog.setLocation(TextBoxPanel.getOffset());
        }
        dialog.pack();
        return dialog;
    }

    private static JComboBox<String> createFontNameComboBox() {
        JComboBox<String> c = new JComboBox<String>(FONT_FAMILY_NAMES);
        c.setRenderer(new ComboBoxRenderer.FontLabel());
        c.setToolTipText("Font type");
        FontMetrics fm = c.getFontMetrics(c.getFont());
        int max = 0;
        int n = 0;
        int i = 0;
        while (i < FONT_FAMILY_NAMES.length) {
            n = fm.stringWidth(FONT_FAMILY_NAMES[i]);
            if (max < n) {
                max = n;
            }
            ++i;
        }
        int w = max + 50;
        int h = fm.getHeight() + 8;
        c.setPreferredSize(new Dimension(w, h));
        c.setEditable(false);
        c.setRequestFocusEnabled(false);
        return c;
    }

    private static JComboBox<Integer> createFontSizeComboBox() {
        JComboBox<Integer> c = new JComboBox<Integer>(FONT_SIZE);
        c.setToolTipText("Font size");
        FontMetrics fm = c.getFontMetrics(c.getFont());
        int w = fm.stringWidth(FONT_SIZE[FONT_SIZE.length - 1].toString()) + 40;
        int h = fm.getHeight() + 8;
        c.setPreferredSize(new Dimension(w, h));
        c.setEditable(false);
        c.setRequestFocusEnabled(false);
        return c;
    }

    private float parse(String s) {
        return MiscUtil.parse(JOptionPane.getFrameForComponent(this.view), s);
    }
}

