/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.util.XmlCharacterEncoder;

public class TextBox
extends Manipulable {
    private float x;
    private float y;
    private String face = "Arial";
    private int style = 0;
    private int size = 14;
    private boolean border;
    private Color color = Color.white;

    public TextBox(Rectangle2D.Float rect) {
        super(rect);
    }

    public TextBox(Rectangle2D.Float rect, String text, float x, float y) {
        this(rect);
        this.setLabel(text);
        this.setLocation(x, y);
    }

    @Override
    public TextBox duplicate(float x, float y) {
        Rectangle2D.Float r = (Rectangle2D.Float)this.getShape();
        TextBox t = new TextBox(new Rectangle2D.Float(r.x, r.y, r.width, r.height));
        t.set(this);
        t.x = x;
        t.y = y;
        return t;
    }

    public void set(TextBox t) {
        this.setLabel(t.getLabel());
        this.face = t.face;
        this.style = t.style;
        this.size = t.size;
        this.color = t.color;
        this.border = t.border;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getX() {
        return this.x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getY() {
        return this.y;
    }

    public void translateBy(float dx, float dy) {
        this.x += dx;
        this.y += dy;
    }

    public void setLocation(float x, float y) {
        this.setX(x);
        this.setY(y);
    }

    public void setFace(String face) {
        this.face = face;
    }

    public String getFace() {
        return this.face;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public int getStyle() {
        return this.style;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void setFont(Font font) {
        this.face = font.getFamily();
        this.style = font.getStyle();
        this.size = font.getSize();
    }

    public Font getFont() {
        return new Font(this.face, this.style, this.size);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setBorder(boolean b) {
        this.border = b;
    }

    public boolean hasBorder() {
        return this.border;
    }

    public String toXml() {
        String xml = "<text";
        if (this.getUid() != null) {
            xml = String.valueOf(xml) + " uid=\"" + this.getUid() + "\"";
        }
        xml = String.valueOf(xml) + " string=\"" + new XmlCharacterEncoder().encode(this.getLabel()) + "\"";
        xml = String.valueOf(xml) + " face=\"" + this.face + "\"";
        xml = String.valueOf(xml) + " size=\"" + this.size + "\"";
        xml = String.valueOf(xml) + " style=\"" + this.style + "\"";
        xml = String.valueOf(xml) + " color=\"" + Integer.toHexString(0xFFFFFF & this.getColor().getRGB()) + "\"";
        if (this.border) {
            xml = String.valueOf(xml) + " border=\"true\"";
        }
        if (!this.isVisible()) {
            xml = String.valueOf(xml) + " visible=\"false\"";
        }
        if (!this.isDraggable()) {
            xml = String.valueOf(xml) + " draggable=\"false\"";
        }
        xml = String.valueOf(xml) + " x=\"" + this.getX() + "\"";
        xml = String.valueOf(xml) + " y=\"" + this.getY() + "\"/>\n";
        return xml;
    }
}

