/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import org.concord.energy2d.model.Cloud;
import org.concord.energy2d.model.Fan;
import org.concord.energy2d.model.Heliostat;
import org.concord.energy2d.model.Tree;

public abstract class Symbol
implements Icon {
    protected int xSymbol = 0;
    protected int ySymbol = 0;
    protected int wSymbol = 8;
    protected int hSymbol = 8;
    protected Color color = Color.white;
    protected Stroke stroke = new BasicStroke(1.0f);
    protected boolean paintBorder;
    protected boolean pressed;
    protected boolean disabled;
    protected int offsetX;
    protected int offsetY;
    protected int marginX;
    protected int marginY;

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setPressed(boolean pressed) {
        this.pressed = pressed;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setBorderPainted(boolean paintBorder) {
        this.paintBorder = paintBorder;
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setMarginX(int marginX) {
        this.marginX = marginX;
    }

    public int getMarginX() {
        return this.marginX;
    }

    public void setMarginY(int marginY) {
        this.marginY = marginY;
    }

    public int getMarginY() {
        return this.marginY;
    }

    public void setSymbolWidth(int wSymbol) {
        this.wSymbol = wSymbol;
    }

    public int getSymbolWidth() {
        return this.wSymbol;
    }

    public void setSymbolHeight(int hSymbol) {
        this.hSymbol = hSymbol;
    }

    public int getSymbolHeight() {
        return this.hSymbol;
    }

    public void setIconWidth(int width) {
        this.wSymbol = width - this.marginX * 2;
    }

    @Override
    public int getIconWidth() {
        return this.wSymbol + this.marginX * 2;
    }

    public void setIconHeight(int height) {
        this.hSymbol = height - this.marginY * 2;
    }

    @Override
    public int getIconHeight() {
        return this.hSymbol + this.marginY * 2;
    }

    public boolean contains(int rx, int ry) {
        return rx > this.xSymbol && rx < this.xSymbol + this.wSymbol && ry > this.ySymbol && ry < this.ySymbol + this.hSymbol;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.xSymbol = x + this.offsetX;
        this.ySymbol = y + this.offsetY;
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.color);
        if (this.paintBorder) {
            g.drawRoundRect(this.xSymbol, this.ySymbol, this.wSymbol, this.hSymbol, 10, 10);
        }
        g2.setStroke(this.stroke);
    }

    public Symbol getScaledInstance(float scale) {
        try {
            Symbol icon = (Symbol)this.getClass().newInstance();
            icon.setIconWidth((int)(scale * (float)icon.getIconWidth()));
            icon.setIconHeight((int)(scale * (float)icon.getIconHeight()));
            return icon;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Image createImage(Component c) {
        BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        try {
            this.paintIcon(c, g, 0, 0);
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            g.dispose();
        }
    }

    public static class Anemometer
    extends Symbol {
        private float angle;
        private boolean isButtonIcon;

        public Anemometer(boolean isButtonIcon) {
            this.isButtonIcon = isButtonIcon;
        }

        public void setAngle(float angle) {
            this.angle = angle;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            Graphics2D g2 = (Graphics2D)g;
            if (this.isButtonIcon) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            double xc = (double)this.xSymbol + (double)this.wSymbol * 0.5;
            double yc = (double)this.ySymbol + (double)this.hSymbol * 0.5;
            g2.setColor(Color.white);
            g.fillOval(Math.round((float)this.xSymbol + (float)this.wSymbol * 0.4f), Math.round((float)this.ySymbol + (float)this.hSymbol * 0.4f), Math.round((float)this.wSymbol * 0.2f), Math.round((float)this.hSymbol * 0.2f));
            g2.setColor(Color.black);
            g.drawOval(Math.round((float)this.xSymbol + (float)this.wSymbol * 0.4f), Math.round((float)this.ySymbol + (float)this.hSymbol * 0.4f), Math.round((float)this.wSymbol * 0.2f), Math.round((float)this.hSymbol * 0.2f));
            g2.rotate(this.angle, xc, yc);
            int[] xPoints = new int[]{(int)xc, Math.round((float)this.xSymbol + (float)this.wSymbol * 0.4f), Math.round((float)this.xSymbol + (float)this.wSymbol * 0.6f)};
            int[] yPoints = new int[]{this.ySymbol, Math.round((float)this.ySymbol + (float)this.hSymbol * 0.4f), Math.round((float)this.ySymbol + (float)this.hSymbol * 0.4f)};
            g2.setColor(Color.white);
            g.fillPolygon(xPoints, yPoints, 3);
            g2.setColor(Color.black);
            g.drawPolygon(xPoints, yPoints, 3);
            double theta = 2.0943951023931953;
            g2.rotate(theta, xc, yc);
            g2.setColor(Color.white);
            g.fillPolygon(xPoints, yPoints, 3);
            g2.setColor(Color.black);
            g.drawPolygon(xPoints, yPoints, 3);
            g2.rotate(theta, xc, yc);
            g2.setColor(Color.white);
            g.fillPolygon(xPoints, yPoints, 3);
            g2.setColor(Color.black);
            g.drawPolygon(xPoints, yPoints, 3);
            g2.rotate((double)(-this.angle) - 2.0 * theta, xc, yc);
        }
    }

    public static class ArrowHead
    extends Symbol {
        public ArrowHead(Color color, int w, int h) {
            this.setColor(color);
            this.setIconWidth(w);
            this.setIconHeight(h);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            int x2 = this.wSymbol / 2;
            int y2 = this.hSymbol / 2;
            int[] vx = new int[]{2, this.wSymbol - 2, x2};
            int[] vy = new int[]{y2 - 2, y2 - 2, y2 + 4};
            g.fillPolygon(vx, vy, vx.length);
        }
    }

    static class BrandIcon
    extends Symbol {
        private Font font = new Font("Book Antiqua", 1, 14);
        private int cornerDiameter = 20;

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, this.xSymbol, this.ySymbol);
            Graphics2D g2 = (Graphics2D)g;
            String s = "Energy2D";
            g2.setFont(this.font);
            FontMetrics fm = g.getFontMetrics();
            this.wSymbol = fm.stringWidth(s) + 10;
            this.hSymbol = fm.getHeight() + fm.getDescent() + 3;
            this.xSymbol = x - 6;
            this.ySymbol = y - fm.getAscent() - 3;
            g2.setColor(Color.gray);
            g2.fillRoundRect(this.xSymbol, this.ySymbol, this.wSymbol, this.hSymbol, this.cornerDiameter, this.cornerDiameter);
            g2.setStroke(this.stroke);
            g2.setColor(this.color);
            g2.drawRoundRect(this.xSymbol, this.ySymbol, this.wSymbol, this.hSymbol, this.cornerDiameter, this.cornerDiameter);
            g2.setColor(Color.black);
            g2.drawString(s, x + 1, y - 1);
            g2.drawString(s, x + 1, y + 1);
            g2.drawString(s, x - 1, y - 1);
            g2.drawString(s, x - 1, y + 1);
            g2.setColor(Color.lightGray);
            g2.drawString(s, x, y);
        }
    }

    public static class CloudIcon
    extends Symbol {
        private Color borderColor;
        private boolean isButtonIcon;

        public CloudIcon(boolean isButtonIcon) {
            this.isButtonIcon = isButtonIcon;
        }

        public void setBorderColor(Color borderColor) {
            this.borderColor = borderColor;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            Graphics2D g2 = (Graphics2D)g;
            if (this.isButtonIcon) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            Area a = Cloud.getShape(new Rectangle2D.Float(this.xSymbol, this.ySymbol, this.wSymbol > 0 ? this.wSymbol : this.getIconWidth(), this.hSymbol > 0 ? this.hSymbol : this.getIconHeight()));
            g2.setColor(this.color);
            g2.fill(a);
            g2.setColor(this.borderColor);
            g2.setStroke(this.stroke);
            g2.draw(a);
        }
    }

    public static class FanIcon
    extends Symbol {
        private Color borderColor;
        private float speed;
        private float angle;
        private float rotation;
        private boolean isButtonIcon;

        public FanIcon(Color color, Color borderColor, boolean isButtonIcon) {
            this.setColor(color);
            this.setBorderColor(borderColor);
            this.isButtonIcon = isButtonIcon;
        }

        public void setSpeed(float speed) {
            this.speed = speed;
        }

        public void setAngle(float angle) {
            this.angle = angle;
        }

        public void setRotation(float rotation) {
            this.rotation = rotation;
        }

        public void setBorderColor(Color borderColor) {
            this.borderColor = borderColor;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            Graphics2D g2 = (Graphics2D)g;
            if (this.isButtonIcon) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            Area a = Fan.getShape(new Rectangle2D.Float(this.xSymbol, this.ySymbol, this.wSymbol > 0 ? this.wSymbol : this.getIconWidth(), this.hSymbol > 0 ? this.hSymbol : this.getIconHeight()), this.speed, this.angle, (float)Math.abs(Math.sin(this.rotation)));
            g2.setColor(this.color);
            g2.fill(a);
            g2.setColor(this.borderColor);
            g2.setStroke(this.stroke);
            g2.draw(a);
        }
    }

    static class GraphIcon
    extends Symbol {
        private Stroke s2 = new BasicStroke(1.0f);

        public GraphIcon(Color color, int w, int h) {
            this.setColor(color);
            this.setIconWidth(w);
            this.setIconHeight(h);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            Graphics2D g2 = (Graphics2D)g;
            int x0 = (int)((float)this.xSymbol + (float)this.wSymbol * 0.25f);
            int y0 = (int)((float)this.ySymbol + (float)this.hSymbol * 0.25f);
            g2.drawRect(x0 - 1, y0 - 1, (int)((float)this.wSymbol * 0.5f) + 2, (int)((float)this.hSymbol * 0.5f) + 2);
            g2.setStroke(this.s2);
            if (this.pressed) {
                g2.drawLine(x0, y0, (int)((float)x0 + (float)this.wSymbol * 0.5f), (int)((float)y0 + (float)this.hSymbol * 0.5f));
                g2.drawLine(x0, (int)((float)y0 + (float)this.hSymbol * 0.5f), (int)((float)x0 + (float)this.wSymbol * 0.5f), y0);
            } else {
                g2.drawLine(x0, (int)((float)y0 + (float)this.hSymbol * 0.25f), (int)((float)x0 + (float)this.wSymbol * 0.25f), (int)((float)y0 + (float)this.hSymbol * 0.5f));
                g2.drawLine((int)((float)x0 + (float)this.wSymbol * 0.25f), (int)((float)y0 + (float)this.hSymbol * 0.5f), (int)((float)x0 + (float)this.wSymbol * 0.5f), y0);
            }
        }
    }

    public static class HeatFluxSensor
    extends Symbol {
        private Stroke stroke2 = new BasicStroke(3.0f);
        private boolean isButtonIcon;

        public HeatFluxSensor(boolean isButtonIcon) {
            this.isButtonIcon = isButtonIcon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            int y2 = Math.round((float)this.ySymbol + (float)this.hSymbol * 0.5f);
            Graphics2D g2 = (Graphics2D)g;
            if (this.isButtonIcon) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            g2.setColor(Color.white);
            g2.fillRect(this.xSymbol, this.ySymbol, this.wSymbol, this.hSymbol);
            g2.fillOval(this.xSymbol - 7, y2 - 3, 6, 6);
            g2.setColor(Color.black);
            g2.drawRect(this.xSymbol, this.ySymbol, this.wSymbol, this.hSymbol);
            int i = 4;
            while (i < this.wSymbol - 4) {
                if (i % 8 == 0) {
                    g2.drawLine(this.xSymbol + i, this.ySymbol, this.xSymbol + i + 4, this.ySymbol + this.hSymbol);
                } else {
                    g2.drawLine(this.xSymbol + i, this.ySymbol + this.hSymbol, this.xSymbol + i + 4, this.ySymbol);
                }
                i += 4;
            }
            g2.drawLine(this.xSymbol - 2, y2, this.xSymbol + 4, y2);
            g2.drawOval(this.xSymbol - 7, y2 - 3, 6, 6);
            g2.setStroke(this.stroke2);
            g2.drawLine(this.xSymbol, this.ySymbol, this.xSymbol + this.wSymbol, this.ySymbol);
            g2.drawLine(this.xSymbol, this.ySymbol + this.hSymbol, this.xSymbol + this.wSymbol, this.ySymbol + this.hSymbol);
        }
    }

    public static class HeliostatIcon
    extends Symbol {
        private Color borderColor;
        private float angle;
        private boolean isButtonIcon;

        public HeliostatIcon(Color color, Color borderColor, boolean isButtonIcon) {
            this.setColor(color);
            this.setBorderColor(borderColor);
            this.isButtonIcon = isButtonIcon;
        }

        public void setAngle(float angle) {
            this.angle = angle;
        }

        public void setBorderColor(Color borderColor) {
            this.borderColor = borderColor;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            Graphics2D g2 = (Graphics2D)g;
            if (this.isButtonIcon) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            Area a = Heliostat.getShape(new Rectangle2D.Float(this.xSymbol, this.ySymbol, this.wSymbol > 0 ? this.wSymbol : this.getIconWidth(), this.hSymbol > 0 ? this.hSymbol : this.getIconHeight()), this.angle);
            g2.setColor(this.color);
            g2.fill(a);
            g2.setColor(this.borderColor);
            g2.setStroke(this.stroke);
            g2.draw(a);
        }
    }

    static class ModeIcon
    extends Symbol {
        private Stroke stroke2 = new BasicStroke(1.5f, 0, 0, 1.0f, new float[]{1.0f}, 0.0f);

        public ModeIcon(Color color, int w, int h) {
            this.setColor(color);
            this.setIconWidth(w);
            this.setIconHeight(h);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            Graphics2D g2 = (Graphics2D)g;
            if (this.pressed) {
                g2.setStroke(this.stroke2);
                g2.drawOval(this.xSymbol + 5, this.ySymbol + 5, this.wSymbol - 10, this.hSymbol - 10);
                g2.drawOval(this.xSymbol + 10, this.ySymbol + 10, this.wSymbol - 20, this.hSymbol - 20);
                g2.drawOval(this.xSymbol + 15, this.ySymbol + 15, this.wSymbol - 30, this.hSymbol - 30);
            } else {
                g2.rotate(1.0471975511965976, this.xSymbol + this.wSymbol / 2, this.ySymbol + this.hSymbol / 2);
                int d = 6;
                int[] xpoints = new int[]{this.xSymbol + this.wSymbol - 2 * d, this.xSymbol + d, this.xSymbol + this.wSymbol - 2 * d};
                int[] ypoints = new int[]{this.ySymbol + 3 * d / 2, this.ySymbol + this.hSymbol / 2, this.ySymbol + this.hSymbol - 3 * d / 2};
                g.fillPolygon(new Polygon(xpoints, ypoints, 3));
                g.fillRect(this.xSymbol + this.wSymbol - 3 * d, this.ySymbol + this.hSymbol / 2 - d / 2, 2 * d, d);
                g2.rotate(-1.0471975511965976, this.xSymbol + this.wSymbol / 2, this.ySymbol + this.hSymbol / 2);
            }
        }
    }

    static class Moon
    extends Symbol {
        public Moon(Color color, int w, int h) {
            this.setColor(color);
            this.setIconWidth(w);
            this.setIconHeight(h);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            Graphics2D g2 = (Graphics2D)g;
            Area a = new Area(new Ellipse2D.Float(this.xSymbol, this.ySymbol, this.wSymbol, this.hSymbol));
            a.subtract(new Area(new Ellipse2D.Float((float)this.xSymbol + (float)this.wSymbol * 0.25f, this.ySymbol, this.wSymbol, this.hSymbol)));
            g2.fill(a);
        }
    }

    static class NextIcon
    extends Symbol {
        public NextIcon(Color color, int w, int h) {
            this.setColor(color);
            this.setIconWidth(w);
            this.setIconHeight(h);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            g.setColor(this.disabled ? Color.gray : this.color);
            int d = 4;
            int[] xpoints = new int[]{this.xSymbol + 3 * d, this.xSymbol + this.wSymbol - d, this.xSymbol + 3 * d};
            int[] ypoints = new int[]{this.ySymbol + d, this.ySymbol + this.hSymbol / 2, this.ySymbol + this.hSymbol - d};
            g.fillPolygon(new Polygon(xpoints, ypoints, 3));
            g.fillRect(this.xSymbol + d, this.ySymbol + this.hSymbol / 2 - d, 2 * d, 2 * d);
        }
    }

    public static class ParticleFeederIcon
    extends Symbol {
        private Color borderColor;
        private boolean isButtonIcon;

        public ParticleFeederIcon(Color color, Color borderColor, boolean isButtonIcon) {
            this.setColor(color);
            this.setBorderColor(borderColor);
            this.isButtonIcon = isButtonIcon;
        }

        public void setBorderColor(Color borderColor) {
            this.borderColor = borderColor;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            Graphics2D g2 = (Graphics2D)g;
            if (this.isButtonIcon) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            g2.setStroke(this.stroke);
            g2.setColor(this.color);
            g2.fillRoundRect(this.xSymbol, this.ySymbol, this.wSymbol, this.hSymbol, 8, 8);
            g2.setColor(this.borderColor);
            g2.drawRoundRect(this.xSymbol, this.ySymbol, this.wSymbol, this.hSymbol, 8, 8);
            g2.fillOval(Math.round((float)this.xSymbol + 0.5f * (float)this.wSymbol - 2.0f), Math.round((float)this.ySymbol + 0.5f * (float)this.hSymbol - 2.0f), 4, 4);
        }
    }

    static class PrevIcon
    extends Symbol {
        public PrevIcon(Color color, int w, int h) {
            this.setColor(color);
            this.setIconWidth(w);
            this.setIconHeight(h);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            g.setColor(this.disabled ? Color.gray : this.color);
            int d = 4;
            int[] xpoints = new int[]{this.xSymbol + this.wSymbol - 3 * d, this.xSymbol + d, this.xSymbol + this.wSymbol - 3 * d};
            int[] ypoints = new int[]{this.ySymbol + d, this.ySymbol + this.hSymbol / 2, this.ySymbol + this.hSymbol - d};
            g.fillPolygon(new Polygon(xpoints, ypoints, 3));
            g.fillRect(this.xSymbol + this.wSymbol - 3 * d, this.ySymbol + this.hSymbol / 2 - d, 2 * d, 2 * d);
        }
    }

    static class ResetIcon
    extends Symbol {
        public ResetIcon(Color color, int w, int h) {
            this.setColor(color);
            this.setIconWidth(w);
            this.setIconHeight(h);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            Graphics2D g2 = (Graphics2D)g;
            Rectangle2D.Float s = new Rectangle2D.Float((float)this.xSymbol + (float)this.wSymbol * 0.4f, (float)this.ySymbol + (float)this.hSymbol * 0.3f, (float)this.wSymbol * 0.4f, (float)this.hSymbol * 0.4f);
            Arc2D.Float a = new Arc2D.Float(s, -90.0f, 180.0f, 0);
            g2.draw(a);
            int x0 = Math.round((float)this.xSymbol + (float)this.wSymbol * 0.3f);
            int y0 = Math.round((float)this.ySymbol + (float)this.hSymbol * 0.28f);
            g2.drawLine(Math.round((float)this.xSymbol + (float)this.wSymbol * 0.55f), y0, x0, y0);
            g2.drawLine(x0, y0, x0 + 2, y0 - 2);
            g2.drawLine(x0, y0, x0 + 2, y0 + 2);
            g2.drawLine(Math.round((float)this.xSymbol + (float)this.wSymbol * 0.55f), y0 += Math.round((float)this.hSymbol * 0.4f), x0, y0);
        }
    }

    static class StartIcon
    extends Symbol {
        private int d = 4;
        private Stroke s2 = new BasicStroke(this.d);

        public StartIcon(Color color, int w, int h) {
            this.setColor(color);
            this.setIconWidth(w);
            this.setIconHeight(h);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            if (this.pressed) {
                ((Graphics2D)g).setStroke(this.s2);
                g.drawLine(this.xSymbol + this.wSymbol / 2 - this.d + 1, this.ySymbol + this.d * 2, this.xSymbol + this.wSymbol / 2 - this.d + 1, this.ySymbol + this.hSymbol - this.d * 2);
                g.drawLine(this.xSymbol + this.wSymbol / 2 + this.d - 1, this.ySymbol + this.d * 2, this.xSymbol + this.wSymbol / 2 + this.d - 1, this.ySymbol + this.hSymbol - this.d * 2);
            } else {
                int[] xpoints = new int[]{this.xSymbol + this.wSymbol / 2 - this.d, this.xSymbol + this.wSymbol - this.d, this.xSymbol + this.wSymbol / 2 - this.d};
                int[] ypoints = new int[]{this.ySymbol + this.d, this.ySymbol + this.hSymbol / 2, this.ySymbol + this.hSymbol - this.d};
                g.fillPolygon(new Polygon(xpoints, ypoints, 3));
            }
        }
    }

    static class Sun
    extends Symbol {
        public Sun(Color color, int w, int h) {
            this.setColor(color);
            this.setIconWidth(w);
            this.setIconHeight(h);
            this.setStroke(new BasicStroke(2.0f));
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            Graphics2D g2 = (Graphics2D)g;
            Ellipse2D.Float s = new Ellipse2D.Float(this.xSymbol, this.ySymbol, (float)this.wSymbol * 0.75f, (float)this.hSymbol * 0.75f);
            g2.fill(s);
            double angle = 0.0;
            int n = 8;
            int i = 0;
            while (i < n) {
                angle = (double)i * Math.PI * 2.0 / (double)n;
                int x1 = (int)(s.getCenterX() + 10.0 * Math.cos(angle));
                int y1 = (int)(s.getCenterY() + 10.0 * Math.sin(angle));
                g2.drawLine(x1, y1, (int)s.getCenterX(), (int)s.getCenterY());
                ++i;
            }
        }
    }

    static class SwitchIcon
    extends Symbol {
        public SwitchIcon(Color color, int w, int h) {
            this.setColor(color);
            this.setIconWidth(w);
            this.setIconHeight(h);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            Graphics2D g2 = (Graphics2D)g;
            float thickness = ((BasicStroke)this.stroke).getLineWidth();
            Rectangle2D.Float s = new Rectangle2D.Float((float)this.xSymbol + (float)this.wSymbol * 0.2f, (float)this.ySymbol + (float)this.hSymbol * 0.2f, (float)this.wSymbol * 0.6f, (float)this.hSymbol * 0.6f);
            Arc2D.Float a = new Arc2D.Float(s, 80.0f - thickness * 10.0f, thickness * 20.0f - 340.0f, 0);
            g2.draw(a);
            g2.drawLine((int)((float)this.xSymbol + (float)this.wSymbol * 0.5f), (int)((float)this.ySymbol + (float)this.hSymbol * 0.1f), (int)((float)this.xSymbol + (float)this.wSymbol * 0.5f), (int)((float)this.ySymbol + (float)this.hSymbol * 0.4f));
        }
    }

    public static class Thermometer
    extends Symbol {
        private int value;
        private int ballDiameter;
        private boolean isButtonIcon;

        public Thermometer(boolean isButtonIcon) {
            this.isButtonIcon = isButtonIcon;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public int getBarHeight() {
            return this.hSymbol - Math.round((float)this.wSymbol * 1.5f);
        }

        public int getBallDiameterOffset() {
            return this.ballDiameter - 3;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            Graphics2D g2 = (Graphics2D)g;
            if (this.isButtonIcon) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            g2.setColor(Color.white);
            g2.fillRect(this.xSymbol, this.ySymbol, this.wSymbol, this.hSymbol);
            this.ballDiameter = Math.round((float)this.wSymbol * 1.45f);
            int x2 = this.xSymbol + this.wSymbol / 2;
            int y2 = this.ySymbol + this.hSymbol - this.ballDiameter + 2;
            if (this.value != 0) {
                g2.setColor(Color.red);
                BasicStroke bs = new BasicStroke((float)this.wSymbol * 0.3f);
                g2.setStroke(bs);
                g2.drawLine(x2, y2 - this.value, x2, y2);
            }
            g2.setColor(Color.black);
            g2.setStroke(this.stroke);
            g2.drawRect(this.xSymbol, this.ySymbol, this.wSymbol, this.hSymbol);
            int n = this.hSymbol / 2;
            int i = 1;
            while (i < n) {
                g2.drawLine(this.xSymbol, this.ySymbol + i * 2, Math.round((float)this.xSymbol + 0.2f * (float)this.wSymbol), this.ySymbol + i * 2);
                g2.drawLine(this.xSymbol + this.wSymbol, this.ySymbol + i * 2, Math.round((float)(this.xSymbol + this.wSymbol) - 0.2f * (float)this.wSymbol), this.ySymbol + i * 2);
                ++i;
            }
            x2 = Math.round((float)this.xSymbol - (float)this.wSymbol * 0.25f);
            g2.setColor(Color.lightGray);
            g2.fillOval(x2, y2, this.ballDiameter, this.ballDiameter);
            g2.setColor(Color.black);
            g2.drawOval(x2, y2, this.ballDiameter, this.ballDiameter);
        }
    }

    public static class TreeIcon
    extends Symbol {
        private byte type;
        private Color borderColor;
        private boolean isButtonIcon;

        public TreeIcon(byte type, boolean isButtonIcon) {
            this.type = type;
            this.isButtonIcon = isButtonIcon;
        }

        public void setType(byte type) {
            this.type = type;
        }

        public void setBorderColor(Color borderColor) {
            this.borderColor = borderColor;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            Graphics2D g2 = (Graphics2D)g;
            if (this.isButtonIcon) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            Area a = Tree.getShape(new Rectangle2D.Float(this.xSymbol, this.ySymbol, this.wSymbol > 0 ? this.wSymbol : this.getIconWidth(), this.hSymbol > 0 ? this.hSymbol : this.getIconHeight()), this.type);
            g2.setColor(this.color);
            g2.fill(a);
            g2.setColor(this.borderColor);
            g2.setStroke(this.stroke);
            g2.draw(a);
        }
    }
}

