/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.JComponent;

class SpotlightRenderer {
    private Stroke stroke1 = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.5f}, 0.0f);
    private Stroke stroke2 = new BasicStroke(4.0f);
    private Color color1 = Color.yellow;
    private Color color2 = new Color(20, 255, 20, 128);
    private int nx;
    private int ny;
    private int size = 3;

    public SpotlightRenderer(int nx, int ny) {
        this.nx = nx;
        this.ny = ny;
    }

    void render(JComponent c, Graphics2D g, int x, int y) {
        int k;
        float dx = (float)c.getWidth() / (float)this.nx;
        float dy = (float)c.getHeight() / (float)this.ny;
        int ix = Math.round((float)x / dx);
        int iy = Math.round((float)y / dy);
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        g.setColor(this.color1);
        g.setStroke(this.stroke1);
        int rx = Math.round((float)this.size * dx);
        int ry = Math.round((float)this.size * dy);
        int i = 0;
        while (i < this.nx) {
            if (i > ix - this.size && i < ix + this.size) {
                k = Math.round((float)i * dx);
                g.drawLine(k, y - ry, k, y + ry);
            }
            ++i;
        }
        i = 0;
        while (i < this.ny) {
            if (i > iy - this.size && i < iy + this.size) {
                k = Math.round((float)i * dy);
                g.drawLine(x - rx, k, x + rx, k);
            }
            ++i;
        }
        g.setColor(Color.white);
        g.fillOval(Math.round((float)ix * dx - 3.0f), Math.round((float)iy * dy - 3.0f), 6, 6);
        g.setColor(this.color2);
        g.setStroke(this.stroke2);
        g.drawRect(x - rx, y - ry, 2 * rx, 2 * ry);
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }
}

