/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.concord.energy2d.view.View2D;

class ScalarDistributionRenderer {
    private BufferedImage image;
    private int[] pixels;
    private int w;
    private int h;
    private float min = 0.0f;
    private float max = 50.0f;
    private float scale;
    private short[][] rgbScale;
    private boolean smooth = true;

    ScalarDistributionRenderer(short[][] rgbScale, float min, float max) {
        this.rgbScale = rgbScale;
        this.min = min;
        this.max = max;
        this.scale = (float)rgbScale.length / (max - min);
    }

    void setSmooth(boolean smooth) {
        this.smooth = smooth;
    }

    boolean isSmooth() {
        return this.smooth;
    }

    void setMaximum(float max) {
        this.max = max;
        this.scale = (float)this.rgbScale.length / (max - this.min);
    }

    float getMaximum() {
        return this.max;
    }

    void setMinimum(float min) {
        this.min = min;
        this.scale = (float)this.rgbScale.length / (this.max - min);
    }

    float getMinimum() {
        return this.min;
    }

    int getRGB(int x, int y) {
        if (this.image == null) {
            return Color.white.getRGB();
        }
        if (x >= this.image.getWidth()) {
            x = this.image.getWidth() - 1;
        }
        if (x < 0) {
            x = 0;
        }
        if (y >= this.image.getHeight()) {
            y = this.image.getHeight() - 1;
        }
        if (y < 0) {
            y = 0;
        }
        return this.image.getRGB(x, y);
    }

    int getColor(float value) {
        float v = (value - this.min) * this.scale;
        if (v > (float)(this.rgbScale.length - 2)) {
            v = this.rgbScale.length - 2;
        } else if (v < 0.0f) {
            v = 0.0f;
        }
        int iv = (int)v;
        int rc = (int)((float)this.rgbScale[iv][0] * (1.0f - (v -= (float)iv)) + (float)this.rgbScale[iv + 1][0] * v);
        int gc = (int)((float)this.rgbScale[iv][1] * (1.0f - v) + (float)this.rgbScale[iv + 1][1] * v);
        int bc = (int)((float)this.rgbScale[iv][2] * (1.0f - v) + (float)this.rgbScale[iv + 1][2] * v);
        return 0xFF000000 | rc << 16 | gc << 8 | bc;
    }

    void render(View2D view, Graphics2D g, float[][] distribution) {
        if (!view.isVisible()) {
            return;
        }
        this.w = view.getWidth();
        this.h = view.getHeight();
        this.createImage(this.w, this.h, view);
        int m = distribution.length;
        int n = distribution[0].length;
        float dx = (float)m / (float)this.w;
        float dy = (float)n / (float)this.h;
        int rc = 0;
        int gc = 0;
        int bc = 0;
        if (this.smooth) {
            int i = 0;
            while (i < this.w) {
                float x = (float)i * dx;
                int i0 = (int)x;
                int i1 = i0 + 1;
                if (i1 > m - 1) {
                    i1 = m - 1;
                }
                float s1 = x - (float)i0;
                float s0 = 1.0f - s1;
                int j = 0;
                while (j < this.h) {
                    float t1;
                    float t0;
                    float v;
                    float y = (float)j * dy;
                    int j0 = (int)y;
                    int j1 = j0 + 1;
                    if (j1 > n - 1) {
                        j1 = n - 1;
                    }
                    if ((v = (s0 * ((t0 = 1.0f - (t1 = y - (float)j0)) * distribution[i0][j0] + t1 * distribution[i0][j1]) + s1 * (t0 * distribution[i1][j0] + t1 * distribution[i1][j1]) - this.min) * this.scale) > (float)(this.rgbScale.length - 2)) {
                        v = this.rgbScale.length - 2;
                    } else if (v < 0.0f) {
                        v = 0.0f;
                    }
                    int iv = (int)v;
                    rc = (int)((float)this.rgbScale[iv][0] * (1.0f - (v -= (float)iv)) + (float)this.rgbScale[iv + 1][0] * v);
                    gc = (int)((float)this.rgbScale[iv][1] * (1.0f - v) + (float)this.rgbScale[iv + 1][1] * v);
                    bc = (int)((float)this.rgbScale[iv][2] * (1.0f - v) + (float)this.rgbScale[iv + 1][2] * v);
                    this.pixels[i + j * this.w] = 0xFF000000 | rc << 16 | gc << 8 | bc;
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.w) {
                int i0 = (int)((float)i * dx);
                int j = 0;
                while (j < this.h) {
                    int j0 = (int)((float)j * dy);
                    float v = (distribution[i0][j0] - this.min) * this.scale;
                    if (v > (float)(this.rgbScale.length - 2)) {
                        v = this.rgbScale.length - 2;
                    } else if (v < 0.0f) {
                        v = 0.0f;
                    }
                    int iv = (int)v;
                    rc = (int)((float)this.rgbScale[iv][0] * (1.0f - (v -= (float)iv)) + (float)this.rgbScale[iv + 1][0] * v);
                    gc = (int)((float)this.rgbScale[iv][1] * (1.0f - v) + (float)this.rgbScale[iv + 1][1] * v);
                    bc = (int)((float)this.rgbScale[iv][2] * (1.0f - v) + (float)this.rgbScale[iv + 1][2] * v);
                    this.pixels[i + j * this.w] = 0xFF000000 | rc << 16 | gc << 8 | bc;
                    ++j;
                }
                ++i;
            }
        }
        this.image.setRGB(0, 0, this.w, this.h, this.pixels, 0, this.w);
        g.drawImage((Image)this.image, 0, 0, view);
    }

    private void createImage(int w, int h, JComponent c) {
        if (this.image != null) {
            if (w != this.image.getWidth(c) || h != this.image.getHeight(c)) {
                this.image = new BufferedImage(w, h, 2);
                this.pixels = new int[w * h];
            }
        } else {
            this.image = new BufferedImage(w, h, 2);
            this.pixels = new int[w * h];
        }
    }
}

