/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.concord.energy2d.model.ParticleFeeder;
import org.concord.energy2d.undo.UndoTranslateManipulable;
import org.concord.energy2d.util.BackgroundComboBox;
import org.concord.energy2d.util.ColorFill;
import org.concord.energy2d.util.MiscUtil;
import org.concord.energy2d.view.View2D;

class ParticleFeederDialog
extends JDialog {
    private static final DecimalFormat FORMAT = new DecimalFormat("####.######");
    private JColorChooser colorChooser;
    private BackgroundComboBox particleColorComboBox;
    private BackgroundComboBox velocityColorComboBox;
    private JTextField xField;
    private JTextField yField;
    private JTextField uidField;
    private JTextField labelField;
    private JTextField periodField;
    private JTextField maximumField;
    private JTextField massField;
    private JTextField radiusField;
    private JCheckBox draggableCheckBox;
    private Window owner;
    private ActionListener okListener;

    ParticleFeederDialog(final View2D view, final ParticleFeeder particleFeeder, boolean modal) {
        super(JOptionPane.getFrameForComponent(view), "Particle Feeder (#" + view.model.getParticleFeeders().indexOf(particleFeeder) + ") Properties", modal);
        this.setDefaultCloseOperation(2);
        this.owner = this.getOwner();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                view.notifyManipulationListeners(particleFeeder, (byte)3);
                view.repaint();
                ParticleFeederDialog.this.dispose();
            }
        });
        this.okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean moved;
                float x = ParticleFeederDialog.this.parse(ParticleFeederDialog.this.xField.getText());
                if (Float.isNaN(x)) {
                    return;
                }
                float y = ParticleFeederDialog.this.parse(ParticleFeederDialog.this.yField.getText());
                if (Float.isNaN(y)) {
                    return;
                }
                float mass = ParticleFeederDialog.this.parse(ParticleFeederDialog.this.massField.getText());
                if (Float.isNaN(mass)) {
                    return;
                }
                float radius = ParticleFeederDialog.this.parse(ParticleFeederDialog.this.radiusField.getText());
                if (Float.isNaN(radius)) {
                    return;
                }
                float period = ParticleFeederDialog.this.parse(ParticleFeederDialog.this.periodField.getText());
                if (Float.isNaN(period)) {
                    return;
                }
                float maximum = ParticleFeederDialog.this.parse(ParticleFeederDialog.this.maximumField.getText());
                if (Float.isNaN(maximum)) {
                    return;
                }
                String uid = ParticleFeederDialog.this.uidField.getText();
                if (uid != null && !(uid = uid.trim()).equals("") && !uid.equals(particleFeeder.getUid()) && view.isUidUsed(uid)) {
                    JOptionPane.showMessageDialog(ParticleFeederDialog.this.owner, "UID: " + uid + " has been taken.", "Error", 0);
                    return;
                }
                float dx = 1.0E-6f * view.model.getLx();
                float dy = 1.0E-6f * view.model.getLy();
                boolean bl = moved = Math.abs(x - particleFeeder.getX()) > dx || Math.abs(view.model.getLy() - y - particleFeeder.getY()) > dy;
                if (moved) {
                    view.getUndoManager().addEdit(new UndoTranslateManipulable(view));
                }
                particleFeeder.setUid(uid);
                particleFeeder.setLabel(ParticleFeederDialog.this.labelField.getText());
                particleFeeder.setMass(mass);
                particleFeeder.setRadius(radius);
                particleFeeder.setCenter(x, view.model.getLy() - y);
                particleFeeder.setPeriod(period);
                particleFeeder.setMaximum(Math.round(maximum));
                particleFeeder.setDraggable(ParticleFeederDialog.this.draggableCheckBox.isSelected());
                view.notifyManipulationListeners(particleFeeder, (byte)3);
                view.setSelectedManipulable(view.getSelectedManipulable());
                view.repaint();
                ParticleFeederDialog.this.dispose();
            }
        };
        JPanel panel = new JPanel(new BorderLayout());
        this.setContentPane(panel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        panel.add((Component)buttonPanel, "South");
        this.draggableCheckBox = new JCheckBox("Draggable by user", particleFeeder.isDraggable());
        buttonPanel.add(this.draggableCheckBox);
        JButton button = new JButton("OK");
        button.addActionListener(this.okListener);
        buttonPanel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParticleFeederDialog.this.dispose();
            }
        });
        buttonPanel.add(button);
        JPanel p = new JPanel(new GridLayout(10, 2, 8, 8));
        p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)p, "Center");
        p.add(new JLabel("Unique ID:"));
        this.uidField = new JTextField(particleFeeder.getUid(), 10);
        this.uidField.addActionListener(this.okListener);
        p.add(this.uidField);
        p.add(new JLabel("Label:"));
        this.labelField = new JTextField(particleFeeder.getLabel(), 10);
        this.labelField.addActionListener(this.okListener);
        p.add(this.labelField);
        p.add(new JLabel("X (m):"));
        this.xField = new JTextField(FORMAT.format(particleFeeder.getX()), 10);
        this.xField.addActionListener(this.okListener);
        p.add(this.xField);
        p.add(new JLabel("Y (m):"));
        this.yField = new JTextField(FORMAT.format(view.model.getLy() - particleFeeder.getY()), 10);
        this.yField.addActionListener(this.okListener);
        p.add(this.yField);
        p.add(new JLabel("Mass (kg):"));
        this.massField = new JTextField(String.valueOf(particleFeeder.getMass()), 10);
        this.massField.addActionListener(this.okListener);
        p.add(this.massField);
        p.add(new JLabel("Radius (m):"));
        this.radiusField = new JTextField(String.valueOf(particleFeeder.getRadius()), 10);
        this.radiusField.addActionListener(this.okListener);
        p.add(this.radiusField);
        p.add(new JLabel("Feeding period (s):"));
        this.periodField = new JTextField(FORMAT.format(particleFeeder.getPeriod()), 10);
        this.periodField.addActionListener(this.okListener);
        p.add(this.periodField);
        p.add(new JLabel("Maximum particles:"));
        this.maximumField = new JTextField(String.valueOf(particleFeeder.getMaximum()), 10);
        this.maximumField.addActionListener(this.okListener);
        p.add(this.maximumField);
        p.add(new JLabel("Color:"));
        this.colorChooser = new JColorChooser();
        this.colorChooser.setColor(particleFeeder.getColor());
        this.particleColorComboBox = new BackgroundComboBox(this, this.colorChooser, null);
        this.particleColorComboBox.setToolTipText("Particle color");
        this.particleColorComboBox.setFillPattern(new ColorFill(particleFeeder.getColor()));
        this.particleColorComboBox.getColorMenu().setColorArrayAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = ParticleFeederDialog.this.particleColorComboBox.getColorMenu().getColor();
                particleFeeder.setColor(c);
                view.repaint();
                ParticleFeederDialog.this.particleColorComboBox.getColorMenu().firePropertyChange("Filling", null, new ColorFill(c));
            }
        });
        this.particleColorComboBox.getColorMenu().setMoreColorAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = ParticleFeederDialog.this.particleColorComboBox.getColorMenu().getColorChooser().getColor();
                particleFeeder.setColor(c);
                view.repaint();
                ParticleFeederDialog.this.particleColorComboBox.getColorMenu().firePropertyChange("Filling", null, new ColorFill(c));
            }
        });
        this.particleColorComboBox.getColorMenu().addHexColorListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = ParticleFeederDialog.this.particleColorComboBox.getColorMenu().getHexInputColor(particleFeeder.getColor());
                if (c == null) {
                    return;
                }
                particleFeeder.setColor(c);
                view.repaint();
                ParticleFeederDialog.this.particleColorComboBox.getColorMenu().firePropertyChange("Filling", null, new ColorFill(c));
            }
        });
        p.add(this.particleColorComboBox);
        p.add(new JLabel("Velocity Color:"));
        this.velocityColorComboBox = new BackgroundComboBox(this, this.colorChooser, null);
        this.velocityColorComboBox.setToolTipText("Velocity color");
        this.velocityColorComboBox.setFillPattern(new ColorFill(particleFeeder.getVelocityColor()));
        this.velocityColorComboBox.getColorMenu().setColorArrayAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = ParticleFeederDialog.this.velocityColorComboBox.getColorMenu().getColor();
                particleFeeder.setVelocityColor(c);
                view.repaint();
                ParticleFeederDialog.this.velocityColorComboBox.getColorMenu().firePropertyChange("Filling", null, new ColorFill(c));
            }
        });
        this.velocityColorComboBox.getColorMenu().setMoreColorAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = ParticleFeederDialog.this.velocityColorComboBox.getColorMenu().getColorChooser().getColor();
                particleFeeder.setVelocityColor(c);
                view.repaint();
                ParticleFeederDialog.this.velocityColorComboBox.getColorMenu().firePropertyChange("Filling", null, new ColorFill(c));
            }
        });
        this.velocityColorComboBox.getColorMenu().addHexColorListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = ParticleFeederDialog.this.velocityColorComboBox.getColorMenu().getHexInputColor(particleFeeder.getColor());
                if (c == null) {
                    return;
                }
                particleFeeder.setVelocityColor(c);
                view.repaint();
                ParticleFeederDialog.this.velocityColorComboBox.getColorMenu().firePropertyChange("Filling", null, new ColorFill(c));
            }
        });
        p.add(this.velocityColorComboBox);
        this.pack();
        this.setLocationRelativeTo(view);
    }

    private float parse(String s) {
        return MiscUtil.parse(this.owner, s);
    }
}

