/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.concord.energy2d.model.Particle;
import org.concord.energy2d.undo.UndoResizeManipulable;
import org.concord.energy2d.undo.UndoTranslateManipulable;
import org.concord.energy2d.util.BackgroundComboBox;
import org.concord.energy2d.util.ColorFill;
import org.concord.energy2d.util.MiscUtil;
import org.concord.energy2d.view.View2D;

class ParticleDialog
extends JDialog {
    private static final DecimalFormat FORMAT = new DecimalFormat("####.####");
    private Window owner;
    private JColorChooser colorChooser;
    private BackgroundComboBox particleColorComboBox;
    private BackgroundComboBox velocityColorComboBox;
    private JTextField uidField;
    private JTextField labelField;
    private JTextField rxField;
    private JTextField ryField;
    private JTextField vxField;
    private JTextField vyField;
    private JTextField thetaField;
    private JTextField omegaField;
    private JTextField massField;
    private JTextField radiusField;
    private JTextField temperatureField;
    private JComboBox<Boolean> draggableComboBox;
    private JComboBox<Boolean> movableComboBox;
    private ActionListener okListener;

    ParticleDialog(final View2D view, final Particle particle, boolean modal) {
        super(JOptionPane.getFrameForComponent(view), "Particle (#" + view.model.getParticles().indexOf(particle) + ") Properties", modal);
        this.setDefaultCloseOperation(2);
        this.owner = this.getOwner();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                view.notifyManipulationListeners(particle, (byte)3);
                view.repaint();
                ParticleDialog.this.dispose();
            }
        });
        this.okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean resized;
                boolean moved;
                float mass = ParticleDialog.this.parse(ParticleDialog.this.massField.getText());
                if (Float.isNaN(mass)) {
                    return;
                }
                float radius = ParticleDialog.this.parse(ParticleDialog.this.radiusField.getText());
                if (Float.isNaN(radius)) {
                    return;
                }
                float rx = ParticleDialog.this.parse(ParticleDialog.this.rxField.getText());
                if (Float.isNaN(rx)) {
                    return;
                }
                float ry = ParticleDialog.this.parse(ParticleDialog.this.ryField.getText());
                if (Float.isNaN(ry)) {
                    return;
                }
                float vx = ParticleDialog.this.parse(ParticleDialog.this.vxField.getText());
                if (Float.isNaN(vx)) {
                    return;
                }
                float vy = ParticleDialog.this.parse(ParticleDialog.this.vyField.getText());
                if (Float.isNaN(vy)) {
                    return;
                }
                float theta = ParticleDialog.this.parse(ParticleDialog.this.thetaField.getText());
                if (Float.isNaN(theta)) {
                    return;
                }
                float omega = ParticleDialog.this.parse(ParticleDialog.this.omegaField.getText());
                if (Float.isNaN(omega)) {
                    return;
                }
                String uid = ParticleDialog.this.uidField.getText();
                if (uid != null && !(uid = uid.trim()).equals("") && !uid.equals(particle.getUid()) && view.isUidUsed(uid)) {
                    JOptionPane.showMessageDialog(ParticleDialog.this.owner, "UID: " + uid + " has been taken.", "Error", 0);
                    return;
                }
                String tempText = ParticleDialog.this.temperatureField.getText();
                float temperature = "NaN".equals(tempText) ? Float.NaN : ParticleDialog.this.parse(tempText);
                String label = ParticleDialog.this.labelField.getText();
                float dx = 1.0E-6f * view.model.getLx();
                float dy = 1.0E-6f * view.model.getLy();
                boolean bl = moved = Math.abs(rx - particle.getRx()) > dx || Math.abs(view.model.getLy() - ry - particle.getRy()) > dy;
                if (moved) {
                    view.getUndoManager().addEdit(new UndoTranslateManipulable(view));
                }
                boolean bl2 = resized = Math.abs(radius - particle.getRadius()) > dx;
                if (resized) {
                    view.getUndoManager().addEdit(new UndoResizeManipulable(view));
                }
                particle.setUid(uid);
                particle.setLabel(label);
                particle.setMass(mass);
                particle.setRadius(radius);
                particle.setTemperature(temperature);
                particle.setRx(rx);
                particle.setRy(view.model.getLy() - ry);
                particle.setVx(vx);
                particle.setVy(-vy);
                particle.setTheta((float)Math.toRadians(theta));
                particle.setOmega((float)Math.toRadians(omega));
                particle.setDraggable(ParticleDialog.this.draggableComboBox.getSelectedItem() == Boolean.TRUE);
                particle.setMovable(ParticleDialog.this.movableComboBox.getSelectedItem() == Boolean.TRUE);
                view.notifyManipulationListeners(particle, (byte)3);
                view.setSelectedManipulable(view.getSelectedManipulable());
                view.repaint();
                ParticleDialog.this.dispose();
            }
        };
        JPanel panel = new JPanel(new BorderLayout());
        this.setContentPane(panel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        panel.add((Component)buttonPanel, "South");
        JButton button = new JButton("OK");
        button.addActionListener(this.okListener);
        buttonPanel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParticleDialog.this.dispose();
            }
        });
        buttonPanel.add(button);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)box, "Center");
        JPanel p = new JPanel(new GridLayout(15, 2, 5, 5));
        box.add(p);
        p.add(new JLabel("Unique ID:"));
        this.uidField = new JTextField(particle.getUid(), 10);
        this.uidField.addActionListener(this.okListener);
        p.add(this.uidField);
        p.add(new JLabel("Label:"));
        this.labelField = new JTextField(particle.getLabel(), 10);
        this.labelField.addActionListener(this.okListener);
        p.add(this.labelField);
        p.add(new JLabel("Mass (kg):"));
        this.massField = new JTextField(String.valueOf(particle.getMass()), 10);
        this.massField.addActionListener(this.okListener);
        p.add(this.massField);
        p.add(new JLabel("Radius (m):"));
        this.radiusField = new JTextField(View2D.COORDINATES_FORMAT.format(particle.getRadius()), 10);
        this.radiusField.addActionListener(this.okListener);
        p.add(this.radiusField);
        p.add(new JLabel("<html>Temperature (&deg;C):</html>"));
        this.temperatureField = new JTextField(String.valueOf(particle.getTemperature()), 10);
        this.temperatureField.addActionListener(this.okListener);
        p.add(this.temperatureField);
        p.add(new JLabel("Rx (m):"));
        this.rxField = new JTextField(View2D.COORDINATES_FORMAT.format(particle.getRx()), 10);
        this.rxField.addActionListener(this.okListener);
        p.add(this.rxField);
        p.add(new JLabel("Ry (m):"));
        this.ryField = new JTextField(View2D.COORDINATES_FORMAT.format(view.model.getLy() - particle.getRy()), 10);
        this.ryField.addActionListener(this.okListener);
        p.add(this.ryField);
        p.add(new JLabel("Vx (m/s):"));
        this.vxField = new JTextField(View2D.VELOCITY_FORMAT.format(particle.getVx()), 10);
        this.vxField.addActionListener(this.okListener);
        p.add(this.vxField);
        p.add(new JLabel("Vy (m/s):"));
        this.vyField = new JTextField(View2D.VELOCITY_FORMAT.format(-particle.getVy()), 10);
        this.vyField.addActionListener(this.okListener);
        p.add(this.vyField);
        p.add(new JLabel("<html>&theta; (&deg;):</html>"));
        this.thetaField = new JTextField(FORMAT.format(Math.toDegrees(particle.getTheta())), 10);
        this.thetaField.addActionListener(this.okListener);
        p.add(this.thetaField);
        p.add(new JLabel("<html>&omega; (&deg;/s):</html>"));
        this.omegaField = new JTextField(FORMAT.format(Math.toDegrees(particle.getOmega())), 10);
        this.omegaField.addActionListener(this.okListener);
        p.add(this.omegaField);
        p.add(new JLabel("Color:"));
        this.colorChooser = new JColorChooser();
        this.colorChooser.setColor(particle.getColor());
        this.particleColorComboBox = new BackgroundComboBox(this, this.colorChooser, null);
        this.particleColorComboBox.setToolTipText("Particle color");
        this.particleColorComboBox.setFillPattern(new ColorFill(particle.getColor()));
        this.particleColorComboBox.getColorMenu().setColorArrayAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = ParticleDialog.this.particleColorComboBox.getColorMenu().getColor();
                particle.setColor(c);
                view.repaint();
                ParticleDialog.this.particleColorComboBox.getColorMenu().firePropertyChange("Filling", null, new ColorFill(c));
            }
        });
        this.particleColorComboBox.getColorMenu().setMoreColorAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = ParticleDialog.this.particleColorComboBox.getColorMenu().getColorChooser().getColor();
                particle.setColor(c);
                view.repaint();
                ParticleDialog.this.particleColorComboBox.getColorMenu().firePropertyChange("Filling", null, new ColorFill(c));
            }
        });
        this.particleColorComboBox.getColorMenu().addHexColorListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = ParticleDialog.this.particleColorComboBox.getColorMenu().getHexInputColor(particle.getColor());
                if (c == null) {
                    return;
                }
                particle.setColor(c);
                view.repaint();
                ParticleDialog.this.particleColorComboBox.getColorMenu().firePropertyChange("Filling", null, new ColorFill(c));
            }
        });
        p.add(this.particleColorComboBox);
        p.add(new JLabel("Velocity Color:"));
        this.velocityColorComboBox = new BackgroundComboBox(this, this.colorChooser, null);
        this.velocityColorComboBox.setToolTipText("Velocity color");
        this.velocityColorComboBox.setFillPattern(new ColorFill(particle.getVelocityColor()));
        this.velocityColorComboBox.getColorMenu().setColorArrayAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = ParticleDialog.this.velocityColorComboBox.getColorMenu().getColor();
                particle.setVelocityColor(c);
                view.repaint();
                ParticleDialog.this.velocityColorComboBox.getColorMenu().firePropertyChange("Filling", null, new ColorFill(c));
            }
        });
        this.velocityColorComboBox.getColorMenu().setMoreColorAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = ParticleDialog.this.velocityColorComboBox.getColorMenu().getColorChooser().getColor();
                particle.setVelocityColor(c);
                view.repaint();
                ParticleDialog.this.velocityColorComboBox.getColorMenu().firePropertyChange("Filling", null, new ColorFill(c));
            }
        });
        this.velocityColorComboBox.getColorMenu().addHexColorListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = ParticleDialog.this.velocityColorComboBox.getColorMenu().getHexInputColor(particle.getColor());
                if (c == null) {
                    return;
                }
                particle.setVelocityColor(c);
                view.repaint();
                ParticleDialog.this.velocityColorComboBox.getColorMenu().firePropertyChange("Filling", null, new ColorFill(c));
            }
        });
        p.add(this.velocityColorComboBox);
        p.add(new JLabel("Movable:"));
        this.movableComboBox = new JComboBox();
        this.movableComboBox.addItem(Boolean.TRUE);
        this.movableComboBox.addItem(Boolean.FALSE);
        this.movableComboBox.setSelectedIndex(particle.isMovable() ? 0 : 1);
        p.add(this.movableComboBox);
        p.add(new JLabel("Draggable by User:"));
        this.draggableComboBox = new JComboBox();
        this.draggableComboBox.addItem(Boolean.TRUE);
        this.draggableComboBox.addItem(Boolean.FALSE);
        this.draggableComboBox.setSelectedIndex(particle.isDraggable() ? 0 : 1);
        p.add(this.draggableComboBox);
        this.pack();
        this.setLocationRelativeTo(view);
    }

    private float parse(String s) {
        return MiscUtil.parse(this.owner, s);
    }
}

