/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.util.BackgroundComboBox;
import org.concord.energy2d.util.ColorFill;
import org.concord.energy2d.util.FillPattern;
import org.concord.energy2d.util.Texture;
import org.concord.energy2d.util.TextureChooser;
import org.concord.energy2d.view.View2D;

class PartViewDialog
extends JDialog {
    private JColorChooser colorChooser;
    private TextureChooser textureChooser;
    private JCheckBox visibleCheckBox;
    private JCheckBox draggableCheckBox;
    private JCheckBox seeThroughCheckBox;
    private BackgroundComboBox bgComboBox;
    private ActionListener okListener;

    PartViewDialog(final View2D view, final Part part, boolean modal) {
        super(JOptionPane.getFrameForComponent(view), "Part (#" + view.model.getParts().indexOf(part) + ") View Options", modal);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                view.notifyManipulationListeners(part, (byte)3);
                view.repaint();
                PartViewDialog.this.dispose();
            }
        });
        this.okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                part.setDraggable(PartViewDialog.this.draggableCheckBox.isSelected());
                part.setVisible(PartViewDialog.this.visibleCheckBox.isSelected());
                part.setFilled(!PartViewDialog.this.seeThroughCheckBox.isSelected());
                view.notifyManipulationListeners(part, (byte)3);
                view.setSelectedManipulable(view.getSelectedManipulable());
                view.repaint();
                PartViewDialog.this.dispose();
            }
        };
        JPanel panel = new JPanel(new BorderLayout());
        this.setContentPane(panel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        panel.add((Component)buttonPanel, "South");
        JButton button = new JButton("OK");
        button.addActionListener(this.okListener);
        buttonPanel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartViewDialog.this.dispose();
            }
        });
        buttonPanel.add(button);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)box, "Center");
        Box miscBox = Box.createVerticalBox();
        miscBox.setBorder(BorderFactory.createTitledBorder("General"));
        box.add(miscBox);
        JPanel p = new JPanel(new FlowLayout(0));
        miscBox.add(p);
        p.add(new JLabel("Filling"));
        this.colorChooser = new JColorChooser();
        this.textureChooser = new TextureChooser();
        FillPattern fp = part.getFillPattern();
        if (fp instanceof ColorFill) {
            Color bgColor = ((ColorFill)fp).getColor();
            this.colorChooser.setColor(bgColor);
            this.textureChooser.setSelectedBackgroundColor(bgColor);
        } else if (fp instanceof Texture) {
            Texture texture = (Texture)fp;
            this.textureChooser.setSelectedBackgroundColor(new Color(texture.getBackground()));
            this.textureChooser.setSelectedForegroundColor(new Color(texture.getForeground()));
            this.textureChooser.setSelectedStyle(texture.getStyle(), texture.getCellWidth(), texture.getCellHeight());
        }
        this.bgComboBox = new BackgroundComboBox(this, part.isFilled(), this.colorChooser, this.textureChooser);
        this.bgComboBox.setToolTipText("Background filling");
        this.bgComboBox.setFillPattern(part.getFillPattern());
        this.bgComboBox.getColorMenu().setNoFillAction(new AbstractAction("No Fill"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object src = e.getSource();
                if (src instanceof JCheckBoxMenuItem) {
                    JCheckBoxMenuItem cbmi = (JCheckBoxMenuItem)src;
                    part.setFilled(!cbmi.isSelected());
                    view.repaint();
                    PartViewDialog.this.bgComboBox.getColorMenu().firePropertyChange("Filling", null, null);
                }
            }
        });
        this.bgComboBox.getColorMenu().setColorArrayAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorFill fp = new ColorFill(PartViewDialog.this.bgComboBox.getColorMenu().getColor());
                if (((Object)fp).equals(part.getFillPattern())) {
                    return;
                }
                part.setFillPattern(fp);
                view.repaint();
                PartViewDialog.this.bgComboBox.getColorMenu().firePropertyChange("Filling", null, fp);
            }
        });
        this.bgComboBox.getColorMenu().setMoreColorAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorFill fp = new ColorFill(PartViewDialog.this.bgComboBox.getColorMenu().getColorChooser().getColor());
                if (((Object)fp).equals(part.getFillPattern())) {
                    return;
                }
                part.setFillPattern(fp);
                view.repaint();
                PartViewDialog.this.bgComboBox.getColorMenu().firePropertyChange("Filling", null, fp);
            }
        });
        this.bgComboBox.getColorMenu().addHexColorListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = PartViewDialog.this.bgComboBox.getColorMenu().getHexInputColor(part.getFillPattern() instanceof ColorFill ? ((ColorFill)part.getFillPattern()).getColor() : null);
                if (c == null) {
                    return;
                }
                ColorFill fp = new ColorFill(c);
                if (((Object)fp).equals(part.getFillPattern())) {
                    return;
                }
                part.setFillPattern(fp);
                view.repaint();
                PartViewDialog.this.bgComboBox.getColorMenu().firePropertyChange("Filling", null, fp);
            }
        });
        this.bgComboBox.getColorMenu().setTextureActions(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FillPattern fp = PartViewDialog.this.bgComboBox.getColorMenu().getTextureChooser().getFillPattern();
                if (fp != null && fp.equals(part.getFillPattern())) {
                    return;
                }
                part.setFillPattern(fp);
                view.repaint();
                PartViewDialog.this.bgComboBox.getColorMenu().firePropertyChange("Filling", null, fp);
            }
        }, null);
        p.add(this.bgComboBox);
        this.visibleCheckBox = new JCheckBox("Visible", part.isVisible());
        p.add(this.visibleCheckBox);
        this.seeThroughCheckBox = new JCheckBox("See through", !part.isFilled());
        p.add(this.seeThroughCheckBox);
        this.draggableCheckBox = new JCheckBox("Draggable by user", part.isDraggable());
        p.add(this.draggableCheckBox);
        this.pack();
        this.setLocationRelativeTo(view);
    }
}

