/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.concord.energy2d.math.Blob2D;
import org.concord.energy2d.math.Polygon2D;
import org.concord.energy2d.math.Ring2D;
import org.concord.energy2d.math.TransformableShape;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.undo.UndoFlipManipulable;
import org.concord.energy2d.undo.UndoResizeManipulable;
import org.concord.energy2d.undo.UndoRotateManipulable;
import org.concord.energy2d.undo.UndoScaleManipulable;
import org.concord.energy2d.undo.UndoShearManipulable;
import org.concord.energy2d.undo.UndoTranslateManipulable;
import org.concord.energy2d.util.MiscUtil;
import org.concord.energy2d.view.ThermostatDialog;
import org.concord.energy2d.view.View2D;

class PartModelDialog
extends JDialog {
    private static final DecimalFormat FORMAT = new DecimalFormat("####.######");
    private JTextField thermalConductivityField;
    private JTextField specificHeatField;
    private JTextField densityField;
    private JLabel powerLabel;
    private JTextField powerField;
    private JTextField temperatureCoefficientField;
    private JTextField referenceTemperatureField;
    private JLabel temperatureLabel;
    private JTextField temperatureField;
    private JTextField windSpeedField;
    private JTextField windAngleField;
    private JRadioButton noScatteringRadioButton;
    private JRadioButton visibleScatteringRadioButton;
    private JRadioButton invisibleScatteringRadioButton;
    private JTextField emissivityField;
    private JTextField absorptivityField;
    private JTextField reflectivityField;
    private JTextField transmissivityField;
    private JTextField elasticityField;
    private JTextField xField;
    private JTextField yField;
    private JTextField wField;
    private JTextField hField;
    private JTextField angleField;
    private JTextField scaleXField;
    private JTextField scaleYField;
    private JTextField shearXField;
    private JTextField shearYField;
    private JTextField innerDiameterField;
    private JTextField outerDiameterField;
    private JCheckBox flipXCheckBox;
    private JCheckBox flipYCheckBox;
    private JTextField uidField;
    private JTextField labelField;
    private JRadioButton notHeatSourceRadioButton;
    private JRadioButton powerRadioButton;
    private JRadioButton constantTemperatureRadioButton;
    private Window owner;
    private ActionListener okListener;

    PartModelDialog(final View2D view, final Part part, boolean modal) {
        super(JOptionPane.getFrameForComponent(view), "Part (#" + view.model.getParts().indexOf(part) + ") Properties", modal);
        this.setDefaultCloseOperation(2);
        this.owner = this.getOwner();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                view.notifyManipulationListeners(part, (byte)3);
                view.repaint();
                PartModelDialog.this.dispose();
            }
        });
        this.okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PartModelDialog.this.powerRadioButton.isSelected() && PartModelDialog.this.powerField.getText().equals("0")) {
                    PartModelDialog.this.powerField.selectAll();
                    JOptionPane.showMessageDialog(PartModelDialog.this.owner, "Did you forget to set the power of the source?", "Reminder", 1);
                    PartModelDialog.this.powerField.requestFocusInWindow();
                    return;
                }
                boolean visibleScattering = PartModelDialog.this.visibleScatteringRadioButton.isSelected();
                boolean invisibleScattering = PartModelDialog.this.invisibleScatteringRadioButton.isSelected();
                boolean scattering = visibleScattering || invisibleScattering;
                float absorptivity = PartModelDialog.this.parse(PartModelDialog.this.absorptivityField.getText());
                if (Float.isNaN(absorptivity)) {
                    return;
                }
                float reflectivity = PartModelDialog.this.parse(PartModelDialog.this.reflectivityField.getText());
                if (Float.isNaN(reflectivity)) {
                    return;
                }
                float transmissivity = PartModelDialog.this.parse(PartModelDialog.this.transmissivityField.getText());
                if (Float.isNaN(transmissivity)) {
                    return;
                }
                float emissivity = PartModelDialog.this.parse(PartModelDialog.this.emissivityField.getText());
                if (Float.isNaN(emissivity)) {
                    return;
                }
                float elasticity = PartModelDialog.this.parse(PartModelDialog.this.elasticityField.getText());
                if (Float.isNaN(elasticity)) {
                    return;
                }
                if (absorptivity < 0.0f || absorptivity > 1.0f) {
                    JOptionPane.showMessageDialog(PartModelDialog.this.owner, "Absorptivity must be within [0, 1].", "Error", 0);
                    return;
                }
                if (reflectivity < 0.0f || reflectivity > 1.0f) {
                    JOptionPane.showMessageDialog(PartModelDialog.this.owner, "Reflectivity must be within [0, 1].", "Error", 0);
                    return;
                }
                if (transmissivity < 0.0f || transmissivity > 1.0f) {
                    JOptionPane.showMessageDialog(PartModelDialog.this.owner, "Transmissivity must be within [0, 1].", "Error", 0);
                    return;
                }
                if (emissivity < 0.0f || emissivity > 1.0f) {
                    JOptionPane.showMessageDialog(PartModelDialog.this.owner, "Emissivity must be within [0, 1].", "Error", 0);
                    return;
                }
                float sum = absorptivity + reflectivity + transmissivity;
                if ((double)Math.abs(sum - 1.0f) > 0.01) {
                    JOptionPane.showMessageDialog(PartModelDialog.this.owner, "The sum of absorptivity, reflectivity, and transmissivity must be exactly one.", "Error", 0);
                    return;
                }
                if (elasticity < 0.0f || elasticity > 1.0f) {
                    JOptionPane.showMessageDialog(PartModelDialog.this.owner, "Elasticity must be within [0, 1].", "Error", 0);
                    return;
                }
                float conductivity = PartModelDialog.this.parse(PartModelDialog.this.thermalConductivityField.getText());
                if (Float.isNaN(conductivity)) {
                    return;
                }
                float specificHeat = PartModelDialog.this.parse(PartModelDialog.this.specificHeatField.getText());
                if (Float.isNaN(specificHeat)) {
                    return;
                }
                if (specificHeat <= 0.0f) {
                    JOptionPane.showMessageDialog(PartModelDialog.this.owner, "Specific heat must be greater than zero.", "Error", 0);
                    return;
                }
                float density = PartModelDialog.this.parse(PartModelDialog.this.densityField.getText());
                if (Float.isNaN(density)) {
                    return;
                }
                if (density <= 0.0f) {
                    JOptionPane.showMessageDialog(PartModelDialog.this.owner, "Density must be greater than zero.", "Error", 0);
                    return;
                }
                float windSpeed = PartModelDialog.this.parse(PartModelDialog.this.windSpeedField.getText());
                if (Float.isNaN(windSpeed)) {
                    return;
                }
                float windAngle = PartModelDialog.this.parse(PartModelDialog.this.windAngleField.getText());
                if (Float.isNaN(windAngle)) {
                    return;
                }
                float xcenter = PartModelDialog.this.parse(PartModelDialog.this.xField.getText());
                if (Float.isNaN(xcenter)) {
                    return;
                }
                float ycenter = PartModelDialog.this.parse(PartModelDialog.this.yField.getText());
                if (Float.isNaN(ycenter)) {
                    return;
                }
                float width = Float.NaN;
                if (PartModelDialog.this.wField != null && Float.isNaN(width = PartModelDialog.this.parse(PartModelDialog.this.wField.getText()))) {
                    return;
                }
                float height = Float.NaN;
                if (PartModelDialog.this.hField != null && Float.isNaN(height = PartModelDialog.this.parse(PartModelDialog.this.hField.getText()))) {
                    return;
                }
                float innerDiameter = Float.NaN;
                if (PartModelDialog.this.innerDiameterField != null && Float.isNaN(innerDiameter = PartModelDialog.this.parse(PartModelDialog.this.innerDiameterField.getText()))) {
                    return;
                }
                float outerDiameter = Float.NaN;
                if (PartModelDialog.this.outerDiameterField != null && Float.isNaN(outerDiameter = PartModelDialog.this.parse(PartModelDialog.this.outerDiameterField.getText()))) {
                    return;
                }
                float degree = Float.NaN;
                if (PartModelDialog.this.angleField != null && Float.isNaN(degree = PartModelDialog.this.parse(PartModelDialog.this.angleField.getText()))) {
                    return;
                }
                float scaleX = Float.NaN;
                if (PartModelDialog.this.scaleXField != null) {
                    scaleX = PartModelDialog.this.parse(PartModelDialog.this.scaleXField.getText());
                    if (Float.isNaN(scaleX)) {
                        return;
                    }
                    if (scaleX <= 0.0f) {
                        JOptionPane.showMessageDialog(PartModelDialog.this.owner, "Scale X must be positive.", "Error", 0);
                        return;
                    }
                }
                float scaleY = Float.NaN;
                if (PartModelDialog.this.scaleYField != null) {
                    scaleY = PartModelDialog.this.parse(PartModelDialog.this.scaleYField.getText());
                    if (Float.isNaN(scaleY)) {
                        return;
                    }
                    if (scaleY <= 0.0f) {
                        JOptionPane.showMessageDialog(PartModelDialog.this.owner, "Scale Y must be positive.", "Error", 0);
                        return;
                    }
                }
                float shearX = Float.NaN;
                if (PartModelDialog.this.shearXField != null && Float.isNaN(shearX = PartModelDialog.this.parse(PartModelDialog.this.shearXField.getText()))) {
                    return;
                }
                float shearY = Float.NaN;
                if (PartModelDialog.this.shearYField != null && Float.isNaN(shearY = PartModelDialog.this.parse(PartModelDialog.this.shearYField.getText()))) {
                    return;
                }
                String uid = PartModelDialog.this.uidField.getText();
                if (uid != null && !(uid = uid.trim()).equals("") && !uid.equals(part.getUid()) && view.isUidUsed(uid)) {
                    JOptionPane.showMessageDialog(PartModelDialog.this.owner, "UID: " + uid + " has been taken.", "Error", 0);
                    return;
                }
                float temperature = PartModelDialog.this.parse(PartModelDialog.this.temperatureField.getText());
                if (Float.isNaN(temperature)) {
                    return;
                }
                part.setTemperature(temperature);
                float power = PartModelDialog.this.parse(PartModelDialog.this.powerField.getText());
                if (PartModelDialog.this.notHeatSourceRadioButton.isSelected() || PartModelDialog.this.constantTemperatureRadioButton.isSelected()) {
                    part.setPower(0.0f);
                } else if (PartModelDialog.this.powerRadioButton.isSelected()) {
                    if (Float.isNaN(power)) {
                        return;
                    }
                    part.setPower(power);
                }
                float temperatureCoefficient = PartModelDialog.this.parse(PartModelDialog.this.temperatureCoefficientField.getText());
                if (Float.isNaN(temperatureCoefficient)) {
                    return;
                }
                part.setThermistorTemperatureCoefficient(temperatureCoefficient);
                float referenceTemperature = PartModelDialog.this.parse(PartModelDialog.this.referenceTemperatureField.getText());
                if (Float.isNaN(referenceTemperature)) {
                    return;
                }
                part.setThermistorReferenceTemperature(referenceTemperature);
                part.setConstantTemperature(PartModelDialog.this.constantTemperatureRadioButton.isSelected());
                Shape shape = part.getShape();
                if (shape instanceof RectangularShape) {
                    if (!Float.isNaN(width) && !Float.isNaN(height)) {
                        boolean resized;
                        Point2D.Float oldCenter = part.getCenter();
                        float x = xcenter - 0.5f * width;
                        float y = view.model.getLy() - ycenter - 0.5f * height;
                        float dx = 1.0E-6f * view.model.getLx();
                        float dy = 1.0E-6f * view.model.getLy();
                        boolean moved = Math.abs(x - oldCenter.x) > dx || Math.abs(y - oldCenter.y) > dy;
                        boolean bl = resized = Math.abs((double)width - shape.getBounds2D().getWidth()) > (double)dx || Math.abs((double)height - shape.getBounds2D().getHeight()) > (double)dy;
                        if (resized) {
                            view.getUndoManager().addEdit(new UndoResizeManipulable(view));
                        } else if (moved) {
                            view.getUndoManager().addEdit(new UndoTranslateManipulable(view));
                        }
                        if (moved || resized) {
                            view.resizeManipulableTo(part, x, y, width, height, 0.0f, 0.0f);
                        }
                    }
                } else if (shape instanceof TransformableShape) {
                    TransformableShape s = (TransformableShape)shape;
                    if (!Float.isNaN(xcenter) && !Float.isNaN(ycenter)) {
                        boolean moved;
                        Point2D.Float oldCenter = s.getCenter();
                        float dx = 1.0E-6f * view.model.getLx();
                        float dy = 1.0E-6f * view.model.getLy();
                        boolean bl = moved = Math.abs(xcenter - oldCenter.x) > dx || Math.abs(ycenter - oldCenter.y) > dy;
                        if (moved) {
                            view.getUndoManager().addEdit(new UndoTranslateManipulable(view));
                            s.flipY();
                            s.translateBy(xcenter - s.getCenter().x, ycenter - s.getCenter().y);
                            float ly = view.model.getLy();
                            if (s instanceof Polygon2D) {
                                Polygon2D p = (Polygon2D)s;
                                int n = p.getVertexCount();
                                int i = 0;
                                while (i < n) {
                                    Point2D.Float v = p.getVertex(i);
                                    v.y = ly - v.y;
                                    ++i;
                                }
                            } else if (s instanceof Blob2D) {
                                Blob2D b = (Blob2D)s;
                                int n = b.getPointCount();
                                int i = 0;
                                while (i < n) {
                                    Point2D.Float v = b.getPoint(i);
                                    v.y = ly - v.y;
                                    ++i;
                                }
                            }
                        }
                    }
                    if (!Float.isNaN(degree) && degree != 0.0f) {
                        view.getUndoManager().addEdit(new UndoRotateManipulable(view, degree));
                        s.rotateBy(degree);
                    }
                    if (!Float.isNaN(scaleX) && scaleX != 1.0f) {
                        view.getUndoManager().addEdit(new UndoScaleManipulable(view, scaleX, 0));
                        s.scaleX(scaleX);
                    }
                    if (!Float.isNaN(scaleY) && scaleY != 1.0f) {
                        view.getUndoManager().addEdit(new UndoScaleManipulable(view, scaleY, 1));
                        s.scaleY(scaleY);
                    }
                    if (!Float.isNaN(shearX) && shearX != 0.0f) {
                        view.getUndoManager().addEdit(new UndoShearManipulable(view, shearX, 0));
                        s.shearX(shearX);
                    }
                    if (!Float.isNaN(shearY) && shearY != 0.0f) {
                        view.getUndoManager().addEdit(new UndoShearManipulable(view, shearY, 1));
                        s.shearY(shearY);
                    }
                    if (PartModelDialog.this.flipXCheckBox.isSelected()) {
                        view.getUndoManager().addEdit(new UndoFlipManipulable(view, 0));
                        s.flipX();
                    }
                    if (PartModelDialog.this.flipYCheckBox.isSelected()) {
                        view.getUndoManager().addEdit(new UndoFlipManipulable(view, 1));
                        s.flipY();
                    }
                    if (s instanceof Blob2D) {
                        ((Blob2D)s).update();
                    }
                } else if (shape instanceof Ring2D && !Float.isNaN(innerDiameter) && !Float.isNaN(outerDiameter)) {
                    view.resizeManipulableTo(part, xcenter, view.model.getLy() - ycenter, innerDiameter, outerDiameter, 0.0f, 0.0f);
                }
                part.setWindAngle((float)Math.toRadians(windAngle));
                part.setWindSpeed(windSpeed);
                part.setThermalConductivity(Math.max(conductivity, 1.0E-9f));
                part.setSpecificHeat(specificHeat);
                part.setDensity(density);
                part.setAbsorptivity(absorptivity);
                part.setReflectivity(reflectivity);
                part.setTransmissivity(transmissivity);
                part.setEmissivity(emissivity);
                part.setScattering(scattering);
                part.setScatteringVisible(visibleScattering);
                part.setElasticity(elasticity);
                part.setLabel(PartModelDialog.this.labelField.getText());
                part.setUid(uid);
                view.notifyManipulationListeners(part, (byte)3);
                view.setSelectedManipulable(view.getSelectedManipulable());
                view.repaint();
                PartModelDialog.this.dispose();
            }
        };
        JPanel panel = new JPanel(new BorderLayout());
        this.setContentPane(panel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        panel.add((Component)buttonPanel, "South");
        JButton button = new JButton("OK");
        button.addActionListener(this.okListener);
        buttonPanel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PartModelDialog.this.dispose();
            }
        });
        buttonPanel.add(button);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)tabbedPane, "Center");
        JPanel p = new JPanel(new SpringLayout());
        JPanel pp = new JPanel(new BorderLayout());
        pp.add((Component)p, "North");
        tabbedPane.add((Component)pp, "Geometry");
        int count = 0;
        p.add(new JLabel("Center x"));
        this.xField = new JTextField(FORMAT.format(part.getCenter().x));
        this.xField.addActionListener(this.okListener);
        p.add(this.xField);
        p.add(new JLabel(part.getShape() instanceof Polygon2D ? "<html><i>m</i> (" + ((Polygon2D)part.getShape()).getVertexCount() + " points)</html>" : "<html><i>m</i></html>"));
        p.add(new JLabel("Center y"));
        this.yField = new JTextField(FORMAT.format(view.model.getLy() - part.getCenter().y));
        this.yField.addActionListener(this.okListener);
        p.add(this.yField);
        p.add(new JLabel("<html><i>m</i></html>"));
        ++count;
        Shape shape = part.getShape();
        if (shape instanceof RectangularShape) {
            p.add(new JLabel("Width"));
            this.wField = new JTextField(FORMAT.format(shape.getBounds2D().getWidth()));
            this.wField.addActionListener(this.okListener);
            p.add(this.wField);
            p.add(new JLabel("<html><i>m</i></html>"));
            p.add(new JLabel("Height"));
            this.hField = new JTextField(FORMAT.format(shape.getBounds2D().getHeight()));
            this.hField.addActionListener(this.okListener);
            p.add(this.hField);
            p.add(new JLabel("<html><i>m</i></html>"));
            ++count;
        } else if (shape instanceof TransformableShape) {
            p.add(new JLabel("Rotate"));
            this.angleField = new JTextField("0");
            this.angleField.addActionListener(this.okListener);
            p.add(this.angleField);
            p.add(new JLabel("<html>&deg;</html>"));
            p.add(new JLabel("Flip"));
            this.flipXCheckBox = new JCheckBox("Horizontal");
            p.add(this.flipXCheckBox);
            this.flipYCheckBox = new JCheckBox("Vertical");
            p.add(this.flipYCheckBox);
            ++count;
            p.add(new JLabel("Shear X"));
            this.shearXField = new JTextField("0");
            this.shearXField.addActionListener(this.okListener);
            p.add(this.shearXField);
            p.add(new JLabel());
            p.add(new JLabel("Shear Y"));
            this.shearYField = new JTextField("0");
            this.shearYField.addActionListener(this.okListener);
            p.add(this.shearYField);
            p.add(new JLabel());
            ++count;
            p.add(new JLabel("Scale X"));
            this.scaleXField = new JTextField("1");
            this.scaleXField.addActionListener(this.okListener);
            p.add(this.scaleXField);
            p.add(new JLabel("Must be > 0"));
            p.add(new JLabel("Scale Y"));
            this.scaleYField = new JTextField("1");
            this.scaleYField.addActionListener(this.okListener);
            p.add(this.scaleYField);
            p.add(new JLabel("Must be > 0"));
            ++count;
        } else if (shape instanceof Ring2D) {
            Ring2D ring = (Ring2D)shape;
            p.add(new JLabel("Inner diameter"));
            this.innerDiameterField = new JTextField(FORMAT.format(ring.getInnerDiameter()));
            this.innerDiameterField.addActionListener(this.okListener);
            p.add(this.innerDiameterField);
            p.add(new JLabel("<html><i>m</i></html>"));
            p.add(new JLabel("Outer diameter"));
            this.outerDiameterField = new JTextField(FORMAT.format(ring.getOuterDiameter()));
            this.outerDiameterField.addActionListener(this.okListener);
            p.add(this.outerDiameterField);
            p.add(new JLabel("<html><i>m</i></html>"));
            ++count;
        }
        MiscUtil.makeCompactGrid(p, count, 6, 5, 5, 10, 2);
        p = new JPanel(new FlowLayout(0, 0, 0));
        pp = new JPanel(new BorderLayout());
        pp.add((Component)p, "North");
        tabbedPane.add((Component)pp, "Source");
        ButtonGroup bg = new ButtonGroup();
        this.notHeatSourceRadioButton = new JRadioButton("Not a heat source");
        this.notHeatSourceRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PartModelDialog.this.temperatureLabel.setEnabled(true);
                    PartModelDialog.this.temperatureField.setEnabled(true);
                    PartModelDialog.this.powerLabel.setText("Power density");
                    PartModelDialog.this.powerLabel.setEnabled(false);
                    PartModelDialog.this.powerField.setEnabled(false);
                    PartModelDialog.this.powerField.setText("0");
                }
            }
        });
        p.add(this.notHeatSourceRadioButton);
        bg.add(this.notHeatSourceRadioButton);
        this.constantTemperatureRadioButton = new JRadioButton("Constant temperature");
        this.constantTemperatureRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PartModelDialog.this.temperatureLabel.setEnabled(true);
                    PartModelDialog.this.temperatureField.setEnabled(true);
                    PartModelDialog.this.powerLabel.setText("Power density");
                    PartModelDialog.this.powerLabel.setEnabled(false);
                    PartModelDialog.this.powerField.setEnabled(false);
                    PartModelDialog.this.powerField.setText("0");
                }
            }
        });
        p.add(this.constantTemperatureRadioButton);
        bg.add(this.constantTemperatureRadioButton);
        this.powerRadioButton = new JRadioButton("Power Source");
        this.powerRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PartModelDialog.this.temperatureLabel.setEnabled(false);
                    PartModelDialog.this.temperatureField.setEnabled(false);
                    PartModelDialog.this.powerLabel.setText("<html><u><font color=blue>Power density</font></u></html>");
                    PartModelDialog.this.powerLabel.setEnabled(true);
                    PartModelDialog.this.powerField.setEnabled(true);
                    PartModelDialog.this.powerField.setText(FORMAT.format(part.getPower()));
                }
            }
        });
        p.add(this.powerRadioButton);
        bg.add(this.powerRadioButton);
        p = new JPanel(new SpringLayout());
        pp.add((Component)p, "Center");
        count = 0;
        this.temperatureLabel = new JLabel("Temperature");
        p.add(this.temperatureLabel);
        this.temperatureField = new JTextField(FORMAT.format(part.getTemperature()), 16);
        this.temperatureField.addActionListener(this.okListener);
        p.add(this.temperatureField);
        p.add(new JLabel("<html><i>\u2103</i></html>"));
        ++count;
        this.powerLabel = new JLabel("Power density");
        this.powerLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (PartModelDialog.this.powerLabel.isEnabled() && PartModelDialog.this.powerRadioButton.isSelected()) {
                    new ThermostatDialog(view, part, true).setVisible(true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (PartModelDialog.this.powerLabel.isEnabled()) {
                    PartModelDialog.this.powerLabel.setCursor(Cursor.getPredefinedCursor(12));
                    if (PartModelDialog.this.powerRadioButton.isSelected()) {
                        PartModelDialog.this.powerLabel.setToolTipText(PartModelDialog.this.powerLabel.isEnabled() ? "Click to set up a thermostat" : null);
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (PartModelDialog.this.powerLabel.isEnabled()) {
                    PartModelDialog.this.powerLabel.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        p.add(this.powerLabel);
        this.powerField = new JTextField(FORMAT.format(part.getPower()), 16);
        this.powerField.addActionListener(this.okListener);
        p.add(this.powerField);
        p.add(new JLabel("<html><i>W/m<sup><font size=2>3</font></sup></html>"));
        ++count;
        p.add(new JLabel("Temperature Coefficient"));
        this.temperatureCoefficientField = new JTextField(String.valueOf(part.getThermistorTemperatureCoefficient()), 16);
        this.temperatureCoefficientField.addActionListener(this.okListener);
        p.add(this.temperatureCoefficientField);
        p.add(new JLabel("<html><i>1/&deg;C</i></html>"));
        ++count;
        p.add(new JLabel("Reference Temperature"));
        this.referenceTemperatureField = new JTextField(String.valueOf(part.getThermistorReferenceTemperature()), 16);
        this.referenceTemperatureField.addActionListener(this.okListener);
        p.add(this.referenceTemperatureField);
        p.add(new JLabel("<html><i>&deg;C</i></html>"));
        ++count;
        p.add(new JLabel("Wind speed"));
        this.windSpeedField = new JTextField(FORMAT.format(part.getWindSpeed()), 8);
        this.windSpeedField.addActionListener(this.okListener);
        p.add(this.windSpeedField);
        p.add(new JLabel("<html><i>m/s</i></html>"));
        ++count;
        p.add(new JLabel("Wind angle"));
        this.windAngleField = new JTextField(FORMAT.format(Math.toDegrees(part.getWindAngle())), 8);
        this.windAngleField.addActionListener(this.okListener);
        p.add(this.windAngleField);
        p.add(new JLabel("Degrees"));
        ++count;
        if (part.getPower() != 0.0f) {
            this.powerRadioButton.setSelected(true);
        } else if (part.getConstantTemperature()) {
            this.constantTemperatureRadioButton.setSelected(true);
        } else {
            this.notHeatSourceRadioButton.setSelected(true);
        }
        MiscUtil.makeCompactGrid(p, count, 3, 5, 5, 10, 2);
        p = new JPanel(new SpringLayout());
        pp = new JPanel(new BorderLayout());
        pp.add((Component)p, "North");
        tabbedPane.add((Component)pp, "Thermal");
        count = 0;
        p.add(new JLabel("Thermal conductivity"));
        this.thermalConductivityField = new JTextField(FORMAT.format(part.getThermalConductivity()), 8);
        this.thermalConductivityField.addActionListener(this.okListener);
        p.add(this.thermalConductivityField);
        p.add(new JLabel("<html><i>W/(m\u00b7\u2103)</i></html>"));
        ++count;
        p.add(new JLabel("Specific heat"));
        this.specificHeatField = new JTextField(FORMAT.format(part.getSpecificHeat()), 8);
        this.specificHeatField.addActionListener(this.okListener);
        p.add(this.specificHeatField);
        p.add(new JLabel("<html><i>J/(kg\u00b7\u2103)</i></html>"));
        ++count;
        p.add(new JLabel("Density"));
        this.densityField = new JTextField(FORMAT.format(part.getDensity()), 8);
        this.densityField.addActionListener(this.okListener);
        p.add(this.densityField);
        p.add(new JLabel("<html><i>kg/m<sup><font size=2>3</font></sup></html>"));
        MiscUtil.makeCompactGrid(p, ++count, 3, 5, 5, 10, 2);
        p = new JPanel(new GridLayout(2, 2, 8, 8));
        p.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        pp = new JPanel(new BorderLayout());
        pp.add((Component)p, "North");
        tabbedPane.add((Component)pp, "Optical");
        p.add(new JLabel("Absorptivity:"));
        this.absorptivityField = new JTextField(FORMAT.format(part.getAbsorptivity()), 10);
        this.absorptivityField.addActionListener(this.okListener);
        p.add(this.absorptivityField);
        p.add(new JLabel("Reflectivity:"));
        this.reflectivityField = new JTextField(FORMAT.format(part.getReflectivity()), 10);
        this.reflectivityField.addActionListener(this.okListener);
        p.add(this.reflectivityField);
        p.add(new JLabel("Transmissivity:"));
        this.transmissivityField = new JTextField(FORMAT.format(part.getTransmissivity()), 10);
        this.transmissivityField.addActionListener(this.okListener);
        p.add(this.transmissivityField);
        p.add(new JLabel("Emissivity:"));
        this.emissivityField = new JTextField(FORMAT.format(part.getEmissivity()), 10);
        this.emissivityField.addActionListener(this.okListener);
        p.add(this.emissivityField);
        p = new JPanel(new FlowLayout(0));
        p.setBorder(BorderFactory.createTitledBorder("For light particles only"));
        pp.add((Component)p, "Center");
        bg = new ButtonGroup();
        this.noScatteringRadioButton = new JRadioButton("No scattering", !part.getScattering());
        p.add(this.noScatteringRadioButton);
        bg.add(this.noScatteringRadioButton);
        this.visibleScatteringRadioButton = new JRadioButton("Scattering (visible)", part.getScattering() && part.isScatteringVisible());
        p.add(this.visibleScatteringRadioButton);
        bg.add(this.visibleScatteringRadioButton);
        this.invisibleScatteringRadioButton = new JRadioButton("Scattering (invisible)", part.getScattering() && !part.isScatteringVisible());
        p.add(this.invisibleScatteringRadioButton);
        bg.add(this.invisibleScatteringRadioButton);
        p = new JPanel(new GridLayout(1, 3, 8, 8));
        p.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        pp = new JPanel(new BorderLayout());
        pp.add((Component)p, "North");
        tabbedPane.add((Component)pp, "Mechanical");
        p.add(new JLabel("Elasticity:"));
        this.elasticityField = new JTextField(FORMAT.format(part.getElasticity()), 10);
        this.elasticityField.addActionListener(this.okListener);
        p.add(this.elasticityField);
        p.add(new JLabel("Dimensionless [0, 1]"));
        Box miscBox = Box.createVerticalBox();
        pp = new JPanel(new BorderLayout());
        pp.add((Component)miscBox, "North");
        tabbedPane.add((Component)pp, "Miscellaneous");
        p = new JPanel(new FlowLayout(0));
        miscBox.add(p);
        p.add(new JLabel("Unique ID:"));
        this.uidField = new JTextField(part.getUid(), 20);
        this.uidField.addActionListener(this.okListener);
        p.add(this.uidField);
        p.add(new JLabel("Label:"));
        this.labelField = new JTextField(part.getLabel(), 20);
        this.labelField.addActionListener(this.okListener);
        p.add(this.labelField);
        p = new JPanel(new FlowLayout(0));
        miscBox.add(p);
        p.add(new JLabel("<html><br><hr align=left width=100>1) Set a unique ID if you need to find this part in scripts.<br>2) The label will be shown on top of this part in the view.</html>"));
        this.pack();
        this.setLocationRelativeTo(view);
    }

    private float parse(String s) {
        return MiscUtil.parse(this.owner, s);
    }
}

