/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.concord.energy2d.model.DirichletThermalBoundary;
import org.concord.energy2d.model.Model2D;
import org.concord.energy2d.model.NeumannThermalBoundary;
import org.concord.energy2d.model.SimpleMassBoundary;
import org.concord.energy2d.model.ThermalBoundary;
import org.concord.energy2d.util.MiscUtil;
import org.concord.energy2d.view.View2D;

class ModelDialog
extends JDialog {
    private static final DecimalFormat FORMAT = new DecimalFormat("####.########");
    private JTextField steplengthField;
    private JTextField bgTemperatureField;
    private JTextField conductivityField;
    private JTextField specificHeatField;
    private JTextField densityField;
    private JLabel viscosityLabel;
    private JTextField viscosityField;
    private JLabel thermalExpansionCoefficientLabel;
    private JTextField thermalExpansionCoefficientField;
    private JTextField wField;
    private JTextField hField;
    private JTabbedPane boundaryTab;
    private JLabel upperThermalBoundaryLabel;
    private JLabel lowerThermalBoundaryLabel;
    private JLabel leftThermalBoundaryLabel;
    private JLabel rightThermalBoundaryLabel;
    private JLabel upperThermalBoundaryLabel2;
    private JLabel lowerThermalBoundaryLabel2;
    private JLabel leftThermalBoundaryLabel2;
    private JLabel rightThermalBoundaryLabel2;
    private JTextField upperThermalBoundaryField;
    private JTextField lowerThermalBoundaryField;
    private JTextField leftThermalBoundaryField;
    private JTextField rightThermalBoundaryField;
    private JRadioButton upperMassBoundaryReflect;
    private JRadioButton lowerMassBoundaryReflect;
    private JRadioButton leftMassBoundaryReflect;
    private JRadioButton rightMassBoundaryReflect;
    private JRadioButton upperMassBoundaryThrough;
    private JRadioButton lowerMassBoundaryThrough;
    private JRadioButton leftMassBoundaryThrough;
    private JRadioButton rightMassBoundaryThrough;
    private JRadioButton upperMassBoundaryStop;
    private JRadioButton lowerMassBoundaryStop;
    private JRadioButton leftMassBoundaryStop;
    private JRadioButton rightMassBoundaryStop;
    private JLabel solarPowerLabel;
    private JTextField solarPowerField;
    private JLabel raySpeedLabel;
    private JTextField raySpeedField;
    private JLabel rayNumberLabel;
    private JTextField rayNumberField;
    private JLabel emissionIntervalLabel;
    private JTextField emissionIntervalField;
    private JComboBox<String> thermalBoundaryComboBox;
    private JLabel sunAngleLabel;
    private JSlider sunAngleSlider;
    private JCheckBox sunnyCheckBox;
    private JCheckBox convectiveCheckBox;
    private JLabel buoyancyApproximationLabel;
    private JComboBox<String> buoyancyApproximationComboBox;
    private JLabel gravityTypeLabel;
    private JComboBox<String> gravityTypeComboBox;
    private JTextField zDiffusivityField;
    private JTextField gravitationalAccelerationField;
    private JTextField particleDragField;
    private JTextField particleHardnessField;
    private JTextField thermophoreticField;
    private Window owner;
    private ActionListener okListener;

    ModelDialog(final View2D view, final Model2D model, boolean modal) {
        super(JOptionPane.getFrameForComponent(view), "Model Properties", modal);
        this.setDefaultCloseOperation(2);
        this.owner = this.getOwner();
        this.okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float bgTemperature = ModelDialog.this.parse(ModelDialog.this.bgTemperatureField.getText());
                if (Float.isNaN(bgTemperature)) {
                    return;
                }
                float conductivity = ModelDialog.this.parse(ModelDialog.this.conductivityField.getText());
                if (Float.isNaN(conductivity)) {
                    return;
                }
                float specificHeat = ModelDialog.this.parse(ModelDialog.this.specificHeatField.getText());
                if (Float.isNaN(specificHeat)) {
                    return;
                }
                float density = ModelDialog.this.parse(ModelDialog.this.densityField.getText());
                if (Float.isNaN(density)) {
                    return;
                }
                float viscosity = ModelDialog.this.parse(ModelDialog.this.viscosityField.getText());
                if (Float.isNaN(viscosity)) {
                    return;
                }
                float thermalExpansionCoefficient = ModelDialog.this.parse(ModelDialog.this.thermalExpansionCoefficientField.getText());
                if (Float.isNaN(thermalExpansionCoefficient)) {
                    return;
                }
                float steplength = ModelDialog.this.parse(ModelDialog.this.steplengthField.getText());
                if (Float.isNaN(steplength)) {
                    return;
                }
                float width = ModelDialog.this.parse(ModelDialog.this.wField.getText());
                if (Float.isNaN(width)) {
                    return;
                }
                float height = ModelDialog.this.parse(ModelDialog.this.hField.getText());
                if (Float.isNaN(height)) {
                    return;
                }
                float valueAtLeft = ModelDialog.this.parse(ModelDialog.this.leftThermalBoundaryField.getText());
                if (Float.isNaN(valueAtLeft)) {
                    return;
                }
                float valueAtRight = ModelDialog.this.parse(ModelDialog.this.rightThermalBoundaryField.getText());
                if (Float.isNaN(valueAtRight)) {
                    return;
                }
                float valueAtUpper = ModelDialog.this.parse(ModelDialog.this.upperThermalBoundaryField.getText());
                if (Float.isNaN(valueAtUpper)) {
                    return;
                }
                float valueAtLower = ModelDialog.this.parse(ModelDialog.this.lowerThermalBoundaryField.getText());
                if (Float.isNaN(valueAtLower)) {
                    return;
                }
                float solarPower = ModelDialog.this.parse(ModelDialog.this.solarPowerField.getText());
                if (Float.isNaN(solarPower)) {
                    return;
                }
                float raySpeed = ModelDialog.this.parse(ModelDialog.this.raySpeedField.getText());
                if (Float.isNaN(raySpeed)) {
                    return;
                }
                float rayNumber = ModelDialog.this.parse(ModelDialog.this.rayNumberField.getText());
                if (Float.isNaN(rayNumber)) {
                    return;
                }
                float emissionInterval = ModelDialog.this.parse(ModelDialog.this.emissionIntervalField.getText());
                if (Float.isNaN(emissionInterval)) {
                    return;
                }
                float zHeatDiffusivity = ModelDialog.this.parse(ModelDialog.this.zDiffusivityField.getText());
                if (Float.isNaN(zHeatDiffusivity)) {
                    return;
                }
                float gravitationalAcceleration = ModelDialog.this.parse(ModelDialog.this.gravitationalAccelerationField.getText());
                if (Float.isNaN(gravitationalAcceleration)) {
                    return;
                }
                float thermophoreticCoefficient = ModelDialog.this.parse(ModelDialog.this.thermophoreticField.getText());
                if (Float.isNaN(thermophoreticCoefficient)) {
                    return;
                }
                float particleDrag = ModelDialog.this.parse(ModelDialog.this.particleDragField.getText());
                if (Float.isNaN(particleDrag)) {
                    return;
                }
                float particleHardness = ModelDialog.this.parse(ModelDialog.this.particleHardnessField.getText());
                if (Float.isNaN(particleHardness)) {
                    return;
                }
                if (steplength <= 0.0f) {
                    JOptionPane.showMessageDialog(ModelDialog.this, "Time step must be greater than zero!", "Time step input error", 0);
                    return;
                }
                if (density <= 0.0f) {
                    JOptionPane.showMessageDialog(ModelDialog.this, "Medium density must be greater than zero!", "Density input error", 0);
                    return;
                }
                if (specificHeat <= 0.0f) {
                    JOptionPane.showMessageDialog(ModelDialog.this, "Medium specific heat must be greater than zero!", "Specific heat input error", 0);
                    return;
                }
                if (thermophoreticCoefficient < 0.0f) {
                    JOptionPane.showMessageDialog(ModelDialog.this, "Thermophoretic coefficient cannot be negative!", "Thermophoretic cofficient input error", 0);
                    return;
                }
                if (particleDrag < 0.0f) {
                    JOptionPane.showMessageDialog(ModelDialog.this, "Particle drag cannot be negative!", "Drag input error", 0);
                    return;
                }
                if (particleHardness < 0.0f) {
                    JOptionPane.showMessageDialog(ModelDialog.this, "Particle hardness cannot be negative!", "Particle hardness input error", 0);
                    return;
                }
                model.setTimeStep(steplength);
                model.setBackgroundTemperature(bgTemperature);
                model.setBackgroundConductivity(Math.max(conductivity, 1.0E-9f));
                model.setBackgroundSpecificHeat(specificHeat);
                model.setBackgroundDensity(density);
                model.setBackgroundViscosity(viscosity);
                model.setThermalExpansionCoefficient(thermalExpansionCoefficient);
                float dx = width - model.getLx();
                float dy = height - model.getLy();
                if (dx != 0.0f) {
                    model.setLx(width);
                }
                if (dy != 0.0f) {
                    model.setLy(height);
                    model.translateAllBy(0.0f, dy);
                }
                view.setArea(0.0f, width, 0.0f, height);
                model.setSolarPowerDensity(solarPower);
                model.setSolarRaySpeed(raySpeed);
                model.setSolarRayCount((int)rayNumber);
                model.setPhotonEmissionInterval((int)emissionInterval);
                model.setSunAngle((float)Math.toRadians(ModelDialog.this.sunAngleSlider.getValue()));
                model.setZHeatDiffusivity(zHeatDiffusivity);
                model.setGravitationalAcceleration(gravitationalAcceleration);
                model.setThermophoreticCoefficient(thermophoreticCoefficient);
                model.setParticleDrag(particleDrag);
                model.setParticleHardness(particleHardness * 1.0E-6f);
                switch (ModelDialog.this.thermalBoundaryComboBox.getSelectedIndex()) {
                    case 0: {
                        DirichletThermalBoundary dhb = new DirichletThermalBoundary();
                        dhb.setTemperatureAtBorder((byte)3, valueAtLeft);
                        dhb.setTemperatureAtBorder((byte)1, valueAtRight);
                        dhb.setTemperatureAtBorder((byte)0, valueAtUpper);
                        dhb.setTemperatureAtBorder((byte)2, valueAtLower);
                        model.setThermalBoundary(dhb);
                        break;
                    }
                    case 1: {
                        NeumannThermalBoundary nhb = new NeumannThermalBoundary();
                        nhb.setFluxAtBorder((byte)3, valueAtLeft);
                        nhb.setFluxAtBorder((byte)1, valueAtRight);
                        nhb.setFluxAtBorder((byte)0, valueAtUpper);
                        nhb.setFluxAtBorder((byte)2, valueAtLower);
                        model.setThermalBoundary(nhb);
                    }
                }
                SimpleMassBoundary massBoundary = (SimpleMassBoundary)model.getMassBoundary();
                if (ModelDialog.this.leftMassBoundaryReflect.isSelected()) {
                    massBoundary.setFlowTypeAtBorder((byte)3, (byte)0);
                } else if (ModelDialog.this.leftMassBoundaryStop.isSelected()) {
                    massBoundary.setFlowTypeAtBorder((byte)3, (byte)2);
                } else if (ModelDialog.this.leftMassBoundaryThrough.isSelected()) {
                    massBoundary.setFlowTypeAtBorder((byte)3, (byte)1);
                }
                if (ModelDialog.this.rightMassBoundaryReflect.isSelected()) {
                    massBoundary.setFlowTypeAtBorder((byte)1, (byte)0);
                } else if (ModelDialog.this.rightMassBoundaryStop.isSelected()) {
                    massBoundary.setFlowTypeAtBorder((byte)1, (byte)2);
                } else if (ModelDialog.this.rightMassBoundaryThrough.isSelected()) {
                    massBoundary.setFlowTypeAtBorder((byte)1, (byte)1);
                }
                if (ModelDialog.this.upperMassBoundaryReflect.isSelected()) {
                    massBoundary.setFlowTypeAtBorder((byte)0, (byte)0);
                } else if (ModelDialog.this.upperMassBoundaryStop.isSelected()) {
                    massBoundary.setFlowTypeAtBorder((byte)0, (byte)2);
                } else if (ModelDialog.this.upperMassBoundaryThrough.isSelected()) {
                    massBoundary.setFlowTypeAtBorder((byte)0, (byte)1);
                }
                if (ModelDialog.this.lowerMassBoundaryReflect.isSelected()) {
                    massBoundary.setFlowTypeAtBorder((byte)2, (byte)0);
                } else if (ModelDialog.this.lowerMassBoundaryStop.isSelected()) {
                    massBoundary.setFlowTypeAtBorder((byte)2, (byte)2);
                } else if (ModelDialog.this.lowerMassBoundaryThrough.isSelected()) {
                    massBoundary.setFlowTypeAtBorder((byte)2, (byte)1);
                }
                model.setSunny(ModelDialog.this.sunnyCheckBox.isSelected());
                model.setConvective(ModelDialog.this.convectiveCheckBox.isSelected());
                model.setBuoyancyApproximation((byte)ModelDialog.this.buoyancyApproximationComboBox.getSelectedIndex());
                model.setGravityType((byte)ModelDialog.this.gravityTypeComboBox.getSelectedIndex());
                model.refreshPowerArray();
                model.refreshTemperatureBoundaryArray();
                model.refreshMaterialPropertyArrays();
                view.repaint();
                if (!(e.getSource() instanceof JComboBox)) {
                    ModelDialog.this.dispose();
                }
                view.notifyManipulationListeners(null, (byte)3);
            }
        };
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                view.notifyManipulationListeners(null, (byte)3);
                view.repaint();
                ModelDialog.this.dispose();
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        this.setContentPane(panel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        panel.add((Component)buttonPanel, "South");
        JButton button = new JButton("OK");
        button.addActionListener(this.okListener);
        buttonPanel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModelDialog.this.dispose();
            }
        });
        buttonPanel.add(button);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)tabbedPane, "Center");
        JPanel p = new JPanel(new SpringLayout());
        JPanel pp = new JPanel(new BorderLayout());
        pp.add((Component)p, "North");
        tabbedPane.add((Component)pp, "General");
        int count = 0;
        this.convectiveCheckBox = new JCheckBox("Convective");
        this.convectiveCheckBox.setSelected(model.isConvective());
        this.convectiveCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean b = ModelDialog.this.convectiveCheckBox.isSelected();
                ModelDialog.this.viscosityLabel.setEnabled(b);
                ModelDialog.this.viscosityField.setEnabled(b);
                ModelDialog.this.thermalExpansionCoefficientLabel.setEnabled(b);
                ModelDialog.this.thermalExpansionCoefficientField.setEnabled(b);
                ModelDialog.this.buoyancyApproximationLabel.setEnabled(b);
                ModelDialog.this.buoyancyApproximationComboBox.setEnabled(b);
                ModelDialog.this.gravityTypeLabel.setEnabled(b);
                ModelDialog.this.gravityTypeComboBox.setEnabled(b);
            }
        });
        p.add(this.convectiveCheckBox);
        this.sunnyCheckBox = new JCheckBox("Sunny");
        this.sunnyCheckBox.setSelected(model.isSunny());
        this.sunnyCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean b = ModelDialog.this.sunnyCheckBox.isSelected();
                ModelDialog.this.sunAngleSlider.setEnabled(b);
                ModelDialog.this.emissionIntervalLabel.setEnabled(b);
                ModelDialog.this.emissionIntervalField.setEnabled(b);
                ModelDialog.this.rayNumberLabel.setEnabled(b);
                ModelDialog.this.rayNumberField.setEnabled(b);
                ModelDialog.this.raySpeedLabel.setEnabled(b);
                ModelDialog.this.raySpeedField.setEnabled(b);
                ModelDialog.this.solarPowerLabel.setEnabled(b);
                ModelDialog.this.solarPowerField.setEnabled(b);
            }
        });
        p.add(this.sunnyCheckBox);
        JLabel label = new JLabel();
        p.add(label);
        label = new JLabel("Width");
        p.add(label);
        this.wField = new JTextField(FORMAT.format(model.getLx()), 8);
        this.wField.addActionListener(this.okListener);
        p.add(this.wField);
        label = new JLabel("<html><i>m</i></html>");
        p.add(label);
        ++count;
        label = new JLabel("Time steplength");
        p.add(label);
        this.steplengthField = new JTextField(FORMAT.format(model.getTimeStep()), 8);
        this.steplengthField.addActionListener(this.okListener);
        p.add(this.steplengthField);
        label = new JLabel("<html><i>s</i></html>");
        p.add(label);
        label = new JLabel("Height");
        p.add(label);
        this.hField = new JTextField(FORMAT.format(model.getLy()), 8);
        this.hField.addActionListener(this.okListener);
        p.add(this.hField);
        label = new JLabel("<html><i>m</i></html>");
        p.add(label);
        ++count;
        label = new JLabel("Z heat diffusivity *");
        p.add(label);
        this.zDiffusivityField = new JTextField(FORMAT.format(model.getZHeatDiffusivity()), 8);
        this.zDiffusivityField.addActionListener(this.okListener);
        p.add(this.zDiffusivityField);
        label = new JLabel();
        p.add(label);
        label = new JLabel();
        p.add(label);
        label = new JLabel();
        p.add(label);
        label = new JLabel();
        p.add(label);
        MiscUtil.makeCompactGrid(p, ++count, 6, 5, 5, 10, 2);
        p = new JPanel(new FlowLayout(0));
        pp.add((Component)p, "Center");
        p.add(new JLabel("<html><br><hr align=left width=100>* The Z heat diffusivity permits heat exchange in the direction perpendicular to the screen.<br>If it is positive, the system will settle at the background temperature set for the medium.</html>"));
        p = new JPanel(new SpringLayout());
        pp = new JPanel(new BorderLayout());
        pp.add((Component)p, "North");
        tabbedPane.add((Component)pp, "Medium");
        count = 0;
        label = new JLabel("Background temperature");
        p.add(label);
        this.bgTemperatureField = new JTextField(FORMAT.format(model.getBackgroundTemperature()), 16);
        this.bgTemperatureField.addActionListener(this.okListener);
        p.add(this.bgTemperatureField);
        label = new JLabel("<html><i>\u2103</i></html>");
        p.add(label);
        ++count;
        label = new JLabel("Conductivity");
        p.add(label);
        this.conductivityField = new JTextField(FORMAT.format(model.getBackgroundConductivity()), 16);
        this.conductivityField.addActionListener(this.okListener);
        p.add(this.conductivityField);
        label = new JLabel("<html><i>W/(m\u00b7\u2103)</i></html>");
        p.add(label);
        ++count;
        label = new JLabel("Specific heat");
        p.add(label);
        this.specificHeatField = new JTextField(FORMAT.format(model.getBackgroundSpecificHeat()), 16);
        this.specificHeatField.addActionListener(this.okListener);
        p.add(this.specificHeatField);
        label = new JLabel("<html><i>J/(kg\u00b7\u2103)</i></html>");
        p.add(label);
        ++count;
        label = new JLabel("Density");
        p.add(label);
        this.densityField = new JTextField(FORMAT.format(model.getBackgroundDensity()), 16);
        this.densityField.addActionListener(this.okListener);
        p.add(this.densityField);
        label = new JLabel("<html><i>kg/m<sup><font size=2>3</font></sup></html>");
        p.add(label);
        ++count;
        this.viscosityLabel = new JLabel("Kinematic viscosity");
        this.viscosityLabel.setEnabled(model.isConvective());
        p.add(this.viscosityLabel);
        this.viscosityField = new JTextField(FORMAT.format(model.getBackgroundViscosity()), 16);
        this.viscosityField.setEnabled(model.isConvective());
        this.viscosityField.addActionListener(this.okListener);
        p.add(this.viscosityField);
        label = new JLabel("<html><i>m<sup><font size=2>2</font></sup>/s</html>");
        p.add(label);
        ++count;
        this.thermalExpansionCoefficientLabel = new JLabel("Thermal expansion coefficient");
        this.thermalExpansionCoefficientLabel.setEnabled(model.isConvective());
        p.add(this.thermalExpansionCoefficientLabel);
        this.thermalExpansionCoefficientField = new JTextField(FORMAT.format(model.getThermalExpansionCoefficient()), 16);
        this.thermalExpansionCoefficientField.setEnabled(model.isConvective());
        this.thermalExpansionCoefficientField.addActionListener(this.okListener);
        p.add(this.thermalExpansionCoefficientField);
        label = new JLabel("<html><i>m/(s<sup><font size=2>2</font></sup>\u00b7\u2103)</html>)");
        p.add(label);
        ++count;
        this.buoyancyApproximationLabel = new JLabel("Buoyancy approximation");
        this.buoyancyApproximationLabel.setEnabled(model.isConvective());
        p.add(this.buoyancyApproximationLabel);
        this.buoyancyApproximationComboBox = new JComboBox<String>(new String[]{"All-cell average", "Column average"});
        this.buoyancyApproximationComboBox.setEnabled(model.isConvective());
        this.buoyancyApproximationComboBox.setSelectedIndex(model.getBuoyancyApproximation());
        p.add(this.buoyancyApproximationComboBox);
        label = new JLabel();
        p.add(label);
        ++count;
        this.gravityTypeLabel = new JLabel("Gravity type");
        this.gravityTypeLabel.setEnabled(model.isConvective());
        p.add(this.gravityTypeLabel);
        this.gravityTypeComboBox = new JComboBox<String>(new String[]{"Uniform", "Centric"});
        this.gravityTypeComboBox.setEnabled(model.isConvective());
        this.gravityTypeComboBox.setSelectedIndex(model.getGravityType());
        p.add(this.gravityTypeComboBox);
        label = new JLabel();
        p.add(label);
        MiscUtil.makeCompactGrid(p, ++count, 3, 5, 5, 10, 2);
        p = new JPanel(new SpringLayout());
        pp = new JPanel(new BorderLayout());
        pp.add((Component)p, "North");
        pp.add((Component)new JLabel("<html><br><hr align=left width=100>* The above parameters set up a photon (light particle) simulation of sunlight.</html>"), "Center");
        tabbedPane.add((Component)pp, "Sunlight");
        count = 0;
        this.rayNumberLabel = new JLabel("Ray number");
        this.rayNumberLabel.setEnabled(model.isSunny());
        p.add(this.rayNumberLabel);
        this.rayNumberField = new JTextField(FORMAT.format(model.getSolarRayCount()), 16);
        this.rayNumberField.setEnabled(model.isSunny());
        this.rayNumberField.addActionListener(this.okListener);
        p.add(this.rayNumberField);
        label = new JLabel();
        p.add(label);
        ++count;
        this.raySpeedLabel = new JLabel("Ray speed");
        this.raySpeedLabel.setEnabled(model.isSunny());
        p.add(this.raySpeedLabel);
        this.raySpeedField = new JTextField(FORMAT.format(model.getSolarRaySpeed()), 16);
        this.raySpeedField.setEnabled(model.isSunny());
        this.raySpeedField.addActionListener(this.okListener);
        p.add(this.raySpeedField);
        label = new JLabel("<html><i>m/s</i></html>");
        p.add(label);
        ++count;
        this.emissionIntervalLabel = new JLabel("Emission interval");
        this.emissionIntervalLabel.setEnabled(model.isSunny());
        p.add(this.emissionIntervalLabel);
        this.emissionIntervalField = new JTextField(FORMAT.format(model.getPhotonEmissionInterval()), 16);
        this.emissionIntervalField.setEnabled(model.isSunny());
        this.emissionIntervalField.addActionListener(this.okListener);
        p.add(this.emissionIntervalField);
        label = new JLabel();
        p.add(label);
        ++count;
        this.solarPowerLabel = new JLabel("Solar power density");
        this.solarPowerLabel.setEnabled(model.isSunny());
        p.add(this.solarPowerLabel);
        this.solarPowerField = new JTextField(FORMAT.format(model.getSolarPowerDensity()), 16);
        this.solarPowerField.setEnabled(model.isSunny());
        this.solarPowerField.addActionListener(this.okListener);
        p.add(this.solarPowerField);
        label = new JLabel("<html><i>W/m<sup><font size=2>3</font></sup></html>)");
        p.add(label);
        ++count;
        this.sunAngleLabel = new JLabel("<html>Sun angle<br>(Dawn to dusk)</html>");
        this.sunAngleLabel.setEnabled(model.isSunny());
        p.add(this.sunAngleLabel);
        int angle = (int)Math.toDegrees(model.getSunAngle());
        if (angle < 0) {
            angle = 0;
        } else if (angle > 180) {
            angle = 180;
        }
        this.sunAngleSlider = new JSlider(0, 180, angle);
        this.sunAngleSlider.setEnabled(model.isSunny());
        this.sunAngleSlider.setPaintTicks(true);
        this.sunAngleSlider.setMajorTickSpacing(45);
        this.sunAngleSlider.setMinorTickSpacing(15);
        this.sunAngleSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> ht = new Hashtable<Integer, JLabel>();
        ht.put(0, new JLabel("0\u00b0"));
        ht.put(45, new JLabel("45\u00b0"));
        ht.put(90, new JLabel("90\u00b0"));
        ht.put(135, new JLabel("135\u00b0"));
        ht.put(180, new JLabel("180\u00b0"));
        this.sunAngleSlider.setLabelTable(ht);
        p.add(this.sunAngleSlider);
        label = new JLabel("Degree");
        p.add(label);
        MiscUtil.makeCompactGrid(p, ++count, 3, 5, 5, 10, 2);
        p = new JPanel(new SpringLayout());
        pp = new JPanel(new BorderLayout());
        pp.add((Component)p, "North");
        tabbedPane.add((Component)pp, "Particle");
        count = 0;
        p.add(new JLabel("Particle Count"));
        JTextField particleCountField = new JTextField("" + model.getParticles().size());
        particleCountField.setEditable(false);
        p.add(particleCountField);
        p.add(new JLabel());
        ++count;
        p.add(new JLabel("Gravitational Acceleration"));
        this.gravitationalAccelerationField = new JTextField("" + model.getGravitationalAcceleration(), 16);
        this.gravitationalAccelerationField.addActionListener(this.okListener);
        p.add(this.gravitationalAccelerationField);
        label = new JLabel("<html>m/s<sup>2</sup></html>");
        p.add(label);
        ++count;
        p.add(new JLabel("Drag Coefficient"));
        this.particleDragField = new JTextField(FORMAT.format(model.getParticleDrag()), 16);
        this.particleDragField.addActionListener(this.okListener);
        p.add(this.particleDragField);
        label = new JLabel("kg/s");
        p.add(label);
        ++count;
        p.add(new JLabel("Hardness"));
        this.particleHardnessField = new JTextField(FORMAT.format(model.getParticleHardness() * 1000000.0f), 16);
        this.particleHardnessField.addActionListener(this.okListener);
        p.add(this.particleHardnessField);
        label = new JLabel("");
        p.add(label);
        ++count;
        p.add(new JLabel("Thermophoretic Coefficient"));
        this.thermophoreticField = new JTextField(FORMAT.format(model.getThermophoreticCoefficient()), 16);
        this.thermophoreticField.addActionListener(this.okListener);
        p.add(this.thermophoreticField);
        label = new JLabel("<html>kg<sup>2</sup>m<sup>2</sup>/s<sup>2</sup></html>");
        p.add(label);
        MiscUtil.makeCompactGrid(p, ++count, 3, 5, 5, 10, 2);
        this.boundaryTab = new JTabbedPane();
        tabbedPane.add((Component)this.boundaryTab, "Boundary");
        p = new JPanel(new SpringLayout());
        pp = new JPanel(new BorderLayout());
        pp.add((Component)p, "North");
        this.boundaryTab.add((Component)pp, "Thermal Boundary");
        count = 0;
        label = new JLabel("Thermal boundary condition");
        p.add(label);
        this.thermalBoundaryComboBox = new JComboBox<String>(new String[]{"Dirichlet (constant temperature)", "Neumann (constant heat flux)", "Other"});
        if (model.getThermalBoundary() instanceof DirichletThermalBoundary) {
            this.thermalBoundaryComboBox.setSelectedIndex(0);
        } else if (model.getThermalBoundary() instanceof NeumannThermalBoundary) {
            this.thermalBoundaryComboBox.setSelectedIndex(1);
        } else {
            this.thermalBoundaryComboBox.setSelectedIndex(2);
        }
        this.thermalBoundaryComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    switch (ModelDialog.this.thermalBoundaryComboBox.getSelectedIndex()) {
                        case 0: {
                            ModelDialog.this.setThermalBoundaryFields(new DirichletThermalBoundary());
                            break;
                        }
                        case 1: {
                            ModelDialog.this.setThermalBoundaryFields(new NeumannThermalBoundary());
                            break;
                        }
                        case 2: {
                            ModelDialog.this.enableBoundaryFieldsAndLabels(false);
                        }
                    }
                }
            }
        });
        this.thermalBoundaryComboBox.addActionListener(this.okListener);
        p.add(this.thermalBoundaryComboBox);
        label = new JLabel();
        p.add(label);
        ++count;
        this.upperThermalBoundaryLabel = new JLabel();
        p.add(this.upperThermalBoundaryLabel);
        this.upperThermalBoundaryField = new JTextField();
        this.upperThermalBoundaryField.addActionListener(this.okListener);
        p.add(this.upperThermalBoundaryField);
        this.upperThermalBoundaryLabel2 = new JLabel();
        p.add(this.upperThermalBoundaryLabel2);
        ++count;
        this.rightThermalBoundaryLabel = new JLabel();
        p.add(this.rightThermalBoundaryLabel);
        this.rightThermalBoundaryField = new JTextField();
        this.rightThermalBoundaryField.addActionListener(this.okListener);
        p.add(this.rightThermalBoundaryField);
        this.rightThermalBoundaryLabel2 = new JLabel();
        p.add(this.rightThermalBoundaryLabel2);
        ++count;
        this.lowerThermalBoundaryLabel = new JLabel();
        p.add(this.lowerThermalBoundaryLabel);
        this.lowerThermalBoundaryField = new JTextField();
        this.lowerThermalBoundaryField.addActionListener(this.okListener);
        p.add(this.lowerThermalBoundaryField);
        this.lowerThermalBoundaryLabel2 = new JLabel();
        p.add(this.lowerThermalBoundaryLabel2);
        ++count;
        this.leftThermalBoundaryLabel = new JLabel();
        p.add(this.leftThermalBoundaryLabel);
        this.leftThermalBoundaryField = new JTextField();
        this.leftThermalBoundaryField.addActionListener(this.okListener);
        p.add(this.leftThermalBoundaryField);
        this.leftThermalBoundaryLabel2 = new JLabel();
        p.add(this.leftThermalBoundaryLabel2);
        this.setThermalBoundaryFields(model.getThermalBoundary());
        MiscUtil.makeCompactGrid(p, ++count, 3, 5, 5, 10, 2);
        p = new JPanel(new SpringLayout());
        pp = new JPanel(new BorderLayout());
        pp.add((Component)p, "North");
        this.boundaryTab.add((Component)pp, "Mass Boundary");
        count = 0;
        SimpleMassBoundary massBoundary = (SimpleMassBoundary)model.getMassBoundary();
        label = new JLabel("Upper boundary");
        p.add(label);
        this.upperMassBoundaryReflect = new JRadioButton("Reflect");
        p.add(this.upperMassBoundaryReflect);
        this.upperMassBoundaryStop = new JRadioButton("Stop");
        p.add(this.upperMassBoundaryStop);
        this.upperMassBoundaryThrough = new JRadioButton("Through");
        p.add(this.upperMassBoundaryThrough);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.upperMassBoundaryReflect);
        bg.add(this.upperMassBoundaryThrough);
        bg.add(this.upperMassBoundaryStop);
        switch (massBoundary.getFlowTypeAtBorder((byte)0)) {
            case 0: {
                this.upperMassBoundaryReflect.setSelected(true);
                break;
            }
            case 1: {
                this.upperMassBoundaryThrough.setSelected(true);
                break;
            }
            case 2: {
                this.upperMassBoundaryStop.setSelected(true);
            }
        }
        ++count;
        label = new JLabel("Right boundary");
        p.add(label);
        this.rightMassBoundaryReflect = new JRadioButton("Reflect");
        p.add(this.rightMassBoundaryReflect);
        this.rightMassBoundaryStop = new JRadioButton("Stop");
        p.add(this.rightMassBoundaryStop);
        this.rightMassBoundaryThrough = new JRadioButton("Through");
        p.add(this.rightMassBoundaryThrough);
        bg = new ButtonGroup();
        bg.add(this.rightMassBoundaryReflect);
        bg.add(this.rightMassBoundaryThrough);
        bg.add(this.rightMassBoundaryStop);
        switch (massBoundary.getFlowTypeAtBorder((byte)1)) {
            case 0: {
                this.rightMassBoundaryReflect.setSelected(true);
                break;
            }
            case 1: {
                this.rightMassBoundaryThrough.setSelected(true);
                break;
            }
            case 2: {
                this.rightMassBoundaryStop.setSelected(true);
            }
        }
        ++count;
        label = new JLabel("Lower boundary");
        p.add(label);
        this.lowerMassBoundaryReflect = new JRadioButton("Reflect");
        p.add(this.lowerMassBoundaryReflect);
        this.lowerMassBoundaryStop = new JRadioButton("Stop");
        p.add(this.lowerMassBoundaryStop);
        this.lowerMassBoundaryThrough = new JRadioButton("Through");
        p.add(this.lowerMassBoundaryThrough);
        bg = new ButtonGroup();
        bg.add(this.lowerMassBoundaryReflect);
        bg.add(this.lowerMassBoundaryThrough);
        bg.add(this.lowerMassBoundaryStop);
        switch (massBoundary.getFlowTypeAtBorder((byte)2)) {
            case 0: {
                this.lowerMassBoundaryReflect.setSelected(true);
                break;
            }
            case 1: {
                this.lowerMassBoundaryThrough.setSelected(true);
                break;
            }
            case 2: {
                this.lowerMassBoundaryStop.setSelected(true);
            }
        }
        ++count;
        label = new JLabel("Left boundary");
        p.add(label);
        this.leftMassBoundaryReflect = new JRadioButton("Reflect");
        p.add(this.leftMassBoundaryReflect);
        this.leftMassBoundaryStop = new JRadioButton("Stop");
        p.add(this.leftMassBoundaryStop);
        this.leftMassBoundaryThrough = new JRadioButton("Through");
        p.add(this.leftMassBoundaryThrough);
        bg = new ButtonGroup();
        bg.add(this.leftMassBoundaryReflect);
        bg.add(this.leftMassBoundaryThrough);
        bg.add(this.leftMassBoundaryStop);
        switch (massBoundary.getFlowTypeAtBorder((byte)3)) {
            case 0: {
                this.leftMassBoundaryReflect.setSelected(true);
                break;
            }
            case 1: {
                this.leftMassBoundaryThrough.setSelected(true);
                break;
            }
            case 2: {
                this.leftMassBoundaryStop.setSelected(true);
            }
        }
        MiscUtil.makeCompactGrid(p, ++count, 4, 5, 5, 10, 2);
        this.pack();
        this.setLocationRelativeTo(view);
    }

    private void setThermalBoundaryFields(ThermalBoundary heatBoundary) {
        if (heatBoundary instanceof DirichletThermalBoundary) {
            this.enableBoundaryFieldsAndLabels(true);
            DirichletThermalBoundary b = (DirichletThermalBoundary)heatBoundary;
            this.leftThermalBoundaryField.setText(FORMAT.format(b.getTemperatureAtBorder((byte)3)));
            this.rightThermalBoundaryField.setText(FORMAT.format(b.getTemperatureAtBorder((byte)1)));
            this.upperThermalBoundaryField.setText(FORMAT.format(b.getTemperatureAtBorder((byte)0)));
            this.lowerThermalBoundaryField.setText(FORMAT.format(b.getTemperatureAtBorder((byte)2)));
            this.leftThermalBoundaryLabel.setText("Left boundary temperature");
            this.rightThermalBoundaryLabel.setText("Right boundary temperature");
            this.upperThermalBoundaryLabel.setText("Upper boundary temperature");
            this.lowerThermalBoundaryLabel.setText("Lower boundary temperature");
            this.leftThermalBoundaryLabel2.setText("<html><i>\u2103  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</i></html>");
            this.rightThermalBoundaryLabel2.setText("<html><i>\u2103 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</i></html>");
            this.upperThermalBoundaryLabel2.setText("<html><i>\u2103 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</i></html>");
            this.lowerThermalBoundaryLabel2.setText("<html><i>\u2103 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</i></html>");
        } else if (heatBoundary instanceof NeumannThermalBoundary) {
            this.enableBoundaryFieldsAndLabels(true);
            NeumannThermalBoundary b = (NeumannThermalBoundary)heatBoundary;
            this.leftThermalBoundaryField.setText(FORMAT.format(b.getFluxAtBorder((byte)3)));
            this.rightThermalBoundaryField.setText(FORMAT.format(b.getFluxAtBorder((byte)1)));
            this.upperThermalBoundaryField.setText(FORMAT.format(b.getFluxAtBorder((byte)0)));
            this.lowerThermalBoundaryField.setText(FORMAT.format(b.getFluxAtBorder((byte)2)));
            this.leftThermalBoundaryLabel.setText("Left boundary heat flux");
            this.rightThermalBoundaryLabel.setText("Right boundary heat flux");
            this.upperThermalBoundaryLabel.setText("Upper boundary heat flux");
            this.lowerThermalBoundaryLabel.setText("Lower boundary heat flux");
            this.leftThermalBoundaryLabel2.setText("<html><i>\u2103/m</i></html>");
            this.rightThermalBoundaryLabel2.setText("<html><i>\u2103/m</i></html>");
            this.upperThermalBoundaryLabel2.setText("<html><i>\u2103/m</i></html>");
            this.lowerThermalBoundaryLabel2.setText("<html><i>\u2103/m</i></html>");
        } else {
            this.enableBoundaryFieldsAndLabels(false);
        }
    }

    private void enableBoundaryFieldsAndLabels(boolean b) {
        this.leftThermalBoundaryField.setEnabled(b);
        this.rightThermalBoundaryField.setEnabled(b);
        this.upperThermalBoundaryField.setEnabled(b);
        this.lowerThermalBoundaryField.setEnabled(b);
        this.leftThermalBoundaryLabel.setEnabled(b);
        this.rightThermalBoundaryLabel.setEnabled(b);
        this.upperThermalBoundaryLabel.setEnabled(b);
        this.lowerThermalBoundaryLabel.setEnabled(b);
        this.leftThermalBoundaryLabel2.setEnabled(b);
        this.rightThermalBoundaryLabel2.setEnabled(b);
        this.upperThermalBoundaryLabel2.setEnabled(b);
        this.lowerThermalBoundaryLabel2.setEnabled(b);
    }

    private float parse(String s) {
        return MiscUtil.parse(this.owner, s);
    }
}

