/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.concord.energy2d.model.Heliostat;
import org.concord.energy2d.undo.UndoResizeManipulable;
import org.concord.energy2d.undo.UndoTranslateManipulable;
import org.concord.energy2d.util.MiscUtil;
import org.concord.energy2d.view.View2D;

class HeliostatDialog
extends JDialog {
    private static final DecimalFormat FORMAT = new DecimalFormat("####.######");
    private JTextField xField;
    private JTextField yField;
    private JTextField wField;
    private JTextField hField;
    private JTextField uidField;
    private JTextField labelField;
    private JTextField targetField;
    private JComboBox<String> typeComboBox;
    private JCheckBox draggableCheckBox;
    private Window owner;
    private ActionListener okListener;

    HeliostatDialog(final View2D view, final Heliostat heliostat, boolean modal) {
        super(JOptionPane.getFrameForComponent(view), "Heliostat (#" + view.model.getHeliostats().indexOf(heliostat) + ") Properties", modal);
        this.setDefaultCloseOperation(2);
        this.owner = this.getOwner();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                view.notifyManipulationListeners(heliostat, (byte)3);
                view.repaint();
                HeliostatDialog.this.dispose();
            }
        });
        this.okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String uid;
                float x = HeliostatDialog.this.parse(HeliostatDialog.this.xField.getText());
                if (Float.isNaN(x)) {
                    return;
                }
                float y = HeliostatDialog.this.parse(HeliostatDialog.this.yField.getText());
                if (Float.isNaN(y)) {
                    return;
                }
                float w = HeliostatDialog.this.parse(HeliostatDialog.this.wField.getText());
                if (Float.isNaN(w)) {
                    return;
                }
                float h = HeliostatDialog.this.parse(HeliostatDialog.this.hField.getText());
                if (Float.isNaN(h)) {
                    return;
                }
                Shape s = heliostat.getShape();
                if (s instanceof Rectangle2D.Float) {
                    boolean resized;
                    boolean moved;
                    Rectangle2D.Float r = (Rectangle2D.Float)s;
                    float dx = 1.0E-6f * view.model.getLx();
                    float dy = 1.0E-6f * view.model.getLy();
                    boolean bl = moved = Math.abs((double)x - s.getBounds2D().getX()) > (double)dx || Math.abs((double)y - s.getBounds2D().getY()) > (double)dy;
                    if (moved) {
                        view.getUndoManager().addEdit(new UndoTranslateManipulable(view));
                    }
                    boolean bl2 = resized = Math.abs((double)w - s.getBounds2D().getWidth()) > (double)dx || Math.abs((double)h - s.getBounds2D().getHeight()) > (double)dy;
                    if (resized) {
                        view.getUndoManager().addEdit(new UndoResizeManipulable(view));
                    }
                    r.setRect(x, view.model.getLy() - y, w, h);
                }
                if ((uid = HeliostatDialog.this.uidField.getText()) != null && !(uid = uid.trim()).equals("") && !uid.equals(heliostat.getUid()) && view.isUidUsed(uid)) {
                    JOptionPane.showMessageDialog(HeliostatDialog.this.owner, "UID: " + uid + " has been taken.", "Error", 0);
                    return;
                }
                String type = HeliostatDialog.this.typeComboBox.getSelectedItem().toString();
                if ("Mirror".equalsIgnoreCase(type)) {
                    heliostat.setType((byte)0);
                } else if ("Photovoltaic".equalsIgnoreCase(type)) {
                    heliostat.setType((byte)1);
                }
                String targetID = HeliostatDialog.this.targetField.getText();
                if (targetID != null && !targetID.trim().equals("") && !view.isUidUsed(targetID)) {
                    JOptionPane.showMessageDialog(HeliostatDialog.this.owner, "Object " + targetID + " not found.", "Error", 0);
                    return;
                }
                heliostat.setTarget(view.model.getPart(targetID));
                heliostat.setUid(uid);
                heliostat.setLabel(HeliostatDialog.this.labelField.getText());
                heliostat.setDraggable(HeliostatDialog.this.draggableCheckBox.isSelected());
                heliostat.setAngle();
                view.notifyManipulationListeners(heliostat, (byte)3);
                view.setSelectedManipulable(view.getSelectedManipulable());
                view.repaint();
                HeliostatDialog.this.dispose();
            }
        };
        JPanel panel = new JPanel(new BorderLayout());
        this.setContentPane(panel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        panel.add((Component)buttonPanel, "South");
        this.draggableCheckBox = new JCheckBox("Draggable by user", heliostat.isDraggable());
        buttonPanel.add(this.draggableCheckBox);
        JButton button = new JButton("OK");
        button.addActionListener(this.okListener);
        buttonPanel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeliostatDialog.this.dispose();
            }
        });
        buttonPanel.add(button);
        JPanel p = new JPanel(new GridLayout(8, 2, 8, 8));
        p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)p, "Center");
        p.add(new JLabel("Unique ID:"));
        this.uidField = new JTextField(heliostat.getUid(), 10);
        this.uidField.addActionListener(this.okListener);
        p.add(this.uidField);
        p.add(new JLabel("Type:"));
        this.typeComboBox = new JComboBox<String>(new String[]{"Mirror", "Photovoltaic"});
        switch (heliostat.getType()) {
            case 0: {
                this.typeComboBox.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.typeComboBox.setSelectedIndex(1);
            }
        }
        p.add(this.typeComboBox);
        p.add(new JLabel("Label:"));
        this.labelField = new JTextField(heliostat.getLabel(), 10);
        this.labelField.addActionListener(this.okListener);
        p.add(this.labelField);
        p.add(new JLabel("X (m):"));
        this.xField = new JTextField(FORMAT.format(heliostat.getShape().getBounds2D().getX()), 10);
        this.xField.addActionListener(this.okListener);
        p.add(this.xField);
        p.add(new JLabel("Y (m):"));
        this.yField = new JTextField(FORMAT.format((double)view.model.getLy() - heliostat.getShape().getBounds2D().getY()), 10);
        this.yField.addActionListener(this.okListener);
        p.add(this.yField);
        p.add(new JLabel("Width (m):"));
        this.wField = new JTextField(FORMAT.format(heliostat.getShape().getBounds2D().getWidth()), 10);
        this.wField.addActionListener(this.okListener);
        p.add(this.wField);
        p.add(new JLabel("Height (m):"));
        this.hField = new JTextField(FORMAT.format(heliostat.getShape().getBounds2D().getHeight()), 10);
        this.hField.addActionListener(this.okListener);
        p.add(this.hField);
        p.add(new JLabel("Target ID:"));
        this.targetField = new JTextField(heliostat.getTarget() == null || heliostat.getTarget().getUid() == null ? "" : heliostat.getTarget().getUid());
        this.targetField.addActionListener(this.okListener);
        p.add(this.targetField);
        this.pack();
        this.setLocationRelativeTo(view);
    }

    private float parse(String s) {
        return MiscUtil.parse(this.owner, s);
    }
}

