/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.concord.energy2d.model.HeatFluxSensor;
import org.concord.energy2d.model.Particle;
import org.concord.energy2d.undo.UndoRotateManipulable;
import org.concord.energy2d.undo.UndoTranslateManipulable;
import org.concord.energy2d.util.MiscUtil;
import org.concord.energy2d.view.View2D;

class HeatFluxSensorDialog
extends JDialog {
    private static final DecimalFormat ANGLE_FORMAT = new DecimalFormat("###.#");
    private Window owner;
    private ActionListener okListener;
    private JTextField xField;
    private JTextField yField;
    private JTextField angleField;
    private JTextField labelField;
    private JTextField uidField;
    private JTextField attachField;

    HeatFluxSensorDialog(final View2D view, final HeatFluxSensor heatFluxSensor, boolean modal) {
        super(JOptionPane.getFrameForComponent(view), "Heat Flux Sensor (#" + view.model.getHeatFluxSensors().indexOf(heatFluxSensor) + ") Options", modal);
        this.setDefaultCloseOperation(2);
        this.owner = this.getOwner();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                view.notifyManipulationListeners(heatFluxSensor, (byte)3);
                view.repaint();
                HeatFluxSensorDialog.this.dispose();
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        this.setContentPane(panel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        panel.add((Component)buttonPanel, "South");
        this.okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String attachID;
                boolean rotated;
                float angle;
                boolean moved;
                float x = HeatFluxSensorDialog.this.parse(HeatFluxSensorDialog.this.xField.getText());
                if (Float.isNaN(x)) {
                    return;
                }
                float y = HeatFluxSensorDialog.this.parse(HeatFluxSensorDialog.this.yField.getText());
                if (Float.isNaN(y)) {
                    return;
                }
                y = view.model.getLy() - y;
                boolean bl = moved = (double)Math.abs(x - heatFluxSensor.getX()) > 1.0E-6 * (double)view.model.getLx() || (double)Math.abs(y - heatFluxSensor.getY()) > 1.0E-6 * (double)view.model.getLy();
                if (moved) {
                    view.getUndoManager().addEdit(new UndoTranslateManipulable(view));
                    heatFluxSensor.setX(x);
                    heatFluxSensor.setY(y);
                }
                if (Float.isNaN(angle = HeatFluxSensorDialog.this.parse(HeatFluxSensorDialog.this.angleField.getText()))) {
                    return;
                }
                boolean bl2 = rotated = (double)Math.abs((angle = (float)Math.toRadians(angle)) - heatFluxSensor.getAngle()) > 0.001;
                if (rotated) {
                    view.getUndoManager().addEdit(new UndoRotateManipulable(view, 0.0f));
                    heatFluxSensor.setAngle(angle);
                }
                heatFluxSensor.setLabel(HeatFluxSensorDialog.this.labelField.getText());
                String uid = HeatFluxSensorDialog.this.uidField.getText();
                if (uid != null && !(uid = uid.trim()).equals("") && !uid.equals(heatFluxSensor.getUid())) {
                    if (view.isUidUsed(uid)) {
                        JOptionPane.showMessageDialog(HeatFluxSensorDialog.this.owner, "UID: " + uid + " has been taken.", "Error", 0);
                        return;
                    }
                    heatFluxSensor.setUid(uid);
                }
                if ((attachID = HeatFluxSensorDialog.this.attachField.getText()) != null && !(attachID = attachID.trim()).equals("")) {
                    if (attachID.equals(heatFluxSensor.getUid())) {
                        JOptionPane.showMessageDialog(HeatFluxSensorDialog.this.owner, "Heat flux sensor " + attachID + " cannot be attached to itself.", "Error", 0);
                        return;
                    }
                    if (!view.isUidUsed(attachID)) {
                        JOptionPane.showMessageDialog(HeatFluxSensorDialog.this.owner, "Object " + attachID + " not found.", "Error", 0);
                        return;
                    }
                    heatFluxSensor.setAttachID(attachID);
                    Particle particle = view.model.getParticle(attachID);
                    if (particle != null) {
                        heatFluxSensor.setX(particle.getRx());
                        heatFluxSensor.setY(particle.getRy());
                        heatFluxSensor.setAngle(particle.getTheta());
                    }
                }
                view.notifyManipulationListeners(heatFluxSensor, (byte)3);
                view.repaint();
                HeatFluxSensorDialog.this.dispose();
            }
        };
        JButton button = new JButton("OK");
        button.addActionListener(this.okListener);
        buttonPanel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HeatFluxSensorDialog.this.dispose();
            }
        });
        buttonPanel.add(button);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)box, "Center");
        JPanel p = new JPanel(new GridLayout(3, 2, 8, 8));
        p.setBorder(BorderFactory.createTitledBorder("General properties"));
        box.add(p);
        p.add(new JLabel("X:"));
        this.xField = new JTextField(View2D.COORDINATES_FORMAT.format(heatFluxSensor.getX()), 10);
        this.xField.addActionListener(this.okListener);
        p.add(this.xField);
        p.add(new JLabel("Y:"));
        this.yField = new JTextField(View2D.COORDINATES_FORMAT.format(view.model.getLy() - heatFluxSensor.getY()), 10);
        this.yField.addActionListener(this.okListener);
        p.add(this.yField);
        p.add(new JLabel("<html>Angle: (&deg;)</html>"));
        this.angleField = new JTextField(ANGLE_FORMAT.format(Math.toDegrees(heatFluxSensor.getAngle())), 10);
        this.angleField.addActionListener(this.okListener);
        p.add(this.angleField);
        p.add(new JLabel("Unique ID:"));
        this.uidField = new JTextField(heatFluxSensor.getUid(), 10);
        this.uidField.addActionListener(this.okListener);
        p.add(this.uidField);
        p.add(new JLabel("Label:"));
        this.labelField = new JTextField(heatFluxSensor.getLabel(), 10);
        this.labelField.addActionListener(this.okListener);
        p.add(this.labelField);
        p.add(new JLabel("Attach to:"));
        this.attachField = new JTextField(heatFluxSensor.getAttachID(), 10);
        this.attachField.addActionListener(this.okListener);
        p.add(this.attachField);
        this.pack();
        this.setLocationRelativeTo(view);
    }

    private float parse(String s) {
        return MiscUtil.parse(this.owner, s);
    }
}

