/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.concord.energy2d.math.Blob2D;
import org.concord.energy2d.math.Polygon2D;
import org.concord.energy2d.math.Ring2D;
import org.concord.energy2d.model.Cloud;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.model.Tree;
import org.concord.energy2d.view.View2D;

class HandleSetter {
    HandleSetter() {
    }

    static void setRects(View2D view, Manipulable m, Rectangle[] handle) {
        int h = handle[0].width / 2;
        Shape s = m.getShape();
        if (s instanceof RectangularShape) {
            HandleSetter.setRectHandles(view, s.getBounds2D(), handle, h);
        } else if (s instanceof Polygon2D) {
            Polygon2D p = (Polygon2D)s;
            int n = p.getVertexCount();
            if (n <= handle.length) {
                int i = 0;
                while (i < handle.length) {
                    if (i < n) {
                        Point2D.Float point = p.getVertex(i);
                        handle[i].x = view.convertPointToPixelX(point.x) - h;
                        handle[i].y = view.convertPointToPixelY(point.y) - h;
                    } else {
                        handle[i].y = -100;
                        handle[i].x = -100;
                    }
                    ++i;
                }
            } else {
                float k = (float)n / (float)handle.length;
                int i = 0;
                while (i < handle.length) {
                    Point2D.Float point = p.getVertex((int)((float)i * k));
                    handle[i].x = view.convertPointToPixelX(point.x) - h;
                    handle[i].y = view.convertPointToPixelY(point.y) - h;
                    ++i;
                }
            }
        } else if (s instanceof Blob2D) {
            Blob2D b = (Blob2D)s;
            int n = b.getPointCount();
            if (n <= handle.length) {
                int i = 0;
                while (i < handle.length) {
                    if (i < n) {
                        Point2D.Float point = b.getPoint(i);
                        handle[i].x = view.convertPointToPixelX(point.x) - h;
                        handle[i].y = view.convertPointToPixelY(point.y) - h;
                    } else {
                        handle[i].y = -100;
                        handle[i].x = -100;
                    }
                    ++i;
                }
            } else {
                float k = (float)n / (float)handle.length;
                int i = 0;
                while (i < handle.length) {
                    Point2D.Float point = b.getPoint((int)((float)i * k));
                    handle[i].x = view.convertPointToPixelX(point.x) - h;
                    handle[i].y = view.convertPointToPixelY(point.y) - h;
                    ++i;
                }
            }
        } else if (s instanceof Ring2D) {
            HandleSetter.setRectHandles(view, s.getBounds2D(), handle, h);
        } else if (s instanceof Area) {
            if (m instanceof Cloud) {
                Cloud c = (Cloud)m;
                Rectangle2D.Double bound = new Rectangle2D.Double();
                bound.x = s.getBounds2D().getX() + (double)c.getX();
                bound.y = s.getBounds2D().getY() + (double)c.getY();
                bound.width = s.getBounds2D().getWidth();
                bound.height = s.getBounds2D().getHeight();
                HandleSetter.setRectHandles(view, bound, handle, h);
            } else if (m instanceof Tree) {
                Tree t = (Tree)m;
                Rectangle2D.Double bound = new Rectangle2D.Double();
                bound.x = s.getBounds2D().getX() + (double)t.getX();
                bound.y = s.getBounds2D().getY() + (double)t.getY();
                bound.width = s.getBounds2D().getWidth();
                bound.height = s.getBounds2D().getHeight();
                HandleSetter.setRectHandles(view, bound, handle, h);
            }
        }
    }

    private static void setRectHandles(View2D view, Rectangle2D bound, Rectangle[] handle, int h) {
        handle[0].x = view.convertPointToPixelX((float)bound.getMinX()) - h;
        handle[0].y = view.convertPointToPixelY((float)bound.getMinY()) - h;
        handle[1].x = view.convertPointToPixelX((float)bound.getMinX()) - h;
        handle[1].y = view.convertPointToPixelY((float)bound.getMaxY()) - h;
        handle[2].x = view.convertPointToPixelX((float)bound.getMaxX()) - h;
        handle[2].y = view.convertPointToPixelY((float)bound.getMinY()) - h;
        handle[3].x = view.convertPointToPixelX((float)bound.getMaxX()) - h;
        handle[3].y = view.convertPointToPixelY((float)bound.getMaxY()) - h;
        handle[4].x = view.convertPointToPixelX((float)bound.getCenterX()) - h;
        handle[4].y = view.convertPointToPixelY((float)bound.getMinY()) - h;
        handle[5].x = view.convertPointToPixelX((float)bound.getCenterX()) - h;
        handle[5].y = view.convertPointToPixelY((float)bound.getMaxY()) - h;
        handle[6].x = view.convertPointToPixelX((float)bound.getMinX()) - h;
        handle[6].y = view.convertPointToPixelY((float)bound.getCenterY()) - h;
        handle[7].x = view.convertPointToPixelX((float)bound.getMaxX()) - h;
        handle[7].y = view.convertPointToPixelY((float)bound.getCenterY()) - h;
        int i = 8;
        while (i < handle.length) {
            handle[i].y = -100;
            handle[i].x = -100;
            ++i;
        }
    }
}

