/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.JComponent;

class GridRenderer {
    static final byte X_LINE = 0;
    static final byte Y_LINE = 1;
    static final int MIN_GRID_SIZE = 2;
    static final int MAX_GRID_SIZE = 25;
    private Stroke stroke = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.5f}, 0.0f);
    private Color color = new Color(128, 128, 225, 128);
    private int nx;
    private int ny;
    private int gridSize = 10;

    GridRenderer(int nx, int ny) {
        this.nx = nx;
        this.ny = ny;
    }

    void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    int getGridSize() {
        return this.gridSize;
    }

    byte onGridLine(JComponent c, int x, int y) {
        int k;
        float dx = (float)c.getWidth() / (float)this.nx;
        float dy = (float)c.getHeight() / (float)this.ny;
        int i = 0;
        while (i < this.nx) {
            k = Math.round((float)i * dx);
            if (Math.abs(x - k) < 5) {
                return 1;
            }
            i += this.gridSize;
        }
        i = 0;
        while (i < this.ny) {
            k = Math.round((float)i * dy);
            if (Math.abs(y - k) < 5) {
                return 0;
            }
            i += this.gridSize;
        }
        return -1;
    }

    void render(JComponent c, Graphics2D g) {
        int k;
        int w = c.getWidth();
        int h = c.getHeight();
        float dx = (float)w / (float)this.nx;
        float dy = (float)h / (float)this.ny;
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        g.setColor(this.color);
        g.setStroke(this.stroke);
        int i = 0;
        while (i < this.nx) {
            k = Math.round((float)i * dx);
            g.drawLine(k, 0, k, h);
            i += this.gridSize;
        }
        i = 0;
        while (i < this.ny) {
            k = Math.round((float)i * dy);
            g.drawLine(0, k, w, k);
            i += this.gridSize;
        }
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }
}

