/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.util.List;
import org.concord.energy2d.model.TimedData;

class GraphRenderer {
    static final byte CLOSE_BUTTON = 0;
    static final byte DATA_BUTTON = 1;
    static final byte X_EXPAND_BUTTON = 2;
    static final byte X_SHRINK_BUTTON = 3;
    static final byte Y_EXPAND_BUTTON = 4;
    static final byte Y_SHRINK_BUTTON = 5;
    static final byte Y_FIT_BUTTON = 6;
    static final byte Y_SELECTION_BUTTON_LEFT_ARROW = 7;
    static final byte Y_SELECTION_BUTTON_RIGHT_ARROW = 8;
    static final byte TIME_UNIT_HOUR = 0;
    static final byte TIME_UNIT_MINUTE = 1;
    static final byte TIME_UNIT_SECOND = 2;
    static final String[] DATA_TYPES = new String[]{"Temperature (\u2103)", "Heat flux (W/m\u00b2)", "Wind speed (m/s)"};
    private byte dataType = 0;
    private byte timeUnit = 0;
    private String xLabel = "Time (hr)";
    private String yLabel = DATA_TYPES[0];
    private static final DecimalFormat FORMAT = new DecimalFormat("##.####");
    private Font smallFont = new Font(null, 0, 9);
    private Font labelFont = new Font(null, 1, 12);
    private Stroke frameStroke = new BasicStroke(2.0f);
    private Stroke thinStroke = new BasicStroke(1.0f);
    private Stroke curveStroke = new BasicStroke(1.5f);
    private Color bgColor = new Color(255, 255, 225, 128);
    private Color fgColor = Color.black;
    private Color frameColor = new Color(205, 205, 205, 128);
    private int x;
    private int y;
    private int w;
    private int h;
    private float xmax = 360000.0f;
    private float ymin = 0.0f;
    private float ymax = 50.0f;
    private float yIncrement = 5.0f;
    private Rectangle closeButton = new Rectangle();
    private Rectangle dataButton = new Rectangle();
    private Rectangle xExpandButton = new Rectangle();
    private Rectangle xShrinkButton = new Rectangle();
    private Rectangle yExpandButton = new Rectangle();
    private Rectangle yShrinkButton = new Rectangle();
    private Rectangle ySelectButton = new Rectangle();
    private Rectangle yFitButton = new Rectangle();
    private Polygon[] arrowButtons = new Polygon[]{new Polygon(), new Polygon()};
    private Point mouseMovedPoint;

    GraphRenderer(int x, int y, int w, int h) {
        this.setFrame(x, y, w, h);
    }

    void reset() {
        this.dataType = 0;
        this.yLabel = DATA_TYPES[0];
    }

    void setMouseMovedPoint(Point mouseMovedPoint) {
        this.mouseMovedPoint = mouseMovedPoint;
    }

    void setLabelX(String xLabel) {
        this.xLabel = xLabel;
    }

    String getLabelX() {
        return this.xLabel;
    }

    void setLabelY(String yLabel) {
        this.yLabel = yLabel;
    }

    String getLabelY() {
        return this.yLabel;
    }

    void setXmax(float xmax) {
        this.xmax = xmax;
    }

    float getXmax() {
        return this.xmax;
    }

    void doubleXmax() {
        this.xmax *= 2.0f;
    }

    void halveXmax() {
        this.xmax *= 0.5f;
    }

    void setYmin(float ymin) {
        this.ymin = ymin;
        this.yIncrement = (this.ymax - ymin) * 0.1f;
    }

    float getYmin() {
        return this.ymin;
    }

    void decreaseYmin() {
        this.ymin -= this.yIncrement;
    }

    void setYmax(float ymax) {
        this.ymax = ymax;
        this.yIncrement = (ymax - this.ymin) * 0.1f;
    }

    float getYmax() {
        return this.ymax;
    }

    void increaseYmax() {
        this.ymax += this.yIncrement;
    }

    void decreaseYmax() {
        this.ymax -= this.yIncrement;
    }

    void setFrame(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        int size = 24;
        int position = x + w - 20;
        this.closeButton.setBounds(position, y, 20, 20);
        this.dataButton.setBounds(position -= size, y, 20, 20);
        this.xExpandButton.setBounds(position -= size, y, 20, 20);
        this.xShrinkButton.setBounds(position -= size, y, 20, 20);
        this.yExpandButton.setBounds(position -= size, y, 20, 20);
        this.yShrinkButton.setBounds(position -= size, y, 20, 20);
        this.yFitButton.setBounds(position -= size, y, 20, 20);
    }

    boolean windowContains(int rx, int ry) {
        return rx > this.x && rx < this.x + this.w && ry > this.y && ry < this.y + this.h;
    }

    boolean buttonContains(int rx, int ry) {
        return this.closeButton.contains(rx, ry) || this.dataButton.contains(rx, ry) || this.xExpandButton.contains(rx, ry) || this.xShrinkButton.contains(rx, ry) || this.yExpandButton.contains(rx, ry) || this.yShrinkButton.contains(rx, ry) || this.yFitButton.contains(rx, ry) || this.ySelectButton.contains(rx, ry);
    }

    boolean buttonContains(byte button, int rx, int ry) {
        switch (button) {
            case 0: {
                return this.closeButton.contains(rx, ry);
            }
            case 1: {
                return this.dataButton.contains(rx, ry);
            }
            case 2: {
                return this.xExpandButton.contains(rx, ry);
            }
            case 3: {
                return this.xShrinkButton.contains(rx, ry);
            }
            case 4: {
                return this.yExpandButton.contains(rx, ry);
            }
            case 5: {
                return this.yShrinkButton.contains(rx, ry);
            }
            case 6: {
                return this.yFitButton.contains(rx, ry);
            }
            case 7: {
                return new Rectangle(this.ySelectButton.x, this.ySelectButton.y, this.ySelectButton.width / 2, this.ySelectButton.height).contains(rx, ry);
            }
            case 8: {
                return new Rectangle(this.ySelectButton.x + this.ySelectButton.width / 2, this.ySelectButton.y, this.ySelectButton.width / 2, this.ySelectButton.height).contains(rx, ry);
            }
        }
        return false;
    }

    void next() {
        this.dataType = (byte)((this.dataType + 1) % DATA_TYPES.length);
        this.yLabel = DATA_TYPES[this.dataType];
    }

    void previous() {
        this.dataType = (byte)(this.dataType - 1);
        if (this.dataType < 0) {
            this.dataType = (byte)(DATA_TYPES.length - 1);
        }
        this.yLabel = DATA_TYPES[this.dataType];
    }

    void setDataType(byte dataType) {
        this.dataType = (byte)Math.min(DATA_TYPES.length - 1, dataType);
        this.yLabel = DATA_TYPES[this.dataType];
    }

    byte getDataType() {
        return this.dataType;
    }

    void setTimeUnit(byte timeUnit) {
        this.timeUnit = timeUnit;
        switch (timeUnit) {
            case 2: {
                this.xLabel = "Time (s)";
                break;
            }
            case 1: {
                this.xLabel = "Time (min)";
                break;
            }
            case 0: {
                this.xLabel = "Time (hr)";
                break;
            }
            default: {
                this.xLabel = "Time";
            }
        }
    }

    byte getTimeUnit() {
        return this.timeUnit;
    }

    private void centerString(String s, Graphics2D g, int x, int y, Shape[] shapes) {
        int stringWidth = g.getFontMetrics().stringWidth(s);
        if (shapes == this.arrowButtons) {
            Color oldColor = g.getColor();
            g.setColor(Color.lightGray);
            this.ySelectButton.setBounds(x - stringWidth / 2 - 20, y - 10, stringWidth + 40, 16);
            g.fill3DRect(this.ySelectButton.x, this.ySelectButton.y, this.ySelectButton.width, this.ySelectButton.height, true);
            g.setColor(oldColor);
            int x2 = x - stringWidth / 2 - 15;
            this.arrowButtons[0].reset();
            this.arrowButtons[0].addPoint(x2 + 10, y - 6);
            this.arrowButtons[0].addPoint(x2 + 10, y);
            this.arrowButtons[0].addPoint(x2 + 4, y - 3);
            g.fillPolygon(this.arrowButtons[0]);
            x2 = x + stringWidth / 2 + 5;
            this.arrowButtons[1].reset();
            this.arrowButtons[1].addPoint(x2 + 4, y - 6);
            this.arrowButtons[1].addPoint(x2 + 4, y);
            this.arrowButtons[1].addPoint(x2 + 10, y - 3);
            g.fillPolygon(this.arrowButtons[1]);
        }
        g.drawString(s, x - stringWidth / 2, y);
    }

    void drawFrame(Graphics2D g) {
        int k;
        float unit;
        g.setColor(this.bgColor);
        g.fillRoundRect(this.x - 10, this.y - 10, this.w + 20, this.h + 20, 20, 20);
        g.setStroke(this.frameStroke);
        g.setColor(this.frameColor);
        g.drawRoundRect(this.x - 10, this.y - 10, this.w + 20, this.h + 20, 20, 20);
        g.setStroke(this.thinStroke);
        g.setColor(this.fgColor);
        g.fillRect(this.closeButton.x + 2, this.closeButton.y + 2, this.closeButton.width, this.closeButton.height);
        g.setColor(Color.lightGray);
        g.fill(this.closeButton);
        g.setColor(this.fgColor);
        g.draw(this.closeButton);
        g.drawLine(this.closeButton.x + 4, this.closeButton.y + 4, this.closeButton.x + this.closeButton.width - 4, this.closeButton.y + this.closeButton.height - 4);
        g.drawLine(this.closeButton.x + 4, this.closeButton.y + this.closeButton.height - 4, this.closeButton.x + this.closeButton.width - 4, this.closeButton.y + 4);
        g.setColor(this.fgColor);
        g.fillRect(this.dataButton.x + 2, this.dataButton.y + 2, this.dataButton.width, this.dataButton.height);
        g.setColor(Color.lightGray);
        g.fill(this.dataButton);
        g.setColor(this.fgColor);
        g.draw(this.dataButton);
        int x2 = this.dataButton.x + 3;
        int y2 = this.dataButton.y + 3;
        int w2 = this.dataButton.width - 6;
        int h2 = this.dataButton.height - 6;
        g.drawRect(x2, y2, w2, h2);
        float cell = (float)h2 / 3.0f;
        int i = 1;
        while (i < 4) {
            int rn = Math.round((float)y2 + (float)i * cell);
            g.drawLine(x2, rn, x2 + w2, rn);
            rn = Math.round((float)x2 + (float)i * cell);
            g.drawLine(rn, y2, rn, y2 + h2);
            ++i;
        }
        g.setColor(this.fgColor);
        g.fillRect(this.xExpandButton.x + 2, this.xExpandButton.y + 2, this.xExpandButton.width, this.xExpandButton.height);
        g.setColor(Color.lightGray);
        g.fill(this.xExpandButton);
        g.setColor(this.fgColor);
        g.draw(this.xExpandButton);
        y2 = this.xExpandButton.y + this.xExpandButton.height / 2;
        x2 = this.xExpandButton.x + this.xExpandButton.width - 4;
        g.drawLine(this.xExpandButton.x + 3, y2, x2, y2);
        x2 = this.xExpandButton.x + 3;
        g.drawLine(x2, y2, x2 + 4, y2 - 4);
        g.drawLine(x2, y2, x2 + 4, y2 + 4);
        g.setColor(this.fgColor);
        g.fillRect(this.xShrinkButton.x + 2, this.xShrinkButton.y + 2, this.xShrinkButton.width, this.xShrinkButton.height);
        g.setColor(Color.lightGray);
        g.fill(this.xShrinkButton);
        g.setColor(this.fgColor);
        g.draw(this.xShrinkButton);
        x2 = this.xShrinkButton.x + this.xShrinkButton.width - 4;
        g.drawLine(this.xShrinkButton.x + 3, y2, x2, y2);
        g.drawLine(x2, y2, x2 - 4, y2 - 4);
        g.drawLine(x2, y2, x2 - 4, y2 + 4);
        g.setColor(this.fgColor);
        g.fillRect(this.yExpandButton.x + 2, this.yExpandButton.y + 2, this.yExpandButton.width, this.yExpandButton.height);
        g.setColor(Color.lightGray);
        g.fill(this.yExpandButton);
        g.setColor(this.fgColor);
        g.draw(this.yExpandButton);
        x2 = this.yExpandButton.x + this.yExpandButton.width / 2;
        y2 = this.yExpandButton.y + this.yExpandButton.height - 4;
        g.drawLine(x2, this.yExpandButton.y + 3, x2, y2);
        g.drawLine(x2, y2 + 1, x2 + 4, y2 - 3);
        g.drawLine(x2, y2 + 1, x2 - 4, y2 - 3);
        g.setColor(this.fgColor);
        g.fillRect(this.yShrinkButton.x + 2, this.yShrinkButton.y + 2, this.yShrinkButton.width, this.yShrinkButton.height);
        g.setColor(Color.lightGray);
        g.fill(this.yShrinkButton);
        g.setColor(this.fgColor);
        g.draw(this.yShrinkButton);
        x2 = this.yShrinkButton.x + this.yShrinkButton.width / 2;
        g.drawLine(x2, this.yShrinkButton.y + 3, x2, y2);
        g.drawLine(x2, this.yShrinkButton.y + 3, x2 + 4, this.yShrinkButton.y + 6);
        g.drawLine(x2, this.yShrinkButton.y + 3, x2 - 4, this.yShrinkButton.y + 6);
        g.setColor(this.fgColor);
        g.fillRect(this.yFitButton.x + 2, this.yFitButton.y + 2, this.yFitButton.width, this.yFitButton.height);
        g.setColor(Color.lightGray);
        g.fill(this.yFitButton);
        g.setColor(this.fgColor);
        g.draw(this.yFitButton);
        x2 = this.yFitButton.x + this.yFitButton.width / 2;
        g.drawLine(x2, this.yFitButton.y + 3, x2, y2);
        g.drawLine(x2, this.yFitButton.y + 3, x2 + 4, this.yFitButton.y + 6);
        g.drawLine(x2, this.yFitButton.y + 3, x2 - 4, this.yFitButton.y + 6);
        y2 = this.yFitButton.y + this.yFitButton.height - 4;
        g.drawLine(x2, y2 + 1, x2 + 4, y2 - 3);
        g.drawLine(x2, y2 + 1, x2 - 4, y2 - 3);
        g.drawLine(this.x, this.y, this.x, this.y + this.h);
        g.drawLine(this.x, this.y + this.h, this.x + this.w, this.y + this.h);
        g.drawLine(this.x, this.y, this.x - 2, this.y + 4);
        g.drawLine(this.x, this.y, this.x + 2, this.y + 4);
        g.drawLine(this.x + this.w, this.y + this.h, this.x + this.w - 4, this.y + this.h - 2);
        g.drawLine(this.x + this.w, this.y + this.h, this.x + this.w - 4, this.y + this.h + 2);
        g.setFont(this.smallFont);
        switch (this.timeUnit) {
            case 2: {
                unit = 0.1f;
                break;
            }
            case 1: {
                unit = 0.0016666667f;
                break;
            }
            default: {
                unit = 2.7777778E-5f;
            }
        }
        int i2 = 1;
        while (i2 < 10) {
            k = this.x + Math.round((float)(i2 * this.w) * 0.1f);
            if (i2 % 2 == 0) {
                g.drawLine(k, this.y + this.h, k, this.y + this.h - 4);
                this.centerString(FORMAT.format(this.xmax * (float)i2 * unit), g, k + 3, this.y + this.h - 8, null);
            } else {
                g.drawLine(k, this.y + this.h, k, this.y + this.h - 2);
            }
            ++i2;
        }
        this.centerString(this.xLabel, g, this.x + this.w - 20, this.y + this.h - 4, null);
        int nTickmarksOfYAxis = 10;
        int tens = 1;
        float dyMultiplied = (this.ymax - this.ymin) / (float)nTickmarksOfYAxis;
        while (dyMultiplied < 1.0f) {
            dyMultiplied *= 10.0f;
            tens *= 10;
        }
        dyMultiplied = (float)Math.ceil(dyMultiplied);
        float yminMultiplied = (float)Math.floor(this.ymin * (float)tens);
        float scaleY = (float)this.h / (this.ymax - this.ymin);
        int i3 = 0;
        while (i3 < nTickmarksOfYAxis + 1) {
            float yTickmark = (yminMultiplied + (float)i3 * dyMultiplied) / (float)tens;
            if (yTickmark > this.ymin && yTickmark < this.ymax) {
                k = (int)((float)(this.y + this.h) - (yTickmark - this.ymin) * scaleY);
                if (i3 % 2 == 0) {
                    g.drawLine(this.x, k, this.x + 4, k);
                    this.centerString(FORMAT.format(yTickmark), g, this.x + 18, k + 3, null);
                } else {
                    g.drawLine(this.x, k, this.x + 2, k);
                }
            }
            ++i3;
        }
        this.centerString(this.yLabel, g, this.x + 70, this.y + 10, this.arrowButtons);
        if (this.mouseMovedPoint != null) {
            this.drawButtonInfo(g);
        }
    }

    private void drawButtonInfo(Graphics2D g) {
        String s = null;
        Rectangle r = null;
        if (this.closeButton.contains(this.mouseMovedPoint)) {
            s = "Close graph";
            r = this.closeButton;
        } else if (this.dataButton.contains(this.mouseMovedPoint)) {
            s = "View data";
            r = this.dataButton;
        } else if (this.xExpandButton.contains(this.mouseMovedPoint)) {
            s = "Expand x axis";
            r = this.xExpandButton;
        } else if (this.xShrinkButton.contains(this.mouseMovedPoint)) {
            s = "Shrink x axis";
            r = this.xShrinkButton;
        } else if (this.yExpandButton.contains(this.mouseMovedPoint)) {
            s = "Expand y axis";
            r = this.yExpandButton;
        } else if (this.yShrinkButton.contains(this.mouseMovedPoint)) {
            s = "Shrink y axis";
            r = this.yShrinkButton;
        } else if (this.yFitButton.contains(this.mouseMovedPoint)) {
            s = "Fit y axis to data";
            r = this.yFitButton;
        } else if (this.ySelectButton.contains(this.mouseMovedPoint)) {
            s = "Select data type";
            r = this.ySelectButton;
        }
        if (s == null) {
            return;
        }
        g.setFont(this.smallFont);
        int stringWidth = g.getFontMetrics().stringWidth(s);
        g.setStroke(this.thinStroke);
        g.setColor(Color.black);
        g.fillRoundRect(r.x + (r.width - stringWidth) / 2 - 5, r.y - 24, stringWidth + 10, 20, 8, 8);
        g.setColor(Color.white);
        g.drawString(s, r.x + (r.width - stringWidth) / 2, r.y - 12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawData(Graphics2D g, List<TimedData> data, String label, boolean highlight) {
        g.setStroke(this.curveStroke);
        g.setColor(highlight ? Color.yellow : this.fgColor);
        int n = data.size();
        if (n > 0) {
            int m = Math.max(1, n / this.w);
            TimedData d = data.get(0);
            float t1 = d.getTime();
            float v1 = d.getValue();
            int x1 = 0;
            int y1 = 0;
            int x2 = 0;
            int y2 = 0;
            float scaleX = (float)this.w / this.xmax;
            float scaleY = (float)this.h / (this.ymax - this.ymin);
            List<TimedData> list = data;
            synchronized (list) {
                int i = m;
                while (i <= n - m) {
                    x1 = (int)((float)this.x + t1 * scaleX);
                    y1 = (int)((float)(this.y + this.h) - (v1 - this.ymin) * scaleY);
                    if (x1 > this.x + this.w) break;
                    d = data.get(i);
                    float t2 = d.getTime();
                    float v2 = d.getValue();
                    x2 = (int)((float)this.x + t2 * scaleX);
                    y2 = (int)((float)(this.y + this.h) - (v2 - this.ymin) * scaleY);
                    g.drawLine(x1, y1, x2, y2);
                    t1 = t2;
                    v1 = v2;
                    i += m;
                }
            }
            if (label != null) {
                g.setFont(this.labelFont);
                g.drawString(label, x2 + 5, y2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    float[] getData(List<TimedData> data, int rx, int ry) {
        if (!data.isEmpty()) {
            int dx = 0;
            int dy = 0;
            float scaleX = (float)this.w / this.xmax;
            float scaleY = (float)this.h / (this.ymax - this.ymin);
            List<TimedData> list = data;
            synchronized (list) {
                for (TimedData d : data) {
                    float v;
                    float t = d.getTime();
                    dx = (int)((float)this.x + t * scaleX) - rx;
                    if (dx * dx + (dy = (int)((float)(this.y + this.h) - ((v = d.getValue()) - this.ymin) * scaleY) - ry) * dy >= 100) continue;
                    return new float[]{t, v};
                }
            }
        }
        return null;
    }
}

