/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.concord.energy2d.model.Fan;
import org.concord.energy2d.undo.UndoResizeManipulable;
import org.concord.energy2d.undo.UndoTranslateManipulable;
import org.concord.energy2d.util.MiscUtil;
import org.concord.energy2d.view.View2D;

class FanDialog
extends JDialog {
    private static final DecimalFormat FORMAT = new DecimalFormat("####.######");
    private JTextField xField;
    private JTextField yField;
    private JTextField wField;
    private JTextField hField;
    private JTextField uidField;
    private JTextField labelField;
    private JTextField velocityField;
    private JCheckBox draggableCheckBox;
    private Window owner;
    private ActionListener okListener;

    FanDialog(final View2D view, final Fan fan, boolean modal) {
        super(JOptionPane.getFrameForComponent(view), "Fan (#" + view.model.getFans().indexOf(fan) + ") Properties", modal);
        this.setDefaultCloseOperation(2);
        this.owner = this.getOwner();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                view.notifyManipulationListeners(fan, (byte)3);
                view.repaint();
                FanDialog.this.dispose();
            }
        });
        this.okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String uid;
                float x = FanDialog.this.parse(FanDialog.this.xField.getText());
                if (Float.isNaN(x)) {
                    return;
                }
                float y = FanDialog.this.parse(FanDialog.this.yField.getText());
                if (Float.isNaN(y)) {
                    return;
                }
                float w = FanDialog.this.parse(FanDialog.this.wField.getText());
                if (Float.isNaN(w)) {
                    return;
                }
                float h = FanDialog.this.parse(FanDialog.this.hField.getText());
                if (Float.isNaN(h)) {
                    return;
                }
                float speed = FanDialog.this.parse(FanDialog.this.velocityField.getText());
                if (Float.isNaN(speed)) {
                    return;
                }
                float angle = 0.0f;
                Shape s = fan.getShape();
                if (s instanceof Rectangle2D.Float) {
                    boolean resized;
                    boolean moved;
                    Rectangle2D.Float r = (Rectangle2D.Float)s;
                    float dx = 1.0E-6f * view.model.getLx();
                    float dy = 1.0E-6f * view.model.getLy();
                    boolean bl = moved = Math.abs((double)x - s.getBounds2D().getX()) > (double)dx || Math.abs((double)y - s.getBounds2D().getY()) > (double)dy;
                    if (moved) {
                        view.getUndoManager().addEdit(new UndoTranslateManipulable(view));
                    }
                    boolean bl2 = resized = Math.abs((double)w - s.getBounds2D().getWidth()) > (double)dx || Math.abs((double)h - s.getBounds2D().getHeight()) > (double)dy;
                    if (resized) {
                        view.getUndoManager().addEdit(new UndoResizeManipulable(view));
                    }
                    r.setRect(x, view.model.getLy() - y, w, h);
                    if (w > h) {
                        angle = 90.0f;
                    }
                }
                if ((uid = FanDialog.this.uidField.getText()) != null && !(uid = uid.trim()).equals("") && !uid.equals(fan.getUid()) && view.isUidUsed(uid)) {
                    JOptionPane.showMessageDialog(FanDialog.this.owner, "UID: " + uid + " has been taken.", "Error", 0);
                    return;
                }
                fan.setUid(uid);
                fan.setLabel(FanDialog.this.labelField.getText());
                fan.setSpeed(angle == 0.0f ? speed : -speed);
                fan.setAngle((float)Math.toRadians(angle));
                fan.setDraggable(FanDialog.this.draggableCheckBox.isSelected());
                view.notifyManipulationListeners(fan, (byte)3);
                view.setSelectedManipulable(view.getSelectedManipulable());
                view.repaint();
                FanDialog.this.dispose();
            }
        };
        JPanel panel = new JPanel(new BorderLayout());
        this.setContentPane(panel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        panel.add((Component)buttonPanel, "South");
        this.draggableCheckBox = new JCheckBox("Draggable by user", fan.isDraggable());
        buttonPanel.add(this.draggableCheckBox);
        JButton button = new JButton("OK");
        button.addActionListener(this.okListener);
        buttonPanel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FanDialog.this.dispose();
            }
        });
        buttonPanel.add(button);
        JPanel p = new JPanel(new GridLayout(7, 2, 8, 8));
        p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)p, "Center");
        p.add(new JLabel("Unique ID:"));
        this.uidField = new JTextField(fan.getUid(), 10);
        this.uidField.addActionListener(this.okListener);
        p.add(this.uidField);
        p.add(new JLabel("Label:"));
        this.labelField = new JTextField(fan.getLabel(), 10);
        this.labelField.addActionListener(this.okListener);
        p.add(this.labelField);
        p.add(new JLabel("X (m):"));
        this.xField = new JTextField(FORMAT.format(fan.getShape().getBounds2D().getX()), 10);
        this.xField.addActionListener(this.okListener);
        p.add(this.xField);
        p.add(new JLabel("Y (m):"));
        this.yField = new JTextField(FORMAT.format((double)view.model.getLy() - fan.getShape().getBounds2D().getY()), 10);
        this.yField.addActionListener(this.okListener);
        p.add(this.yField);
        p.add(new JLabel("Width (m):"));
        this.wField = new JTextField(FORMAT.format(fan.getShape().getBounds2D().getWidth()), 10);
        this.wField.addActionListener(this.okListener);
        p.add(this.wField);
        p.add(new JLabel("Height (m):"));
        this.hField = new JTextField(FORMAT.format(fan.getShape().getBounds2D().getHeight()), 10);
        this.hField.addActionListener(this.okListener);
        p.add(this.hField);
        p.add(new JLabel("Velocity (m/s):"));
        this.velocityField = new JTextField(FORMAT.format(fan.getShape().getBounds2D().getWidth() < fan.getShape().getBounds2D().getHeight() ? fan.getSpeed() : -fan.getSpeed()));
        this.velocityField.addActionListener(this.okListener);
        p.add(this.velocityField);
        this.pack();
        this.setLocationRelativeTo(view);
    }

    private float parse(String s) {
        return MiscUtil.parse(this.owner, s);
    }
}

