/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.concord.energy2d.model.Anemometer;
import org.concord.energy2d.model.HeatFluxSensor;
import org.concord.energy2d.model.Sensor;
import org.concord.energy2d.model.Thermometer;
import org.concord.energy2d.model.TimedData;
import org.concord.energy2d.system.System2D;
import org.concord.energy2d.view.View2D;

class DataViewer {
    private View2D view;

    DataViewer(View2D view) {
        this.view = view;
    }

    void showDataOfType(byte type) {
        switch (type) {
            case 0: {
                List<Thermometer> thermometers = this.view.model.getThermometers();
                int n = thermometers.size();
                if (n < 1) {
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this.view), "No thermometer is found.", "No sensor", 1);
                    return;
                }
                Sensor[] sensors = new Sensor[n];
                int i = 0;
                while (i < n) {
                    sensors[i] = thermometers.get(i);
                    ++i;
                }
                this.showData("Thermometer" + (n > 1 ? "s" : "") + " (" + '\u2103' + ")", sensors);
                break;
            }
            case 1: {
                List<HeatFluxSensor> heatFluxSensors = this.view.model.getHeatFluxSensors();
                int n = heatFluxSensors.size();
                if (n < 1) {
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this.view), "No heat flux sensor is found.", "No sensor", 1);
                    return;
                }
                Sensor[] sensors = new Sensor[n];
                int i = 0;
                while (i < n) {
                    sensors[i] = heatFluxSensors.get(i);
                    ++i;
                }
                this.showData("Heat Flux Sensor" + (n > 1 ? "s" : "") + " (W/m" + '\u00b2' + ")", sensors);
                break;
            }
            case 2: {
                List<Anemometer> anemometers = this.view.model.getAnemometers();
                int n = anemometers.size();
                if (n < 1) {
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this.view), "No anemometer is found.", "No sensor", 1);
                    return;
                }
                Sensor[] sensors = new Sensor[n];
                int i = 0;
                while (i < n) {
                    sensors[i] = anemometers.get(i);
                    ++i;
                }
                this.showData("Anemometer" + (n > 1 ? "s" : "") + " (m/s)", sensors);
            }
        }
    }

    private void showData(String title, Sensor[] sensors) {
        List<TimedData> data = sensors[0].getData();
        int n = data.size();
        if (n < 1) {
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this.view), "No data has been collected.", "No data", 1);
            return;
        }
        String[] header = new String[sensors.length + 1];
        header[0] = "Time";
        Object[][] column = new Object[n][sensors.length + 1];
        int i = 0;
        while (i < n) {
            column[i][0] = Float.valueOf(data.get(i).getTime());
            ++i;
        }
        int j = 0;
        while (j < sensors.length) {
            header[j + 1] = sensors[j].getLabel() != null ? sensors[j].getLabel() : "Value";
            data = sensors[j].getData();
            int i2 = 0;
            while (i2 < n) {
                column[i2][j + 1] = Float.valueOf(data.get(i2).getValue());
                ++i2;
            }
            ++j;
        }
        this.showDataWindow(title, column, header);
    }

    void showData(Sensor sensor) {
        List<TimedData> data = sensor.getData();
        int n = data.size();
        if (n < 1) {
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this.view), "No data has been collected.", "No data", 1);
            return;
        }
        String[] header = new String[]{"Time", sensor.getLabel() != null ? sensor.getLabel() : "Value"};
        Object[][] column = new Object[n][2];
        data = sensor.getData();
        int i = 0;
        while (i < n) {
            TimedData d = data.get(i);
            column[i][0] = Float.valueOf(d.getTime());
            column[i][1] = Float.valueOf(d.getValue());
            ++i;
        }
        this.showDataWindow(sensor.getName(), column, header);
    }

    private void showDataWindow(String title, Object[][] column, String[] header) {
        final JDialog dataWindow = new JDialog(JOptionPane.getFrameForComponent(this.view), title, true);
        dataWindow.setDefaultCloseOperation(2);
        final JTable table = new JTable(column, header);
        table.setModel(new DefaultTableModel(column, header){

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        });
        dataWindow.getContentPane().add((Component)new JScrollPane(table), "Center");
        JPanel p = new JPanel();
        dataWindow.getContentPane().add((Component)p, "South");
        JButton button = new JButton("Copy Data");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.selectAll();
                ActionEvent ae = new ActionEvent(table, 1001, "copy");
                if (ae != null) {
                    table.getActionMap().get(ae.getActionCommand()).actionPerformed(ae);
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(DataViewer.this.view), "The data is now ready for pasting.", "Copy Data", 1);
                    table.clearSelection();
                }
            }
        });
        button.setEnabled(!System2D.isApplet());
        button.setToolTipText(button.isEnabled() ? "Copy data to the system clipboard" : "Copying data is not allowed as this is an applet.");
        p.add(button);
        button = new JButton("Close");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dataWindow.dispose();
            }
        });
        p.add(button);
        dataWindow.pack();
        dataWindow.setLocationRelativeTo(this.view);
        dataWindow.setVisible(true);
    }

    void showAllData() {
        List<Anemometer> anemometers;
        List<HeatFluxSensor> heatFluxSensors;
        final JDialog dataWindow = new JDialog(JOptionPane.getFrameForComponent(this.view), "Sensor Data", true);
        dataWindow.setDefaultCloseOperation(2);
        final JTabbedPane tabbedPane = new JTabbedPane();
        dataWindow.getContentPane().add((Component)tabbedPane, "Center");
        final ArrayList<JTable> tables = new ArrayList<JTable>();
        List<Thermometer> thermometers = this.view.model.getThermometers();
        int count = thermometers.size();
        if (count > 0) {
            int n = thermometers.get(0).getData().size();
            Object[] header = new String[count + 1];
            header[0] = "Time";
            Object[][] column = new Object[n][count + 1];
            int i = 0;
            while (i < n) {
                column[i][0] = Float.valueOf(thermometers.get(0).getData().get(i).getTime());
                ++i;
            }
            int j = 0;
            while (j < count) {
                Thermometer t = thermometers.get(j);
                header[j + 1] = t.getLabel() != null ? t.getLabel() : "Value";
                int i2 = 0;
                while (i2 < n) {
                    column[i2][j + 1] = Float.valueOf(t.getData().get(i2).getValue());
                    ++i2;
                }
                ++j;
            }
            JTable table = new JTable(column, header);
            table.setModel(new DefaultTableModel(column, header){

                @Override
                public boolean isCellEditable(int row, int col) {
                    return false;
                }
            });
            tables.add(table);
            tabbedPane.addTab("Thermometer" + (count > 1 ? "s" : "") + " (" + '\u2103' + ")", new JScrollPane(table));
        }
        if ((count = (heatFluxSensors = this.view.model.getHeatFluxSensors()).size()) > 0) {
            int n = heatFluxSensors.get(0).getData().size();
            Object[] header = new String[count + 1];
            header[0] = "Time";
            Object[][] column = new Object[n][count + 1];
            int i = 0;
            while (i < n) {
                column[i][0] = Float.valueOf(heatFluxSensors.get(0).getData().get(i).getTime());
                ++i;
            }
            int j = 0;
            while (j < count) {
                HeatFluxSensor h = heatFluxSensors.get(j);
                header[j + 1] = h.getLabel() != null ? h.getLabel() : "Value";
                int i3 = 0;
                while (i3 < n) {
                    column[i3][j + 1] = Float.valueOf(h.getData().get(i3).getValue());
                    ++i3;
                }
                ++j;
            }
            JTable table = new JTable(column, header);
            table.setModel(new DefaultTableModel(column, header){

                @Override
                public boolean isCellEditable(int row, int col) {
                    return false;
                }
            });
            tables.add(table);
            tabbedPane.addTab("Heat Flux Sensor" + (n > 1 ? "s" : "") + " (W/m" + '\u00b2' + ")", new JScrollPane(table));
        }
        if ((count = (anemometers = this.view.model.getAnemometers()).size()) > 0) {
            int n = anemometers.get(0).getData().size();
            Object[] header = new String[count + 1];
            header[0] = "Time";
            Object[][] column = new Object[n][count + 1];
            int i = 0;
            while (i < n) {
                column[i][0] = Float.valueOf(anemometers.get(0).getData().get(i).getTime());
                ++i;
            }
            int j = 0;
            while (j < count) {
                Anemometer a = anemometers.get(j);
                header[j + 1] = a.getLabel() != null ? a.getLabel() : "Value";
                int i4 = 0;
                while (i4 < n) {
                    column[i4][j + 1] = Float.valueOf(a.getData().get(i4).getValue());
                    ++i4;
                }
                ++j;
            }
            JTable table = new JTable(column, header);
            table.setModel(new DefaultTableModel(column, header){

                @Override
                public boolean isCellEditable(int row, int col) {
                    return false;
                }
            });
            tables.add(table);
            tabbedPane.addTab("Anemometer" + (count > 1 ? "s" : "") + " (m/s)", new JScrollPane(table));
        }
        if (tables.isEmpty()) {
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this.view), "No sensor is found.", "No sensor", 1);
            return;
        }
        JPanel p = new JPanel();
        dataWindow.getContentPane().add((Component)p, "South");
        JButton button = new JButton("Copy Data");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex = tabbedPane.getSelectedIndex();
                JTable t = (JTable)tables.get(selectedIndex);
                if (t != null) {
                    t.selectAll();
                    ActionEvent ae = new ActionEvent(t, 1001, "copy");
                    if (ae != null) {
                        t.getActionMap().get(ae.getActionCommand()).actionPerformed(ae);
                        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(DataViewer.this.view), "The data is now ready for pasting.", "Copy Data", 1);
                        t.clearSelection();
                    }
                }
            }
        });
        button.setEnabled(!System2D.isApplet());
        button.setToolTipText(button.isEnabled() ? "Copy data to the system clipboard" : "Copying data is not allowed as this is an applet.");
        p.add(button);
        button = new JButton("Close");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dataWindow.dispose();
            }
        });
        p.add(button);
        dataWindow.pack();
        dataWindow.setLocationRelativeTo(this.view);
        dataWindow.setVisible(true);
    }
}

