/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

class ColorPalette {
    private static final short[][] RAINBOW_RGB;
    private static final short[][] IRON_RGB;
    private static final short[][] GRAY_RGB;
    private short[][] rgbScale;
    private Font font = new Font(null, 1, 8);
    private float rx;
    private float ry;
    private float rw;
    private float rh;
    private int labelCount = 5;
    private int w;
    private int h;
    private int x;
    private int y;
    private boolean fahrenheitUsed;

    static {
        short[][] sArrayArray = new short[11][];
        short[] sArray = new short[3];
        sArray[2] = 128;
        sArrayArray[0] = sArray;
        sArrayArray[1] = new short[]{20, 50, 120};
        sArrayArray[2] = new short[]{20, 100, 200};
        sArrayArray[3] = new short[]{10, 150, 150};
        sArrayArray[4] = new short[]{120, 180, 50};
        sArrayArray[5] = new short[]{220, 200, 10};
        sArrayArray[6] = new short[]{240, 160, 36};
        sArrayArray[7] = new short[]{225, 50, 50};
        sArrayArray[8] = new short[]{230, 85, 110};
        sArrayArray[9] = new short[]{250, 250, 250};
        sArrayArray[10] = new short[]{255, 255, 255};
        RAINBOW_RGB = sArrayArray;
        IRON_RGB = new short[][]{{40, 20, 100}, {80, 20, 150}, {150, 20, 150}, {200, 50, 120}, {220, 80, 80}, {230, 120, 30}, {240, 200, 20}, {240, 220, 80}, {255, 255, 125}, {250, 250, 250}, {255, 255, 255}};
        GRAY_RGB = new short[][]{{50, 50, 50}, {75, 75, 75}, {100, 100, 100}, {125, 125, 125}, {150, 150, 150}, {175, 175, 175}, {200, 200, 200}, {225, 225, 225}, {250, 250, 250}, {255, 255, 255}};
    }

    ColorPalette(short[][] rgbScale) {
        this.rgbScale = rgbScale;
    }

    static short[][] getRgbArray(byte type) {
        switch (type) {
            case 0: {
                return RAINBOW_RGB;
            }
            case 1: {
                return IRON_RGB;
            }
            case 2: {
                return GRAY_RGB;
            }
        }
        return RAINBOW_RGB;
    }

    void setUseFahrenheit(boolean b) {
        this.fahrenheitUsed = b;
    }

    void setRect(float rx, float ry, float rw, float rh) {
        this.rx = rx;
        this.ry = ry;
        this.rw = rw;
        this.rh = rh;
    }

    Rectangle2D.Float getRect() {
        return new Rectangle2D.Float(this.rx, this.ry, this.rw, this.rh);
    }

    private int getColor(int i) {
        float v = (float)i * (float)this.rgbScale.length / (float)Math.max(this.w, this.h);
        if (v > (float)(this.rgbScale.length - 2)) {
            v = this.rgbScale.length - 2;
        } else if (v < 0.0f) {
            v = 0.0f;
        }
        int iv = (int)v;
        int rc = (int)((float)this.rgbScale[iv][0] * (1.0f - (v -= (float)iv)) + (float)this.rgbScale[iv + 1][0] * v);
        int gc = (int)((float)this.rgbScale[iv][1] * (1.0f - v) + (float)this.rgbScale[iv + 1][1] * v);
        int bc = (int)((float)this.rgbScale[iv][2] * (1.0f - v) + (float)this.rgbScale[iv + 1][2] * v);
        return 0xFF000000 | rc << 16 | gc << 8 | bc;
    }

    void render(JComponent c, Graphics2D g, float max, float min) {
        this.x = (int)(this.rx * (float)c.getWidth());
        this.y = (int)(this.ry * (float)c.getHeight());
        this.w = (int)(this.rw * (float)c.getWidth());
        this.h = (int)(this.rh * (float)c.getHeight());
        if (this.h == 0) {
            this.h = 20;
        }
        if (this.w == 0) {
            this.w = c.getWidth() - 100;
        }
        if (this.x == 0) {
            this.x = 50;
        }
        if (this.y == 0) {
            this.y = 20;
        }
        Font oldFont = g.getFont();
        g.setFont(this.font);
        if (this.h > this.w) {
            int i = 0;
            while (i < this.h) {
                g.setColor(new Color(this.getColor(i)));
                g.drawLine(this.x, this.y + i, this.x + this.w, this.y + i);
                ++i;
            }
            g.setColor(Color.white);
            g.draw3DRect(this.x, this.y, this.w, this.h, true);
            String s = null;
            int i2 = 0;
            while (i2 < this.labelCount + 1) {
                s = this.fahrenheitUsed ? String.valueOf(Math.round((double)(min + (float)i2 * (max - min) / (float)this.labelCount) * 1.8 + 32.0)) + "\u2109" : String.valueOf((int)(min + (float)i2 * (max - min) / (float)this.labelCount)) + "\u2103";
                g.drawString(s, (float)(this.x + this.w + 15), (float)this.y + (float)this.h * (float)i2 / (float)this.labelCount + 2.5f);
                ++i2;
            }
        } else {
            int i = 0;
            while (i < this.w) {
                g.setColor(new Color(this.getColor(i)));
                g.drawLine(this.x + i, this.y, this.x + i, this.y + this.h);
                ++i;
            }
            g.setColor(Color.white);
            g.draw3DRect(this.x, this.y, this.w, this.h, true);
            String s = null;
            FontMetrics fm = g.getFontMetrics();
            int i3 = 0;
            while (i3 < this.labelCount + 1) {
                s = this.fahrenheitUsed ? String.valueOf(Math.round((double)(min + (float)i3 * (max - min) / (float)this.labelCount) * 1.8 + 32.0)) + "\u2109" : String.valueOf((int)(min + (float)i3 * (max - min) / (float)this.labelCount)) + "\u2103";
                g.drawString(s, (float)this.x + (float)this.w * (float)i3 / (float)this.labelCount - (float)fm.stringWidth(s) * 0.5f, (float)(this.y + this.h + 15));
                ++i3;
            }
        }
        g.setFont(oldFont);
    }
}

