/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.concord.energy2d.model.Cloud;
import org.concord.energy2d.util.BackgroundComboBox;
import org.concord.energy2d.util.ColorFill;
import org.concord.energy2d.util.MiscUtil;
import org.concord.energy2d.view.View2D;

class CloudDialog
extends JDialog {
    private Window owner;
    private JColorChooser colorChooser;
    private JCheckBox draggableCheckBox;
    private BackgroundComboBox bgComboBox;
    private JTextField speedField;
    private ActionListener okListener;

    CloudDialog(final View2D view, final Cloud cloud, boolean modal) {
        super(JOptionPane.getFrameForComponent(view), "Cloud (#" + view.model.getClouds().indexOf(cloud) + ") Properties", modal);
        this.setDefaultCloseOperation(2);
        this.owner = this.getOwner();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                view.notifyManipulationListeners(cloud, (byte)3);
                view.repaint();
                CloudDialog.this.dispose();
            }
        });
        this.okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float x = MiscUtil.parse(CloudDialog.this.owner, CloudDialog.this.speedField.getText());
                if (Float.isNaN(x)) {
                    return;
                }
                cloud.setSpeed(x);
                cloud.setDraggable(CloudDialog.this.draggableCheckBox.isSelected());
                view.notifyManipulationListeners(cloud, (byte)3);
                view.setSelectedManipulable(view.getSelectedManipulable());
                view.repaint();
                CloudDialog.this.dispose();
            }
        };
        JPanel panel = new JPanel(new BorderLayout());
        this.setContentPane(panel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        panel.add((Component)buttonPanel, "South");
        JButton button = new JButton("OK");
        button.addActionListener(this.okListener);
        buttonPanel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudDialog.this.dispose();
            }
        });
        buttonPanel.add(button);
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)box, "Center");
        Box miscBox = Box.createVerticalBox();
        miscBox.setBorder(BorderFactory.createTitledBorder("General"));
        box.add(miscBox);
        JPanel p = new JPanel(new FlowLayout(0));
        miscBox.add(p);
        p.add(new JLabel("Speed:"));
        this.speedField = new JTextField(String.valueOf(cloud.getSpeed()), 10);
        this.speedField.addActionListener(this.okListener);
        p.add(this.speedField);
        p.add(new JLabel("Color:"));
        this.colorChooser = new JColorChooser();
        this.colorChooser.setColor(cloud.getColor());
        this.bgComboBox = new BackgroundComboBox(this, this.colorChooser, null);
        this.bgComboBox.setToolTipText("Background color");
        this.bgComboBox.setFillPattern(new ColorFill(cloud.getColor()));
        this.bgComboBox.getColorMenu().setColorArrayAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = CloudDialog.this.bgComboBox.getColorMenu().getColor();
                cloud.setColor(c);
                view.repaint();
                CloudDialog.this.bgComboBox.getColorMenu().firePropertyChange("Filling", null, new ColorFill(c));
            }
        });
        this.bgComboBox.getColorMenu().setMoreColorAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = CloudDialog.this.bgComboBox.getColorMenu().getColorChooser().getColor();
                cloud.setColor(c);
                view.repaint();
                CloudDialog.this.bgComboBox.getColorMenu().firePropertyChange("Filling", null, new ColorFill(c));
            }
        });
        this.bgComboBox.getColorMenu().addHexColorListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = CloudDialog.this.bgComboBox.getColorMenu().getHexInputColor(cloud.getColor());
                if (c == null) {
                    return;
                }
                cloud.setColor(c);
                view.repaint();
                CloudDialog.this.bgComboBox.getColorMenu().firePropertyChange("Filling", null, new ColorFill(c));
            }
        });
        p.add(this.bgComboBox);
        this.draggableCheckBox = new JCheckBox("Draggable by user", cloud.isDraggable());
        p.add(this.draggableCheckBox);
        this.pack();
        this.setLocationRelativeTo(view);
    }
}

