/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.util;

import java.util.LinkedHashMap;

public class XmlCharacterEncoder {
    private static final char LESS_THAN = '<';
    private static final char GREATER_THAN = '>';
    private static final char AMPERSAND = '&';
    private static final char APOSTROPHE = '\'';
    private static final char QUOTATION = '\"';
    private static final char LINE_BREAK = '\n';
    private LinkedHashMap<Integer, Character> store = new LinkedHashMap();

    public String encode(String text) {
        if (text == null) {
            return null;
        }
        int i = 0;
        while (i < text.length()) {
            switch (text.charAt(i)) {
                case '<': {
                    this.store.put(i, Character.valueOf('<'));
                    break;
                }
                case '>': {
                    this.store.put(i, Character.valueOf('>'));
                    break;
                }
                case '&': {
                    this.store.put(i, Character.valueOf('&'));
                    break;
                }
                case '\'': {
                    this.store.put(i, Character.valueOf('\''));
                    break;
                }
                case '\"': {
                    this.store.put(i, Character.valueOf('\"'));
                    break;
                }
                case '\n': {
                    this.store.put(i, Character.valueOf('\n'));
                }
            }
            ++i;
        }
        if (!this.store.isEmpty()) {
            StringBuffer sb = new StringBuffer(text);
            int cumu = 0;
            int del = 0;
            for (Integer index : this.store.keySet()) {
                Character character = this.store.get(index);
                switch (character.charValue()) {
                    case '<': {
                        del = index + cumu;
                        sb.deleteCharAt(del);
                        sb.insert(del, "&lt;");
                        cumu += "&lt;".length() - 1;
                        break;
                    }
                    case '>': {
                        del = index + cumu;
                        sb.deleteCharAt(del);
                        sb.insert(del, "&gt;");
                        cumu += "&gt;".length() - 1;
                        break;
                    }
                    case '&': {
                        del = index + cumu;
                        sb.deleteCharAt(del);
                        sb.insert(del, "&amp;");
                        cumu += "&amp;".length() - 1;
                        break;
                    }
                    case '\'': {
                        del = index + cumu;
                        sb.deleteCharAt(del);
                        sb.insert(del, "&apos;");
                        cumu += "&apos;".length() - 1;
                        break;
                    }
                    case '\"': {
                        del = index + cumu;
                        sb.deleteCharAt(del);
                        sb.insert(del, "&quot;");
                        cumu += "&quot;".length() - 1;
                        break;
                    }
                    case '\n': {
                        del = index + cumu;
                        sb.deleteCharAt(del);
                        sb.insert(del, "-linebreak-");
                        cumu += "-linebreak-".length() - 1;
                    }
                }
            }
            text = sb.toString();
        }
        return text;
    }
}

