/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.concord.energy2d.util.Texture;
import org.concord.energy2d.util.TextureCode;

public final class TextureFactory {
    private static final BasicStroke ultrathin = new BasicStroke(0.5f);
    private static final BasicStroke thin = new BasicStroke(1.0f);
    public static final byte SMALL = 101;
    public static final byte MEDIUM = 102;
    public static final byte LARGE = 103;
    public static final byte HUGE = 104;
    public static final byte POLKA = 1;
    public static final byte MOSIAC = 2;
    public static final byte POSITIVE = 3;
    public static final byte NEGATIVE = 4;
    public static final byte STARRY = 5;
    public static final byte CIRCULAR = 6;
    public static final byte HORIZONTAL_STRIPE = 7;
    public static final byte VERTICAL_STRIPE = 8;
    public static final byte DIAGONAL_UP_STRIPE = 9;
    public static final byte DIAGONAL_DOWN_STRIPE = 10;
    public static final byte GRID = 11;
    public static final byte HORIZONTAL_BRICK = 12;
    public static final byte INSULATION = 13;
    public static final byte FINE_SCREEN = 14;
    public static final byte CONCRETE = 15;
    public static final byte DOT_ARRAY = 16;
    public static final byte SINGLE_CIRCLE = 17;
    public static final byte DOUBLE_CIRCLES = 18;
    public static final byte HORIZONTAL_LATTICE = 19;
    public static final byte TRIANGLE_HALF = 20;
    public static final byte DICE = 21;
    public static final byte DIAGONAL_CROSS = 22;
    public static final byte STONE_WALL = 23;
    static final ArrayList<TextureCode> textureList = new ArrayList();
    private static Rectangle r;

    static {
        textureList.add(new TextureCode(7, 101));
        textureList.add(new TextureCode(7, 102));
        textureList.add(new TextureCode(8, 101));
        textureList.add(new TextureCode(8, 102));
        textureList.add(new TextureCode(9, 102));
        textureList.add(new TextureCode(9, 103));
        textureList.add(new TextureCode(10, 102));
        textureList.add(new TextureCode(10, 103));
        textureList.add(new TextureCode(11, 101));
        textureList.add(new TextureCode(11, 102));
        textureList.add(new TextureCode(12, 102));
        textureList.add(new TextureCode(12, 103));
        textureList.add(new TextureCode(15, 104));
        textureList.add(new TextureCode(23, 104));
        textureList.add(new TextureCode(16, 101));
        textureList.add(new TextureCode(16, 103));
        textureList.add(new TextureCode(17, 102));
        textureList.add(new TextureCode(17, 103));
        textureList.add(new TextureCode(18, 102));
        textureList.add(new TextureCode(18, 103));
        textureList.add(new TextureCode(19, 102));
        textureList.add(new TextureCode(19, 103));
        textureList.add(new TextureCode(21, 102));
        textureList.add(new TextureCode(22, 103));
        textureList.add(new TextureCode(22, 102));
        textureList.add(new TextureCode(20, 101));
        textureList.add(new TextureCode(1, 101));
        textureList.add(new TextureCode(1, 102));
        textureList.add(new TextureCode(2, 101));
        textureList.add(new TextureCode(2, 102));
        textureList.add(new TextureCode(3, 102));
        textureList.add(new TextureCode(4, 102));
        textureList.add(new TextureCode(5, 103));
        textureList.add(new TextureCode(6, 103));
        textureList.add(new TextureCode(14, 102));
        textureList.add(new TextureCode(13, 104));
        r = new Rectangle();
    }

    public static TexturePaint createPattern(int type, int w, int h, Color c1, Color c2) {
        BufferedImage bi = new BufferedImage(w, h, 2);
        Graphics2D g = bi.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setStroke(thin);
        switch (type) {
            case 1: {
                int x = w / 4;
                int y = h / 4;
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                g.fillOval(x, y, x + x, y + y);
                r.setBounds(x, y, w, h);
                return new TexturePaint(bi, r);
            }
            case 2: {
                int x = w / 2;
                int y = h / 2;
                g.setColor(c1);
                g.fillRect(0, 0, x, y);
                g.fillRect(x, y, x, y);
                g.setColor(c2);
                g.fillRect(x, 0, x, y);
                g.fillRect(0, y, x, y);
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
            case 3: {
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                int x = w / 2 + 2;
                int y = h / 2 + 2;
                g.drawLine(1, y, 3, y);
                g.drawLine(2, y - 1, 2, y + 1);
                g.drawLine(x, 1, x, 3);
                g.drawLine(x - 1, 2, x + 1, 2);
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
            case 4: {
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                int x = w / 2 + 2;
                int y = h / 2 + 2;
                g.drawLine(1, y, 3, y);
                g.drawLine(x - 1, 2, x + 1, 2);
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
            case 6: {
                int i = 0;
                while (i < w / 2) {
                    int j = 0;
                    while (j < h / 2) {
                        g.setColor(c1);
                        g.fillRect(2 * i, 2 * j, 1, 1);
                        g.fillRect(2 * i + 1, 2 * j + 1, 1, 1);
                        g.setColor(c2);
                        g.fillRect(2 * i + 1, 2 * j, 1, 1);
                        g.fillRect(2 * i, 2 * j + 1, 1, 1);
                        ++j;
                    }
                    ++i;
                }
                g.setColor(c2);
                g.drawLine(1, h / 2, 3, h / 2);
                g.drawLine(2, h / 2 - 1, 2, h / 2 + 1);
                g.drawLine(w / 2, 1, w / 2, 3);
                g.drawLine(w / 2 - 1, 2, w / 2 + 1, 2);
                r.setBounds(0, 0, w - 2, h - 2);
                return new TexturePaint(bi, r);
            }
            case 14: {
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                int i = 0;
                while (i < w / 2) {
                    int j = 0;
                    while (j < h / 2) {
                        g.fillRect(2 * i, 2 * j, 1, 1);
                        ++j;
                    }
                    ++i;
                }
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
            case 15: {
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                g.drawOval(5, 8, 6, 5);
                g.drawOval(15, 20, 5, 6);
                g.drawOval(25, 10, 4, 4);
                g.drawOval(27, 29, 4, 3);
                g.drawOval(3, 26, 3, 5);
                g.drawRect(4, 14, 1, 1);
                g.drawRect(17, 32, 1, 1);
                g.drawRect(5, 26, 1, 1);
                g.drawRect(13, 27, 1, 1);
                g.drawRect(24, 24, 1, 1);
                g.drawRect(21, 2, 1, 1);
                g.drawRect(17, 5, 1, 1);
                g.drawRect(22, 15, 1, 1);
                g.drawRect(9, 27, 1, 1);
                g.drawRect(31, 8, 1, 1);
                g.drawRect(11, 15, 1, 1);
                g.drawRect(18, 11, 1, 1);
                g.drawRect(23, 8, 1, 1);
                g.drawRect(3, 5, 1, 1);
                g.drawRect(8, 17, 1, 1);
                g.drawRect(31, 19, 1, 1);
                g.drawRect(11, 31, 1, 1);
                g.drawRect(8, 4, 1, 1);
                g.drawRect(3, 19, 1, 1);
                g.drawRect(22, 27, 1, 1);
                g.drawRect(3, 33, 1, 1);
                g.drawRect(23, 17, 1, 1);
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
            case 16: {
                int x = w / 2 + 1;
                int y = h / 2 + 1;
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                g.fillRect(1, y, 1, 1);
                g.fillRect(x, 1, 1, 1);
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
            case 5: {
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                int i = 0;
                while (i < w / 2) {
                    int j = 0;
                    while (j < h / 2) {
                        g.fillRect(2 * i + 1, 2 * j, 1, 1);
                        g.fillRect(2 * i, 2 * j + 1, 1, 1);
                        ++j;
                    }
                    ++i;
                }
                int x = w / 2 + 2;
                int y = h / 2 + 2;
                g.drawLine(1, y, 3, y);
                g.drawLine(2, y - 1, 2, y + 1);
                g.drawLine(x, 1, x, 3);
                g.drawLine(x - 1, 2, x + 1, 2);
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
            case 7: {
                int y = h / 2;
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                g.drawLine(0, y, w, y);
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
            case 8: {
                int x = w / 2;
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                g.drawLine(x, 0, x, h);
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
            case 9: {
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                g.setStroke(ultrathin);
                g.drawLine(0, h - 1, w - 1, 0);
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
            case 10: {
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                g.setStroke(ultrathin);
                g.drawLine(0, 0, w, h);
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
            case 11: {
                int x = w / 2;
                int y = h / 2;
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                g.drawLine(0, h / 2, w, h / 2);
                g.drawLine(w / 2, 0, w / 2, h);
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
            case 12: {
                int x = w / 2;
                int y = h / 2;
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                g.drawLine(0, 0, w, 0);
                g.drawLine(0, y, w, y);
                g.drawLine(0, 0, 0, y);
                g.drawLine(x, y, x, h);
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
            case 17: {
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                g.drawOval(0, 0, w, h);
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
            case 18: {
                int x = w / 4;
                int y = h / 4;
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                g.drawOval(0, 0, w, h);
                g.drawOval(x, y, x + x < w / 2 ? x + x + 2 : w / 2, y + y < h / 2 ? y + y + 2 : h / 2);
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
            case 19: {
                int x = w / 2;
                int y = h / 2;
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                g.drawOval(0, 0, x, y);
                g.drawLine(x, y / 2, w, y / 2);
                g.drawLine(x / 2, y, x / 2, h);
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
            case 21: {
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                g.drawRect(0, 0, w, h);
                g.fillOval(w / 2 - 2, h / 2 - 2, 5, 5);
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
            case 20: {
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                Polygon triangle = new Polygon();
                triangle.addPoint(0, 0);
                triangle.addPoint(w, 0);
                triangle.addPoint(0, h);
                g.fillPolygon(triangle);
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
            case 22: {
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                g.drawLine(0, 0, w, h);
                g.drawLine(w, 0, 0, h);
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
            case 23: {
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                g.drawLine(5, 0, 6, 7);
                g.drawLine(6, 7, 0, 10);
                g.drawLine(6, 7, 16, 9);
                g.drawLine(16, 9, 23, 0);
                g.drawLine(16, 9, 15, 18);
                g.drawLine(15, 18, 20, 22);
                g.drawLine(15, 18, 4, 25);
                g.drawLine(4, 25, 0, 20);
                g.drawLine(4, 25, 8, 30);
                g.drawLine(9, 30, 4, 35);
                g.drawLine(4, 35, 0, 33);
                g.drawLine(9, 30, 19, 31);
                g.drawLine(19, 31, 23, 35);
                g.drawLine(19, 31, 20, 22);
                g.drawLine(20, 22, 29, 18);
                g.drawLine(29, 18, 31, 11);
                g.drawLine(31, 11, 19, 6);
                g.drawLine(31, 11, 35, 9);
                g.drawLine(35, 20, 29, 27);
                g.drawLine(29, 27, 35, 33);
                g.drawLine(35, 9, 29, 0);
                g.drawLine(29, 0, 23, 0);
                g.drawLine(35, 33, 29, 35);
                g.drawLine(35, 19, 29, 18);
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
            case 13: {
                g.setColor(c2);
                g.fillRect(0, 0, w, h);
                g.setColor(c1);
                int a = w / 3;
                int b = h / 3;
                int u = 0;
                int i = 0;
                while (i < 3) {
                    g.drawArc(u, 0, a, b, 0, 180);
                    g.drawLine(u, b / 2, u + a / 2, h - b / 2);
                    g.drawLine(u + a / 2, h - b / 2, u + a, b / 2);
                    g.drawArc(u - a / 2, h - b, a, b, 0, -91);
                    g.drawArc(u + a / 2, h - b, a, b, 180, 91);
                    u += a;
                    ++i;
                }
                r.setBounds(0, 0, w, h);
                return new TexturePaint(bi, r);
            }
        }
        return null;
    }

    public static void renderSpecialCases(Shape s, Texture tex, Graphics2D g) {
        block7: {
            if (!(s instanceof Rectangle)) break block7;
            Rectangle r = (Rectangle)s;
            if (tex.getStyle() == 13) {
                g.setColor(new Color(tex.getForeground()));
                int m = 20;
                int minLength = 20;
                Arc2D.Float arc = new Arc2D.Float();
                Line2D.Float line = new Line2D.Float();
                if (r.width > r.height) {
                    float a = (float)r.width / (float)m;
                    if (a < (float)minLength) {
                        m = Math.round((float)r.width / (float)minLength);
                        a = (float)r.width / (float)m;
                    }
                    float b = (float)r.height / 3.0f;
                    arc.width = a;
                    arc.height = b;
                    float u = r.x;
                    int i = 0;
                    while (i < m) {
                        arc.x = u;
                        arc.y = r.y;
                        arc.start = 0.0f;
                        arc.extent = 180.0f;
                        g.draw(arc);
                        line.x1 = u;
                        line.y1 = (float)r.y + b * 0.5f;
                        line.x2 = u + a * 0.5f;
                        line.y2 = (float)(r.y + r.height) - b * 0.5f;
                        g.draw(line);
                        line.x1 = u + a;
                        g.draw(line);
                        arc.x = u - a * 0.5f;
                        arc.y = (float)(r.y + r.height) - b;
                        arc.extent = -91.0f;
                        g.draw(arc);
                        arc.x = u + a * 0.5f;
                        arc.start = 270.0f;
                        g.draw(arc);
                        u += a;
                        ++i;
                    }
                } else {
                    float b;
                    float a = (float)r.height / (float)m;
                    if (a < (float)minLength) {
                        m = Math.round((float)r.height / (float)minLength);
                        a = (float)r.height / (float)m;
                    }
                    arc.width = b = (float)r.width / 3.0f;
                    arc.height = a;
                    float v = r.y;
                    int i = 0;
                    while (i < m) {
                        arc.y = v;
                        arc.x = r.x;
                        arc.start = 90.0f;
                        arc.extent = 180.0f;
                        g.draw(arc);
                        line.y1 = v;
                        line.x1 = (float)r.x + b * 0.5f;
                        line.y2 = v + a * 0.5f;
                        line.x2 = (float)(r.x + r.width) - b * 0.5f;
                        g.draw(line);
                        line.y1 = v + a;
                        g.draw(line);
                        arc.y = v - a * 0.5f;
                        arc.x = (float)(r.x + r.width) - b;
                        arc.start = 0.0f;
                        arc.extent = -91.0f;
                        g.draw(arc);
                        arc.y = v + a * 0.5f;
                        arc.start = 90.0f;
                        g.draw(arc);
                        v += a;
                        ++i;
                    }
                }
            }
        }
    }
}

