/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.util;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.concord.energy2d.util.ColorComboBox;
import org.concord.energy2d.util.ColorRectangle;
import org.concord.energy2d.util.ComboBoxRenderer;
import org.concord.energy2d.util.FillPattern;
import org.concord.energy2d.util.Texture;
import org.concord.energy2d.util.TextureCode;
import org.concord.energy2d.util.TextureFactory;

public class TextureChooser
extends JTabbedPane {
    private TexturePanel[] pp;
    private FillPattern fillPattern;
    private ColorComboBox bgComboBox;
    private ColorComboBox fgComboBox;

    public TextureChooser() {
        this.addTab("Texture", this.createTexturePanel());
    }

    public void setSelectedForegroundColor(Color c) {
        this.fgComboBox.setColor(c);
        this.setTexturePanelForeground(c);
    }

    public void setSelectedBackgroundColor(Color c) {
        this.bgComboBox.setColor(c);
        this.setTexturePanelBackground(c);
    }

    public void setSelectedStyle(byte style, int cellWidth, int cellHeight) {
        this.setSelectedTexturePanel(style, cellWidth, cellHeight);
    }

    public static JDialog createDialog(Component parent, String title, boolean modal, TextureChooser chooser, ActionListener okListener, ActionListener cancelListener) {
        final JDialog dialog = new JDialog(JOptionPane.getFrameForComponent(parent), title == null ? "Fill Effects" : title, modal);
        dialog.setDefaultCloseOperation(2);
        Container container = dialog.getContentPane();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        container.add((Component)panel, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 6;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        panel.add((Component)chooser, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        panel.add((Component)new JLabel(), c);
        final ActionListener okListener1 = okListener;
        TextureChooser chooser1 = chooser;
        JButton button = new JButton("OK");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (TextureChooser.this.getSelectedIndex()) {
                    case 0: {
                        TexturePanel pp = TextureChooser.this.getSelectedTexturePanel();
                        if (pp == null) break;
                        TextureChooser.this.fillPattern = new Texture(pp.getForeground().getRGB(), pp.getBackground().getRGB(), pp.getStyle(), pp.getCellWidth(), pp.getCellHeight());
                    }
                }
                okListener1.actionPerformed(e);
                dialog.dispose();
            }
        });
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        panel.add((Component)button, c);
        button = new JButton("Cancel");
        if (cancelListener != null) {
            button.addActionListener(cancelListener);
        } else {
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialog.dispose();
                }
            });
        }
        c.gridy = 2;
        panel.add((Component)button, c);
        dialog.pack();
        if (parent == null) {
            dialog.setLocation(200, 200);
        } else {
            dialog.setLocationRelativeTo(JOptionPane.getFrameForComponent(parent));
        }
        return dialog;
    }

    private void setSelectedTexturePanel(byte style, int cellWidth, int cellHeight) {
        TexturePanel[] texturePanelArray = this.pp;
        int n = this.pp.length;
        int n2 = 0;
        while (n2 < n) {
            TexturePanel p;
            p.setSelected((p = texturePanelArray[n2]).getStyle() == style && p.getCellWidth() == cellWidth && p.getCellHeight() == cellHeight);
            ++n2;
        }
    }

    private TexturePanel getSelectedTexturePanel() {
        TexturePanel[] texturePanelArray = this.pp;
        int n = this.pp.length;
        int n2 = 0;
        while (n2 < n) {
            TexturePanel p = texturePanelArray[n2];
            if (p.isSelected()) {
                return p;
            }
            ++n2;
        }
        return null;
    }

    private void setTexturePanelForeground(Color c) {
        TexturePanel[] texturePanelArray = this.pp;
        int n = this.pp.length;
        int n2 = 0;
        while (n2 < n) {
            TexturePanel p = texturePanelArray[n2];
            p.setForeground(c);
            ++n2;
        }
    }

    private void setTexturePanelBackground(Color c) {
        TexturePanel[] texturePanelArray = this.pp;
        int n = this.pp.length;
        int n2 = 0;
        while (n2 < n) {
            TexturePanel p = texturePanelArray[n2];
            p.setBackground(c);
            ++n2;
        }
    }

    private JPanel createTexturePanel() {
        int grid;
        JPanel p = new JPanel(new BorderLayout(10, 10));
        final int size = TextureFactory.textureList.size();
        final JPanel texturePanel = new JPanel(new GridLayout(grid, (grid = (int)Math.sqrt((double)size + 1.0E-4)) * grid < size ? grid + 1 : grid, 2, 2));
        texturePanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int iSelected = -1;
                int k = 0;
                while (k < TextureChooser.this.pp.length) {
                    if (TextureChooser.this.pp[k].isSelected()) {
                        iSelected = k;
                    }
                    ++k;
                }
                if (iSelected == -1) {
                    return;
                }
                switch (e.getKeyCode()) {
                    case 38: {
                        if (iSelected < grid) break;
                        TextureChooser.this.pp[iSelected].setSelected(false);
                        TextureChooser.this.pp[iSelected -= grid].setSelected(true);
                        texturePanel.repaint();
                        break;
                    }
                    case 40: {
                        if (iSelected >= size - grid) break;
                        TextureChooser.this.pp[iSelected].setSelected(false);
                        TextureChooser.this.pp[iSelected += grid].setSelected(true);
                        texturePanel.repaint();
                        break;
                    }
                    case 37: {
                        if (iSelected <= 0) break;
                        TextureChooser.this.pp[iSelected].setSelected(false);
                        TextureChooser.this.pp[--iSelected].setSelected(true);
                        texturePanel.repaint();
                        break;
                    }
                    case 39: {
                        if (iSelected >= size - 1) break;
                        TextureChooser.this.pp[iSelected].setSelected(false);
                        TextureChooser.this.pp[++iSelected].setSelected(true);
                        texturePanel.repaint();
                    }
                }
            }
        });
        p.add((Component)texturePanel, "Center");
        this.pp = new TexturePanel[size];
        int cell = 10;
        int i = 0;
        while (i < this.pp.length) {
            TextureCode tc = TextureFactory.textureList.get(i);
            switch (tc.size) {
                case 101: {
                    cell = 4;
                    break;
                }
                case 102: {
                    cell = 8;
                    break;
                }
                case 103: {
                    cell = 12;
                    break;
                }
                case 104: {
                    cell = 36;
                }
            }
            this.pp[i] = new TexturePanel(tc.style, cell, cell);
            texturePanel.add(this.pp[i]);
            final int ii = i;
            this.pp[i].addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int k = 0;
                    while (k < TextureChooser.this.pp.length) {
                        TextureChooser.this.pp[k].setSelected(k == ii);
                        TextureChooser.this.pp[k].repaint();
                        ++k;
                    }
                    texturePanel.requestFocusInWindow();
                }
            });
            ++i;
        }
        this.pp[0].setSelected(true);
        JPanel p4 = new JPanel(new GridLayout(1, 2, 10, 10));
        p4.setBorder(new EmptyBorder(10, 10, 10, 10));
        p.add((Component)p4, "South");
        JPanel p3 = new JPanel(new BorderLayout());
        p4.add(p3);
        JLabel label = new JLabel("Foreground Color:");
        p3.add((Component)label, "North");
        this.fgComboBox = new ColorComboBox(this);
        this.fgComboBox.setRenderer(new ComboBoxRenderer.ColorCell());
        this.fgComboBox.setToolTipText("Foreground color");
        this.fgComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final ColorComboBox cb = (ColorComboBox)e.getSource();
                int id = cb.getSelectedIndex();
                if (id >= ColorRectangle.COLORS.length + 1) {
                    cb.updateColor(new Runnable(){

                        @Override
                        public void run() {
                            TextureChooser.this.setTexturePanelForeground(cb.getMoreColor());
                        }
                    });
                } else if (id == ColorRectangle.COLORS.length) {
                    TextureChooser.this.setTexturePanelForeground(cb.getMoreColor());
                } else {
                    TextureChooser.this.setTexturePanelForeground(ColorRectangle.COLORS[id]);
                }
            }
        });
        p3.add((Component)this.fgComboBox, "Center");
        label.setLabelFor(this.fgComboBox);
        p3 = new JPanel(new BorderLayout());
        p4.add(p3);
        label = new JLabel("Background Color:");
        p3.add((Component)label, "North");
        this.bgComboBox = new ColorComboBox(this);
        this.bgComboBox.setRenderer(new ComboBoxRenderer.ColorCell());
        this.bgComboBox.setToolTipText("Background color");
        this.bgComboBox.setSelectedIndex(ColorRectangle.COLORS.length);
        this.bgComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final ColorComboBox cb = (ColorComboBox)e.getSource();
                int id = cb.getSelectedIndex();
                if (id >= ColorRectangle.COLORS.length + 1) {
                    cb.updateColor(new Runnable(){

                        @Override
                        public void run() {
                            TextureChooser.this.setTexturePanelBackground(cb.getMoreColor());
                        }
                    });
                } else if (id == ColorRectangle.COLORS.length) {
                    TextureChooser.this.setTexturePanelBackground(cb.getMoreColor());
                } else {
                    TextureChooser.this.setTexturePanelBackground(ColorRectangle.COLORS[id]);
                }
            }
        });
        p3.add((Component)this.bgComboBox, "Center");
        label.setLabelFor(this.bgComboBox);
        return p;
    }

    public FillPattern getFillPattern() {
        return this.fillPattern;
    }

    public void setFillPattern(FillPattern fp) {
        this.fillPattern = fp;
    }

    class TexturePanel
    extends JPanel {
        private final BasicStroke highlightOutside = new BasicStroke(4.0f);
        private final BasicStroke highlightInside = new BasicStroke(2.0f);
        private boolean selected;
        private byte style = 1;
        private int cellWidth = 12;
        private int cellHeight = 12;

        public TexturePanel(byte style, int cellWidth, int cellHeight) {
            this.setBackground(Color.white);
            this.setForeground(Color.black);
            this.style = style;
            this.cellWidth = cellWidth;
            this.cellHeight = cellHeight;
            this.setPreferredSize(new Dimension(36, 36));
        }

        public void setStyle(byte i) {
            this.style = i;
        }

        public byte getStyle() {
            return this.style;
        }

        public void setCellWidth(int i) {
            this.cellWidth = i;
        }

        public int getCellWidth() {
            return this.cellWidth;
        }

        public void setCellHeight(int i) {
            this.cellHeight = i;
        }

        public int getCellHeight() {
            return this.cellHeight;
        }

        public void setSelected(boolean b) {
            this.selected = b;
        }

        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            int w = this.getWidth();
            int h = this.getHeight();
            g2d.setPaint(TextureFactory.createPattern(this.style, this.cellWidth, this.cellHeight, this.getForeground(), this.getBackground()));
            g2d.fillRect(0, 0, w, h);
            if (this.selected) {
                g2d.setStroke(this.highlightOutside);
                g2d.setColor(Color.black);
                g2d.drawRect(2, 2, w - 5, h - 5);
                g2d.setStroke(this.highlightInside);
                g2d.setColor(Color.white);
                g2d.drawRect(2, 2, w - 5, h - 5);
            }
        }
    }
}

