/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.util;

import java.awt.Color;
import java.awt.Paint;
import org.concord.energy2d.util.FillPattern;
import org.concord.energy2d.util.MiscUtil;
import org.concord.energy2d.util.TextureFactory;

public class Texture
implements FillPattern {
    private int fgColor = -16777216;
    private int bgColor = -1;
    private int alpha = 255;
    private byte type = (byte)9;
    private int cellWidth = 10;
    private int cellHeight = 10;
    private transient Paint texturePaint;

    public Texture() {
    }

    public Texture(int fgColor, int bgColor, byte type, int cellWidth, int cellHeight) {
        this.fgColor = fgColor;
        this.bgColor = bgColor;
        this.type = type;
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
        this.texturePaint = TextureFactory.createPattern(type, cellWidth, cellHeight, new Color(fgColor), new Color(bgColor));
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public Paint getPaint() {
        return this.texturePaint;
    }

    public byte getStyle() {
        return this.type;
    }

    public void setStyle(byte i) {
        this.type = i;
        if (this.cellWidth <= 0 || this.cellHeight <= 0) {
            return;
        }
        this.texturePaint = TextureFactory.createPattern(this.type, this.cellWidth, this.cellHeight, new Color(this.fgColor), new Color(this.bgColor));
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public void setCellWidth(int w) {
        this.cellWidth = w;
        if (this.cellWidth <= 0 || this.cellHeight <= 0) {
            return;
        }
        this.texturePaint = TextureFactory.createPattern(this.type, this.cellWidth, this.cellHeight, new Color(this.fgColor), new Color(this.bgColor));
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public void setCellHeight(int h) {
        this.cellHeight = h;
        if (this.cellWidth <= 0 || this.cellHeight <= 0) {
            return;
        }
        this.texturePaint = TextureFactory.createPattern(this.type, this.cellWidth, this.cellHeight, new Color(this.fgColor), new Color(this.bgColor));
    }

    public int getBackground() {
        return this.bgColor;
    }

    public void setBackground(int c) {
        this.bgColor = c;
        if (this.cellWidth <= 0 || this.cellHeight <= 0) {
            return;
        }
        this.texturePaint = TextureFactory.createPattern(this.type, this.cellWidth, this.cellHeight, new Color(this.fgColor), new Color(this.bgColor));
    }

    public int getForeground() {
        return this.fgColor;
    }

    public void setForeground(int c) {
        this.fgColor = c;
        if (this.cellWidth <= 0 || this.cellHeight <= 0) {
            return;
        }
        this.texturePaint = TextureFactory.createPattern(this.type, this.cellWidth, this.cellHeight, new Color(this.fgColor), new Color(this.bgColor));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Texture)) {
            return false;
        }
        int i = ((Texture)obj).getForeground();
        if (i != this.fgColor) {
            return false;
        }
        i = ((Texture)obj).getBackground();
        if (i != this.bgColor) {
            return false;
        }
        i = ((Texture)obj).getStyle();
        if (i != this.type) {
            return false;
        }
        i = ((Texture)obj).getCellWidth();
        if (i != this.cellWidth) {
            return false;
        }
        i = ((Texture)obj).getCellHeight();
        return i == this.cellHeight;
    }

    public int hashCode() {
        int result = 23;
        result = MiscUtil.hash(result, this.fgColor);
        result = MiscUtil.hash(result, this.bgColor);
        result = MiscUtil.hash(result, this.type);
        result = MiscUtil.hash(result, this.cellWidth);
        result = MiscUtil.hash(result, this.cellHeight);
        return result;
    }

    public String toString() {
        return "Texture " + this.type;
    }
}

