/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.util;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class TextComponentPopupMenu
extends JPopupMenu {
    protected Map<Object, Action> actions;
    protected JTextComponent text;
    protected JMenuItem miCut;
    protected JMenuItem miPaste;
    protected JMenuItem miCopy;
    protected JMenuItem miSelectAll;

    public TextComponentPopupMenu(JTextComponent t) {
        this.text = t;
        this.actions = new HashMap<Object, Action>();
        Action[] actionArray = this.text.getActions();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Action act = actionArray[n2];
            this.actions.put(act.getValue("Name"), act);
            ++n2;
        }
        boolean isMac = System.getProperty("os.name").startsWith("Mac");
        this.miCopy = new JMenuItem(this.actions.get("copy-to-clipboard"));
        this.miCopy.setText("Copy");
        this.miCopy.setAccelerator(isMac ? KeyStroke.getKeyStroke(67, 4) : KeyStroke.getKeyStroke(67, 2));
        this.add(this.miCopy);
        this.miCut = new JMenuItem(this.actions.get("cut-to-clipboard"));
        this.miCut.setText("Cut");
        this.miCut.setAccelerator(isMac ? KeyStroke.getKeyStroke(88, 4) : KeyStroke.getKeyStroke(88, 2));
        this.add(this.miCut);
        this.miPaste = new JMenuItem(this.actions.get("paste-from-clipboard"));
        this.miPaste.setText("Paste");
        this.miPaste.setAccelerator(isMac ? KeyStroke.getKeyStroke(86, 4) : KeyStroke.getKeyStroke(86, 2));
        this.add(this.miPaste);
        this.miSelectAll = new JMenuItem(this.actions.get("select-all"));
        this.miSelectAll.setText("Select All");
        this.miSelectAll.setAccelerator(isMac ? KeyStroke.getKeyStroke(65, 4) : KeyStroke.getKeyStroke(65, 2));
        this.add(this.miSelectAll);
    }

    @Override
    public void show(Component invoker, int x, int y) {
        super.show(invoker, x, y);
        this.miCut.setEnabled(this.text.getSelectedText() != null && this.text.isEditable());
        this.miCopy.setEnabled(this.text.getSelectedText() != null);
        this.miPaste.setEnabled(this.text.isEditable());
        this.miSelectAll.setEnabled(this.text.getText() != null);
    }

    public JTextComponent getTextComponent() {
        return this.text;
    }

    public void setPasteAction(ActionListener listener) {
        String text = this.miPaste.getText();
        Icon icon = this.miPaste.getIcon();
        ActionListener[] al = this.miPaste.getActionListeners();
        if (al != null) {
            ActionListener[] actionListenerArray = al;
            int n = al.length;
            int n2 = 0;
            while (n2 < n) {
                ActionListener x = actionListenerArray[n2];
                this.miPaste.removeActionListener(x);
                ++n2;
            }
        }
        if (listener != null) {
            this.miPaste.addActionListener(listener);
        }
        this.miPaste.setText(text);
        this.miPaste.setIcon(icon);
    }
}

