/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.util;

import java.util.regex.Pattern;

public abstract class Scripter {
    protected static final String REGEX_SEPARATOR = "[,\\s&&[^\\r\\n]]";
    protected static final String REGEX_WHITESPACE = "[\\s&&[^\\r\\n]]";
    protected static final String REGEX_NONNEGATIVE_DECIMAL = "((\\d*\\.\\d+)|(\\d+\\.\\d*)|(\\d+))";
    protected static final Pattern COMMAND_BREAK = Pattern.compile("(;|\\r?\\n|\\r)+");
    protected static final Pattern COMMENT = Pattern.compile("^(//|/\\*)");
    protected static final Pattern BEEP = Pattern.compile("(^(?i)beep\\b){1}");
    protected static final Pattern RESET = Pattern.compile("(^(?i)reset\\b){1}");
    protected static final Pattern RELOAD = Pattern.compile("(^(?i)reload\\b){1}");
    protected static final Pattern RUN = Pattern.compile("(^(?i)run\\b){1}");
    protected static final Pattern STOP = Pattern.compile("(^(?i)stop\\b){1}");
    protected static final Pattern INIT = Pattern.compile("(^(?i)init\\b){1}");
    protected static final Pattern LOAD = Pattern.compile("(^(?i)load\\b){1}");
    protected static final Pattern ADD = Pattern.compile("(^(?i)add\\b){1}");
    protected static final Pattern REMOVE = Pattern.compile("(^(?i)remove\\b){1}");
    protected static final Pattern DELAY = Pattern.compile("(^(?i)delay\\b){1}");
    protected static final Pattern SET = Pattern.compile("(^(?i)set\\b){1}");

    public void executeScript(String script) {
        String[] command = COMMAND_BREAK.split(script);
        if (command.length < 1) {
            return;
        }
        String[] stringArray = command;
        int n = command.length;
        int n2 = 0;
        while (n2 < n) {
            String ci = stringArray[n2];
            if (!(ci = ci.trim()).equals("") && !COMMENT.matcher(ci).find()) {
                this.evalCommand(ci);
            }
            ++n2;
        }
    }

    protected abstract void evalCommand(String var1);

    public static float[] parseArray(int n, String str) {
        String[] s;
        if ((str = str.trim()).startsWith("(")) {
            str = str.substring(1);
        }
        if (str.endsWith(")")) {
            str = str.substring(0, str.length() - 1);
        }
        if ((s = str.split(",")).length != n) {
            return null;
        }
        return Scripter.parseArray(n, s);
    }

    public static float[] parseArray(int n, String[] s) {
        if (n > s.length) {
            return null;
        }
        float[] x = new float[n];
        float z = 0.0f;
        int i = 0;
        while (i < n) {
            try {
                z = Float.parseFloat(s[i]);
            }
            catch (NumberFormatException e) {
                return null;
            }
            x[i] = z;
            ++i;
        }
        return x;
    }
}

