/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.concord.energy2d.util.FileChooser;
import org.concord.energy2d.util.ImagePreview;
import org.concord.energy2d.util.MiscUtil;

public class ScreenshotSaver
extends AbstractAction {
    private JComponent component;
    private boolean borderless;
    private Border savedBorder;
    private ImagePreview imagePreview;
    private FileChooser fileChooser;
    private FileFilter pngFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            String filename = file.getName();
            int index = filename.lastIndexOf(46);
            if (index == -1) {
                return false;
            }
            String postfix = filename.substring(index + 1);
            return "png".equalsIgnoreCase(postfix);
        }

        @Override
        public String getDescription() {
            return "PNG";
        }
    };

    public ScreenshotSaver(JComponent c, boolean noframe) {
        this.component = c;
        this.borderless = noframe;
        this.fileChooser = new FileChooser();
        this.imagePreview = new ImagePreview(this.fileChooser);
        this.putValue("Name", "Save As Image...");
        this.putValue("ShortDescription", "Save a screenshot of the current view");
        this.putValue("MnemonicKey", new Integer(77));
        this.putValue("AcceleratorKey", System.getProperty("os.name").startsWith("Mac") ? KeyStroke.getKeyStroke(77, 4, true) : KeyStroke.getKeyStroke(77, 2, true));
    }

    public void destroy() {
        if (this.imagePreview != null && this.fileChooser != null) {
            this.fileChooser.removePropertyChangeListener(this.imagePreview);
        }
        this.component = null;
        this.fileChooser = null;
    }

    public void setCurrentDirectory(File file) {
        this.fileChooser.setCurrentDirectory(file);
    }

    public String getLatestPath() {
        return this.fileChooser.getLatestPath();
    }

    public void setFrame(boolean b) {
        this.borderless = !b;
    }

    public boolean getFrame() {
        return !this.borderless;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fileChooser.setAcceptAllFileFilterUsed(false);
        this.fileChooser.addChoosableFileFilter(this.pngFilter);
        this.fileChooser.setFileFilter(this.pngFilter);
        this.fileChooser.setDialogType(1);
        this.fileChooser.setDialogTitle("Save image");
        this.fileChooser.setApproveButtonMnemonic('S');
        String latestPath = this.fileChooser.getLatestPath();
        if (latestPath != null) {
            this.fileChooser.setCurrentDirectory(new File(latestPath));
        }
        this.fileChooser.setAccessory(this.imagePreview);
        if (this.fileChooser.showSaveDialog(JOptionPane.getFrameForComponent(this.component)) == 0) {
            File file = this.fileChooser.getSelectedFile();
            String filename = MiscUtil.fileNameAutoExtend(this.fileChooser.getFileFilter(), file);
            File temp = new File(filename);
            if (temp.exists() && JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(this.component), "File " + temp.getName() + " exists, overwrite?", "File exists", 0) == 1) {
                this.fileChooser.resetChoosableFileFilters();
                return;
            }
            if (!this.borderless) {
                this.savedBorder = this.component.getBorder();
                this.component.setBorder(BorderFactory.createLineBorder(Color.black));
            }
            this.write(temp.getPath());
            if (this.savedBorder != null) {
                this.component.setBorder(this.savedBorder);
                this.savedBorder = null;
            }
            this.fileChooser.rememberFile(file.getPath());
        }
    }

    protected void write(String name) {
        block12: {
            Dimension size = this.component.getSize();
            BufferedImage bufferedImage = new BufferedImage(size.width, size.height, 1);
            Graphics2D g2 = bufferedImage.createGraphics();
            this.component.paint(g2);
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(name);
                    ImageIO.write((RenderedImage)bufferedImage, MiscUtil.getSuffix(name), out);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    if (out == null) break block12;
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

