/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.Array;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.EventListener;
import java.util.Locale;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Synthesizer;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.filechooser.FileFilter;

public final class MiscUtil {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final int fODD_PRIME_NUMBER = 37;
    private static Synthesizer synthesizer;

    public static int hash(int aSeed, boolean aBoolean) {
        return MiscUtil.firstTerm(aSeed) + (aBoolean ? 1 : 0);
    }

    public static int hash(int aSeed, char aChar) {
        return MiscUtil.firstTerm(aSeed) + aChar;
    }

    public static int hash(int aSeed, int aInt) {
        return MiscUtil.firstTerm(aSeed) + aInt;
    }

    public static int hash(int aSeed, long aLong) {
        return MiscUtil.firstTerm(aSeed) + (int)(aLong ^ aLong >>> 32);
    }

    public static int hash(int aSeed, float aFloat) {
        return MiscUtil.hash(aSeed, Float.floatToIntBits(aFloat));
    }

    public static int hash(int aSeed, double aDouble) {
        return MiscUtil.hash(aSeed, Double.doubleToLongBits(aDouble));
    }

    public static int hash(int aSeed, Object aObject) {
        int result = aSeed;
        if (aObject == null) {
            result = MiscUtil.hash(result, 0);
        } else if (!MiscUtil.isArray(aObject)) {
            result = MiscUtil.hash(result, aObject.hashCode());
        } else {
            int length = Array.getLength(aObject);
            int idx = 0;
            while (idx < length) {
                Object item = Array.get(aObject, idx);
                result = MiscUtil.hash(result, item);
                ++idx;
            }
        }
        return result;
    }

    private static int firstTerm(int aSeed) {
        return 37 * aSeed;
    }

    private static boolean isArray(Object aObject) {
        return aObject.getClass().isArray();
    }

    public static String getFileName(String path) {
        if (path == null) {
            return null;
        }
        int i = path.lastIndexOf("/");
        if (i == -1) {
            i = path.lastIndexOf("\\");
        }
        if (i == -1) {
            i = path.lastIndexOf(FILE_SEPARATOR);
        }
        if (i == -1) {
            return path;
        }
        return path.substring(i + 1, path.length());
    }

    public static String getExtensionInLowerCase(File file) {
        if (file == null || file.isDirectory()) {
            return null;
        }
        String extension = MiscUtil.getSuffix(file.getName());
        if (extension != null) {
            return extension.toLowerCase();
        }
        return null;
    }

    public static String getSuffix(String filename) {
        String extension = null;
        int index = filename.lastIndexOf(46);
        if (index >= 1 && index < filename.length() - 1) {
            extension = filename.substring(index + 1);
        }
        return extension;
    }

    public static String fileNameAutoExtend(FileFilter filter, File file) {
        if (filter == null) {
            return file.getAbsolutePath();
        }
        String description = filter.getDescription().toLowerCase();
        String extension = MiscUtil.getExtensionInLowerCase(file);
        String filename = file.getAbsolutePath();
        if (extension != null) {
            if (!filter.accept(file)) {
                filename = file.getAbsolutePath().concat(".").concat(description);
            }
        } else {
            filename = file.getAbsolutePath().concat(".").concat(description);
        }
        return filename;
    }

    public static String getParentDirectory(String path) {
        if (path == null) {
            return null;
        }
        if (path.toLowerCase().indexOf("http://") != -1 || path.toLowerCase().indexOf("https://") != -1) {
            int i = path.lastIndexOf(47);
            if (i == -1) {
                return null;
            }
            return path.substring(0, i + 1);
        }
        int i = path.lastIndexOf(FILE_SEPARATOR);
        if (i == -1) {
            i = path.lastIndexOf("/");
        }
        if (i == -1) {
            return null;
        }
        return path.substring(0, i + 1);
    }

    public static void setSelectedSilently(AbstractButton x, boolean b) {
        EventListener[] eventListenerArray;
        ItemListener[] il;
        int n;
        ActionListener[] al = x.getActionListeners();
        if (al != null && al.length > 0) {
            ActionListener[] actionListenerArray = al;
            n = al.length;
            int n2 = 0;
            while (n2 < n) {
                ActionListener a = actionListenerArray[n2];
                x.removeActionListener(a);
                ++n2;
            }
        }
        if ((il = x.getItemListeners()) != null && il.length > 0) {
            eventListenerArray = il;
            int n3 = il.length;
            n = 0;
            while (n < n3) {
                EventListener a = eventListenerArray[n];
                x.removeItemListener((ItemListener)a);
                ++n;
            }
        }
        x.setSelected(b);
        if (al != null && al.length > 0) {
            eventListenerArray = al;
            int n4 = al.length;
            n = 0;
            while (n < n4) {
                EventListener a = eventListenerArray[n];
                x.addActionListener((ActionListener)a);
                ++n;
            }
        }
        if (il != null && il.length > 0) {
            eventListenerArray = il;
            int n5 = il.length;
            n = 0;
            while (n < n5) {
                EventListener a = eventListenerArray[n];
                x.addItemListener((ItemListener)a);
                ++n;
            }
        }
    }

    public static void copy(float[][] dst, float[][] src) {
        int i = 0;
        while (i < src.length) {
            System.arraycopy(src[i], 0, dst[i], 0, src[i].length);
            ++i;
        }
    }

    public static String formatTime(int time) {
        int seconds = time % 60;
        int minutes = (time /= 60) % 60;
        int hours = (time /= 60) % 24;
        int days = time /= 24;
        return String.format("%d:%02d:%02d:%02d", days, hours, minutes, seconds);
    }

    public static boolean isRightClick(MouseEvent e) {
        if ((e.getModifiers() & 4) != 0) {
            return true;
        }
        return System.getProperty("os.name").startsWith("Mac") && e.isControlDown();
    }

    public static Color convertToColor(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Did you mean to convert hexadecimal RGB to color?");
        }
        if (s.length() == 7 && s.charAt(0) == '#') {
            int r = Integer.parseInt(s.substring(1, 3), 16);
            int g = Integer.parseInt(s.substring(3, 5), 16);
            int b = Integer.parseInt(s.substring(5, 7), 16);
            return new Color(r, g, b);
        }
        if (s.length() == 6) {
            int r = Integer.parseInt(s.substring(0, 2), 16);
            int g = Integer.parseInt(s.substring(2, 4), 16);
            int b = Integer.parseInt(s.substring(4, 6), 16);
            return new Color(r, g, b);
        }
        throw new NumberFormatException("hex color code error");
    }

    public static Color getContrastColor(Color c) {
        return MiscUtil.getContrastColor(c, c.getAlpha());
    }

    public static Color getContrastColor(Color c, int alpha) {
        return new Color(255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue(), alpha);
    }

    public static Color parseRGBColor(String str) {
        if (str.startsWith("0x")) {
            try {
                return new Color(Integer.valueOf(str.substring(2), 16));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (str.startsWith("#")) {
            try {
                return new Color(Integer.valueOf(str.substring(1), 16));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void makeCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout;
        try {
            layout = (SpringLayout)parent.getLayout();
        }
        catch (ClassCastException exc) {
            System.err.println("The first argument to makeCompactGrid must use SpringLayout.");
            return;
        }
        Spring x = Spring.constant(initialX);
        int c = 0;
        while (c < cols) {
            Spring width = Spring.constant(0);
            int r = 0;
            while (r < rows) {
                width = Spring.max(width, MiscUtil.getConstraintsForCell(r, c, parent, cols).getWidth());
                ++r;
            }
            r = 0;
            while (r < rows) {
                SpringLayout.Constraints constraints = MiscUtil.getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
                ++r;
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
            ++c;
        }
        Spring y = Spring.constant(initialY);
        int r = 0;
        while (r < rows) {
            Spring height = Spring.constant(0);
            int c2 = 0;
            while (c2 < cols) {
                height = Spring.max(height, MiscUtil.getConstraintsForCell(r, c2, parent, cols).getHeight());
                ++c2;
            }
            c2 = 0;
            while (c2 < cols) {
                SpringLayout.Constraints constraints = MiscUtil.getConstraintsForCell(r, c2, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
                ++c2;
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
            ++r;
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }

    private static SpringLayout.Constraints getConstraintsForCell(int r, int c, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component component = parent.getComponent(r * cols + c);
        return layout.getConstraints(component);
    }

    public static void beep(int noteNumber, int velocity) {
        if (synthesizer == null) {
            try {
                synthesizer = MidiSystem.getSynthesizer();
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
                return;
            }
        }
        if (synthesizer != null) {
            try {
                synthesizer.open();
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
                return;
            }
            MidiChannel[] channels = synthesizer.getChannels();
            channels[0].noteOn(noteNumber, velocity);
        }
    }

    public static void shutdown() {
        if (synthesizer != null) {
            synthesizer.close();
        }
    }

    public static float parse(Window owner, String s) {
        float x = Float.NaN;
        try {
            x = NumberFormat.getInstance(Locale.getDefault()).parse(s).floatValue();
        }
        catch (ParseException e) {
            JOptionPane.showMessageDialog(owner, "Cannot parse " + e.getLocalizedMessage(), "Error", 0);
        }
        return x;
    }
}

