/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.border.LineBorder;

public class ImagePreview
extends JComponent
implements PropertyChangeListener {
    private ImageIcon thumbnail;
    private String path;
    private boolean lockRatio = true;

    public ImagePreview(JFileChooser fc) {
        this.setPreferredSize(new Dimension(200, 100));
        if (fc != null) {
            fc.addPropertyChangeListener(this);
        }
        this.setBorder(new LineBorder(Color.black));
    }

    public void setLockRatio(boolean b) {
        this.lockRatio = b;
    }

    public boolean getLockRatio() {
        return this.lockRatio;
    }

    public void setPath(String s) {
        this.path = s;
        if (this.path == null) {
            this.thumbnail = null;
        } else {
            this.loadImage();
        }
    }

    public void setFile(File file) {
        this.path = file != null ? file.getPath() : null;
        if (this.path == null) {
            this.thumbnail = null;
        } else {
            this.loadImage();
        }
    }

    public void loadImage() {
        if (this.path == null) {
            return;
        }
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        ImageIcon tmpIcon = new ImageIcon(this.path);
        if (this.getLockRatio()) {
            float rx = (float)tmpIcon.getIconWidth() / (float)(this.getWidth() - 10);
            float ry = (float)tmpIcon.getIconHeight() / (float)(this.getHeight() - 10);
            this.thumbnail = rx > 1.0f || ry > 1.0f ? (rx > ry ? new ImageIcon(tmpIcon.getImage().getScaledInstance(this.getWidth() - 10, -1, 1)) : new ImageIcon(tmpIcon.getImage().getScaledInstance(-1, this.getHeight() - 10, 1))) : tmpIcon;
        } else {
            this.thumbnail = new ImageIcon(tmpIcon.getImage().getScaledInstance(this.getWidth(), this.getHeight(), 1));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        File file;
        String name = e.getPropertyName();
        if (name.equals("SelectedFileChangedProperty") && (file = (File)e.getNewValue()) != null) {
            this.path = file.getPath();
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.thumbnail == null) {
            this.loadImage();
        } else {
            int x = (this.getWidth() >> 1) - (this.thumbnail.getIconWidth() >> 1);
            int y = (this.getHeight() >> 1) - (this.thumbnail.getIconHeight() >> 1);
            if (y < 0) {
                y = 0;
            }
            if (x < 5) {
                x = 5;
            }
            this.thumbnail.paintIcon(this, g, x, y);
        }
    }
}

