/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;

public class FileChooser
extends JFileChooser {
    private static final int MAX = 4;
    private List<String> recentFiles;
    private String latestPath;

    public FileChooser() {
        this.init();
    }

    public FileChooser(File currentDirectory) {
        super(currentDirectory);
        this.init();
    }

    private void init() {
        this.setMultiSelectionEnabled(false);
        this.setFileHidingEnabled(true);
        this.recentFiles = new ArrayList<String>();
    }

    public String getLatestPath() {
        return this.latestPath;
    }

    @Override
    public void setCurrentDirectory(File dir) {
        super.setCurrentDirectory(dir);
        this.latestPath = this.getCurrentDirectory().toString();
    }

    public void rememberFile(String fileName) {
        if (fileName == null) {
            return;
        }
        this.latestPath = this.getCurrentDirectory().toString();
        if (this.recentFiles.contains(fileName)) {
            this.recentFiles.remove(fileName);
        } else if (this.recentFiles.size() >= 4) {
            this.recentFiles.remove(0);
        }
        this.recentFiles.add(fileName);
    }

    public void addRecentFile(String fileName) {
        this.recentFiles.add(fileName);
    }

    public String[] getRecentFiles() {
        int n = this.recentFiles.size();
        if (n == 0) {
            return new String[0];
        }
        String[] s = new String[n];
        int i = 0;
        while (i < n) {
            s[n - 1 - i] = this.recentFiles.get(i);
            ++i;
        }
        return s;
    }
}

