/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Arrays;

public class FieldLines {
    private int arrowSpacing = 16;
    private int fluxLineSpacing = 2 * this.arrowSpacing;
    private int nx;
    private int ny;
    private float[][] func;
    private float[][] funx;
    private float[][] funy;
    private Dimension size;
    private float dx;
    private float dy;
    private float vx;
    private float vy;
    private int arrowDirection = 1;
    private int numColors = 16;
    private Color[] spectrum;
    private Color minColor = new Color(0.0f, 0.0f, 1.0f);
    private Color maxColor = new Color(1.0f, 1.0f, 1.0f);
    private Color color;
    private float minimumMagnitude = 1.0E-4f;
    private float arrowLength = 0.75f;
    private boolean[][] map;

    public FieldLines() {
        this.spectrum = new Color[this.numColors];
        int i = 0;
        while (i < this.numColors) {
            float u = (float)i / (float)(this.numColors - 1);
            this.spectrum[i] = new Color(Math.round((1.0f - u) * (float)this.minColor.getRed() + u * (float)this.maxColor.getRed()), Math.round((1.0f - u) * (float)this.minColor.getGreen() + u * (float)this.maxColor.getGreen()), Math.round((1.0f - u) * (float)this.minColor.getBlue() + u * (float)this.maxColor.getBlue()));
            ++i;
        }
    }

    public void setArrowSpacing(int arrowSpacing) {
        this.arrowSpacing = arrowSpacing;
    }

    public void setFluxLineSpacing(int fluxLineSpacing) {
        this.fluxLineSpacing = fluxLineSpacing;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setMinimumColor(Color c) {
        this.minColor = c;
    }

    public void setMaximumColor(Color c) {
        this.maxColor = c;
    }

    public void render(Graphics2D g, Dimension size, float[][] funx, float[][] funy) {
        this.funx = funx;
        this.funy = funy;
        this.nx = funx.length;
        this.ny = funx[0].length;
        this.size = size;
        this.dx = (float)size.width / (float)this.nx;
        this.dy = (float)size.height / (float)this.ny;
        int mx = size.width / this.fluxLineSpacing + 1;
        int my = size.height / this.fluxLineSpacing + 1;
        if (this.map == null || this.map.length != mx || this.map[0].length != my) {
            this.map = new boolean[mx][my];
        }
        int i = 0;
        while (i < this.map.length) {
            Arrays.fill(this.map[i], false);
            ++i;
        }
        int maxLength = Math.max(size.width, size.height);
        float x = 0.0f;
        float y = 0.0f;
        int i2 = 0;
        while (i2 < this.map.length) {
            int j = 0;
            while (j < this.map[0].length) {
                if (!this.map[i2][j]) {
                    x = ((float)i2 + 0.5f) * (float)this.fluxLineSpacing;
                    y = ((float)j + 0.5f) * (float)this.fluxLineSpacing;
                    this.drawFluxLineForVector(g, x, y, 1.0f, maxLength);
                    this.drawFluxLineForVector(g, x, y, -1.0f, maxLength);
                }
                ++j;
            }
            ++i2;
        }
    }

    private void drawFluxLineForVector(Graphics2D g, float x, float y, float sign, int maxLength) {
        double magnitude = 0.0;
        float newX = 0.0f;
        float newY = 0.0f;
        float arrowScale = sign * this.arrowLength * (float)this.arrowSpacing;
        int k = 0;
        while (k < maxLength) {
            int i = Math.round(x / this.dx);
            int j = Math.round(y / this.dy);
            if (i > 0 && i < this.nx - 1 && j > 0 && j < this.ny - 1) {
                this.vx = this.funx[i][j];
                this.vy = this.funy[i][j];
                magnitude = Math.hypot(this.vx, this.vy);
                if (magnitude < (double)this.minimumMagnitude) break;
                this.vx *= sign;
                this.vy *= sign;
                this.vx = (float)((double)this.vx / magnitude);
                this.vy = (float)((double)this.vy / magnitude);
                newX = x + this.vx;
                newY = y + this.vy;
                g.setColor(this.color != null ? this.color : this.getColor(magnitude));
                g.drawLine(Math.round(x), Math.round(y), Math.round(newX), Math.round(newY));
                if (k > 0 && k % (5 * this.arrowSpacing) == 0) {
                    FieldLines.drawArrow(g, x, y, x + arrowScale * this.vx, y + arrowScale * this.vy);
                }
                x = newX;
                y = newY;
                if (x < 0.0f || x >= (float)this.size.width || y < 0.0f || y >= (float)this.size.height) break;
                this.map[Math.round((float)x) / this.fluxLineSpacing][Math.round((float)y) / this.fluxLineSpacing] = true;
            }
            ++k;
        }
    }

    public void render(Graphics2D g, Dimension size, float[][] func, int arrowDirection) {
        this.func = func;
        this.nx = func.length;
        this.ny = func[0].length;
        this.size = size;
        this.arrowDirection = arrowDirection;
        this.dx = (float)size.width / (float)this.nx;
        this.dy = (float)size.height / (float)this.ny;
        int mx = size.width / this.fluxLineSpacing + 1;
        int my = size.height / this.fluxLineSpacing + 1;
        if (this.map == null || this.map.length != mx || this.map[0].length != my) {
            this.map = new boolean[mx][my];
        }
        int i = 0;
        while (i < this.map.length) {
            Arrays.fill(this.map[i], false);
            ++i;
        }
        int maxLength = Math.max(size.width, size.height);
        float x = 0.0f;
        float y = 0.0f;
        int i2 = 0;
        while (i2 < this.map.length) {
            int j = 0;
            while (j < this.map[0].length) {
                if (!this.map[i2][j]) {
                    x = ((float)i2 + 0.5f) * (float)this.fluxLineSpacing;
                    y = ((float)j + 0.5f) * (float)this.fluxLineSpacing;
                    this.drawFluxLineForScalar(g, x, y, 1.0f, maxLength);
                    this.drawFluxLineForScalar(g, x, y, -1.0f, maxLength);
                }
                ++j;
            }
            ++i2;
        }
    }

    private void drawFluxLineForScalar(Graphics2D g, float x, float y, float sign, int maxLength) {
        double magnitude = 0.0;
        float newX = 0.0f;
        float newY = 0.0f;
        float arrowScale = sign * this.arrowLength * (float)this.arrowDirection * (float)this.arrowSpacing;
        int k = 0;
        while (k < maxLength) {
            int i = Math.round(x / this.dx);
            int j = Math.round(y / this.dy);
            if (i > 0 && i < this.nx - 1 && j > 0 && j < this.ny - 1) {
                this.vx = (this.func[i + 1][j] - this.func[i - 1][j]) / 2.0f;
                this.vy = (this.func[i][j + 1] - this.func[i][j - 1]) / 2.0f;
                this.vx *= sign;
                this.vy *= sign;
                magnitude = Math.hypot(this.vx, this.vy);
                if (magnitude < (double)this.minimumMagnitude) break;
                this.vx = (float)((double)this.vx / magnitude);
                this.vy = (float)((double)this.vy / magnitude);
                newX = x + this.vx;
                newY = y + this.vy;
                g.setColor(this.color == null ? this.getColor(magnitude) : this.color);
                g.drawLine(Math.round(x), Math.round(y), Math.round(newX), Math.round(newY));
                if (k > 0 && k % (5 * this.arrowSpacing) == 0) {
                    FieldLines.drawArrow(g, x, y, x + arrowScale * this.vx, y + arrowScale * this.vy);
                }
                x = newX;
                y = newY;
                if (x < 0.0f || x >= (float)this.size.width || y < 0.0f || y >= (float)this.size.height) break;
                this.map[Math.round((float)x) / this.fluxLineSpacing][Math.round((float)y) / this.fluxLineSpacing] = true;
            }
            ++k;
        }
    }

    private Color getColor(double magnitude) {
        int colorIndex = (int)((Math.log10(magnitude) + 3.0) / 3.6 * (double)this.numColors);
        if (colorIndex < 0) {
            colorIndex = 0;
        } else if (colorIndex >= this.numColors) {
            colorIndex = this.numColors - 1;
        }
        return this.spectrum[colorIndex];
    }

    private static void drawArrow(Graphics2D g, float x1, float y1, float x2, float y2) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        float f = 0.33333334f;
        float f2 = 0.16666667f;
        float x3 = x2 - f * dx - f2 * dy;
        float y3 = y2 - f * dy + f2 * dx;
        float x4 = x2 - f * dx + f2 * dy;
        float y4 = y2 - f * dy - f2 * dx;
        g.drawLine(Math.round(x1), Math.round(y1), Math.round(x2), Math.round(y2));
        g.drawLine(Math.round(x3), Math.round(y3), Math.round(x2), Math.round(y2));
        g.drawLine(Math.round(x4), Math.round(y4), Math.round(x2), Math.round(y2));
    }
}

