/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import org.concord.energy2d.math.MathUtil;

public class ContourMap {
    private float resolution = 1.0f;
    private Color color = Color.black;
    private float[][] func;
    private int nx;
    private int ny;
    private Dimension size;
    private Point2D.Float pa = new Point2D.Float();
    private Point2D.Float pb = new Point2D.Float();
    private Line2D.Float line = new Line2D.Float();
    private int step = 1;

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setResolution(float resolution) {
        this.resolution = resolution;
    }

    public float getResolution() {
        return this.resolution;
    }

    public void render(Graphics2D g, Dimension size, float[][] func) {
        this.func = func;
        this.nx = func.length;
        this.ny = func[0].length;
        this.size = size;
        g.setColor(this.color);
        int x = 0;
        while (x < this.nx - this.step) {
            int y = 0;
            while (y < this.ny - this.step) {
                this.connect(g, x, y, x + this.step, y, x, y + this.step, x + this.step, y + this.step);
                this.connect(g, x, y, x + this.step, y, x, y, x, y + this.step);
                this.connect(g, x, y, x + this.step, y, x + this.step, y, x + this.step, y + this.step);
                this.connect(g, x, y, x, y + this.step, x + this.step, y, x + this.step, y + this.step);
                this.connect(g, x, y, x, y + this.step, x, y + this.step, x + this.step, y + this.step);
                this.connect(g, x + this.step, y, x + this.step, y + this.step, x, y + this.step, x + this.step, y + this.step);
                y += this.step;
            }
            x += this.step;
        }
    }

    private void connect(Graphics2D g, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        float fmax;
        int imax;
        float f1 = this.func[x1][y1];
        float f2 = this.func[x2][y2];
        float f3 = this.func[x3][y3];
        float f4 = this.func[x4][y4];
        float fmin = Math.min(Math.min(f1, f2), Math.min(f3, f4));
        int imin = (int)(fmin / this.resolution);
        if (imin != (imax = (int)((fmax = Math.max(Math.max(f1, f2), Math.max(f3, f4))) / this.resolution))) {
            int i = imin;
            while (i <= imax) {
                float v = (float)i * this.resolution;
                if (MathUtil.between(f1, f2, v) && MathUtil.between(f3, f4, v)) {
                    this.interpolate(f1, f2, x1, y1, x2, y2, v, this.pa);
                    this.interpolate(f3, f4, x3, y3, x4, y4, v, this.pb);
                    this.line.setLine(this.pa, this.pb);
                    g.draw(this.line);
                }
                ++i;
            }
        }
    }

    private void interpolate(float f1, float f2, int x1, int y1, int x2, int y2, float v, Point2D.Float p) {
        float r2 = (v - f1) / (f2 - f1);
        float r1 = 1.0f - r2;
        float h = 0.5f * (float)this.step;
        p.x = (((float)x1 + h) * r1 + ((float)x2 + h) * r2) * (float)this.size.width / (float)this.nx;
        p.y = (((float)y1 + h) * r1 + ((float)y2 + h) * r2) * (float)this.size.height / (float)this.ny;
    }
}

