/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemColor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import org.concord.energy2d.util.ColorRectangle;

public abstract class ComboBoxRenderer {

    public static class ColorCell
    extends ColorRectangle
    implements ListCellRenderer<Object> {
        public ColorCell() {
        }

        public ColorCell(Color moreColor) {
            this();
            if (!this.isDefaultColor(moreColor)) {
                this.setMoreColor(moreColor);
            }
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(isSelected ? SystemColor.textHighlight : Color.white);
            this.setForeground(isSelected ? SystemColor.textHighlightText : Color.black);
            this.setColorID((Integer)value);
            return this;
        }
    }

    public static class FontLabel
    extends JLabel
    implements ListCellRenderer<Object> {
        public FontLabel() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            String s = (String)value;
            this.setText(s);
            this.setFont(new Font(s, 0, 12));
            return this;
        }
    }

    public static class IconRenderer
    extends JRadioButton
    implements ListCellRenderer<Object> {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(isSelected ? SystemColor.textHighlight : Color.white);
            this.setForeground(isSelected ? SystemColor.textHighlightText : Color.black);
            this.setHorizontalAlignment(0);
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                if (value instanceof ImageIcon) {
                    this.setToolTipText(((ImageIcon)value).getDescription());
                }
            } else {
                this.setText(value == null ? "Unknown" : value.toString());
            }
            return this;
        }
    }
}

