/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.JComponent;
import org.concord.energy2d.util.ColorComboBox;

public class ColorRectangle
extends JComponent {
    public static final Color[] COLORS = new Color[]{Color.black, Color.gray, Color.blue, Color.red, Color.green, Color.magenta};
    private int colorID = 0;
    private Color moreColor = Color.white;

    ColorRectangle() {
        this.setPreferredSize(new Dimension(60, 20));
        this.setBackground(Color.white);
    }

    public ColorRectangle(int id, Color c) {
        this.setColorID(id);
        this.setMoreColor(c);
        this.setBackground(Color.white);
    }

    boolean isDefaultColor(Color c) {
        Color[] colorArray = COLORS;
        int n = COLORS.length;
        int n2 = 0;
        while (n2 < n) {
            Color x = colorArray[n2];
            if (x.equals(c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setMoreColor(Color c) {
        this.moreColor = c;
    }

    public void setMoreColor(int r, int g, int b) {
        this.moreColor = new Color(r, g, b);
    }

    public Color getMoreColor() {
        return this.moreColor;
    }

    public void setColorID(int id) {
        this.colorID = id;
        if (this.colorID < 0) {
            this.colorID = 0;
        }
    }

    public int getColorID() {
        return this.colorID;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.update(g);
    }

    @Override
    public void update(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, width, height);
        g.setColor(Color.gray);
        g.drawRect(3, 3, width - 6, height - 6);
        if (this.colorID < COLORS.length) {
            g.setColor(COLORS[this.colorID]);
            g.fillRect(4, 4, width - 7, height - 7);
        } else if (this.colorID == ColorComboBox.INDEX_MORE_COLOR) {
            g.setColor(this.moreColor);
            g.fillRect(4, 4, width - 7, height - 7);
        } else if (this.colorID == 100) {
            g.setColor(this.getBackground().equals(SystemColor.textHighlight) ? SystemColor.textHighlightText : SystemColor.textText);
            FontMetrics fm = g.getFontMetrics();
            String s = "More...";
            int w = fm.stringWidth(s);
            g.drawString(s, width - w >> 1, 14);
        } else if (this.colorID == 200) {
            g.setColor(this.getBackground().equals(SystemColor.textHighlight) ? SystemColor.textHighlightText : SystemColor.textText);
            FontMetrics fm = g.getFontMetrics();
            String s = "Hex...";
            int w = fm.stringWidth(s);
            g.drawString(s, width - w >> 1, 14);
        }
    }
}

