/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.concord.energy2d.util.ColorArrayEvent;
import org.concord.energy2d.util.ColorArrayListener;
import org.concord.energy2d.util.ColorArrayPane;
import org.concord.energy2d.util.ColorFill;
import org.concord.energy2d.util.MiscUtil;
import org.concord.energy2d.util.TextureChooser;

public class ColorMenu
extends JMenu {
    public static final String FILLING = "Filling";
    protected JColorChooser colorChooser;
    protected TextureChooser textureChooser;
    private Component parent;
    private JMenuItem noFillMenuItem;
    private JMenuItem moreColorMenuItem;
    private JMenuItem hexColorMenuItem;
    private JMenuItem textureMenuItem;
    private ColorArrayPane cap;

    public ColorMenu(Component parent, String name, JColorChooser color, TextureChooser texture) {
        super(name);
        this.parent = parent;
        this.colorChooser = color;
        this.textureChooser = texture;
        this.init();
    }

    public ColorMenu(Component parent, String name, boolean filled, JColorChooser color, TextureChooser texture) {
        super(name);
        this.parent = parent;
        this.colorChooser = color;
        this.textureChooser = texture;
        this.noFillMenuItem = new JCheckBoxMenuItem("No Fill", !filled);
        this.add(this.noFillMenuItem);
        this.addSeparator();
        this.init();
    }

    private void init() {
        this.cap = new ColorArrayPane();
        this.cap.addColorArrayListener(new ColorArrayListener(){

            @Override
            public void colorSelected(ColorArrayEvent e) {
                ColorMenu.this.doSelection();
                ColorMenu.this.firePropertyChange(ColorMenu.FILLING, null, new ColorFill(e.getSelectedColor()));
            }
        });
        this.add(this.cap);
        this.addSeparator();
        this.moreColorMenuItem = new JMenuItem("More Colors...");
        this.add(this.moreColorMenuItem);
        this.hexColorMenuItem = new JMenuItem("Hex Color...");
        this.add(this.hexColorMenuItem);
        if (this.textureChooser != null) {
            this.textureMenuItem = new JMenuItem("Texture...");
            this.add(this.textureMenuItem);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void setParent(Component parent) {
        this.parent = parent;
    }

    public void setColorChooser(JColorChooser cc) {
        this.colorChooser = cc;
    }

    public JColorChooser getColorChooser() {
        return this.colorChooser;
    }

    public void setTextureChooser(TextureChooser fec) {
        this.textureChooser = fec;
    }

    public TextureChooser getTextureChooser() {
        return this.textureChooser;
    }

    public void addNoFillListener(ActionListener a) {
        if (this.noFillMenuItem != null) {
            this.noFillMenuItem.addActionListener(a);
        }
    }

    public void removeNoFillListener(ActionListener a) {
        if (this.noFillMenuItem != null) {
            this.noFillMenuItem.removeActionListener(a);
        }
    }

    public void setNoFillAction(Action a) {
        if (this.noFillMenuItem != null) {
            this.noFillMenuItem.setAction(a);
        }
    }

    public void addColorArrayListener(ActionListener a) {
        this.addActionListener(a);
    }

    public void removeColorArrayListener(ActionListener a) {
        this.removeActionListener(a);
    }

    public void setColorArrayAction(Action a) {
        this.setAction(a);
    }

    public Color getHexInputColor(Color oldColor) {
        String hex;
        String s = oldColor != null ? Integer.toHexString(oldColor.getRGB() & 0xFFFFFF) : "";
        int m = 6 - s.length();
        if (m != 6 && m != 0) {
            int k = 0;
            while (k < m) {
                s = "0" + s;
                ++k;
            }
        }
        if ((hex = JOptionPane.showInputDialog(this.parent, "Input a hex color number:", s)) == null) {
            return null;
        }
        Color c = oldColor;
        try {
            c = MiscUtil.convertToColor(hex);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this.parent, e.getMessage(), "Error", 0);
        }
        return c;
    }

    public void addMoreColorListener(final ActionListener a) {
        this.moreColorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JColorChooser.createDialog(ColorMenu.this.parent, "Background Color", true, ColorMenu.this.colorChooser, a, null).setVisible(true);
            }
        });
    }

    public void addHexColorListener(ActionListener a) {
        this.hexColorMenuItem.addActionListener(a);
    }

    public void setMoreColorAction(final ActionListener a) {
        this.moreColorMenuItem.setAction(new AbstractAction("More Colors"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JColorChooser.createDialog(ColorMenu.this.parent, "Background Color", true, ColorMenu.this.colorChooser, a, null).setVisible(true);
            }
        });
    }

    public void addTextureListeners(final ActionListener ok, final ActionListener cancel) {
        if (this.textureMenuItem != null) {
            this.textureMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextureChooser.createDialog(ColorMenu.this.parent, "Texture", true, ColorMenu.this.textureChooser, ok, cancel).setVisible(true);
                }
            });
        }
    }

    public void setTextureActions(final ActionListener ok, final ActionListener cancel) {
        this.textureMenuItem.setAction(new AbstractAction("Texture"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextureChooser.createDialog(ColorMenu.this.parent, "Texture", true, ColorMenu.this.textureChooser, ok, cancel).setVisible(true);
            }
        });
    }

    public void setColor(Color c) {
        this.cap.setSelectedColor(c);
    }

    public Color getColor() {
        return this.cap.getSelectedColor();
    }

    public void doSelection() {
        this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
    }
}

