/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import org.concord.energy2d.util.ColorRectangle;
import org.concord.energy2d.util.ComboBoxRenderer;
import org.concord.energy2d.util.MiscUtil;

public class ColorComboBox
extends JComboBox<Integer> {
    public static final int INDEX_MORE_COLOR = ColorRectangle.COLORS.length;
    public static final int INDEX_COLOR_CHOOSER = 100;
    public static final int INDEX_HEX_INPUTTER = 200;
    private Color color6 = Color.white;
    private Color previousColor;
    private Runnable runnable;
    private static JColorChooser colorChooser;
    private Component parent;

    public ColorComboBox(Component parent0) {
        this.setParent(parent0);
        if (colorChooser == null) {
            colorChooser = new JColorChooser();
        }
        this.setRenderer(new ComboBoxRenderer.ColorCell());
        int i = 0;
        while (i <= INDEX_MORE_COLOR) {
            this.addItem(i);
            ++i;
        }
        this.addItem(100);
        this.addItem(200);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int id = (Integer)ColorComboBox.this.getSelectedItem();
                if (id == 100) {
                    JColorChooser.createDialog(ColorComboBox.this.parent, "More Colors", true, colorChooser, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            ColorComboBox.this.color6 = colorChooser.getColor();
                            ColorComboBox.this.setSelectedIndex(INDEX_MORE_COLOR);
                            ColorRectangle cr = (ColorRectangle)((Object)ColorComboBox.this.getRenderer());
                            cr.setMoreColor(ColorComboBox.this.color6);
                            if (ColorComboBox.this.runnable != null) {
                                EventQueue.invokeLater(ColorComboBox.this.runnable);
                            }
                        }
                    }, null).setVisible(true);
                } else if (id == 200) {
                    String hex;
                    String s = ColorComboBox.this.previousColor != null ? Integer.toHexString(ColorComboBox.this.previousColor.getRGB() & 0xFFFFFF) : "";
                    int m = 6 - s.length();
                    if (m != 6 && m != 0) {
                        int k = 0;
                        while (k < m) {
                            s = "0" + s;
                            ++k;
                        }
                    }
                    if ((hex = JOptionPane.showInputDialog(ColorComboBox.this.parent, "Input a hex color number:", s)) == null) {
                        return;
                    }
                    try {
                        ColorComboBox.this.color6 = MiscUtil.convertToColor(hex);
                    }
                    catch (NumberFormatException ex) {
                        JOptionPane.showMessageDialog(ColorComboBox.this.parent, "Input color (hex) is not valid.");
                        ColorComboBox.this.setSelectedIndex(INDEX_MORE_COLOR);
                        return;
                    }
                    ColorComboBox.this.setSelectedIndex(INDEX_MORE_COLOR);
                    ColorRectangle cr = (ColorRectangle)((Object)ColorComboBox.this.getRenderer());
                    cr.setMoreColor(ColorComboBox.this.color6);
                    if (ColorComboBox.this.runnable != null) {
                        EventQueue.invokeLater(ColorComboBox.this.runnable);
                    }
                }
                ColorComboBox.this.previousColor = ColorComboBox.this.getSelectedColor();
            }
        });
    }

    public void setParent(Component parent) {
        this.parent = parent;
    }

    public static void setColorChooser(JColorChooser cc) {
        colorChooser = cc;
    }

    public static JColorChooser getColorChooser() {
        return colorChooser;
    }

    public Color getMoreColor() {
        return this.color6;
    }

    public void updateColor(Runnable r) {
        this.runnable = r;
    }

    public void setColor(Color c) {
        if (c == null) {
            return;
        }
        boolean b = false;
        int i = 0;
        while (i < INDEX_MORE_COLOR) {
            if (c.equals(ColorRectangle.COLORS[i])) {
                this.setSelectedIndex(i);
                b = true;
            }
            ++i;
        }
        if (!b) {
            ((ColorRectangle)((Object)this.getRenderer())).setMoreColor(c);
            this.setSelectedIndex(INDEX_MORE_COLOR);
            this.color6 = c;
        }
    }

    public Color getSelectedColor() {
        int i = this.getSelectedIndex();
        if (i < INDEX_MORE_COLOR) {
            return ColorRectangle.COLORS[i];
        }
        return this.color6;
    }
}

