/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.MenuSelectionManager;
import org.concord.energy2d.util.ColorArrayEvent;
import org.concord.energy2d.util.ColorArrayListener;

public class ColorArrayPane
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final int[] VALUES;
    private static final Dimension CELL_SIZE;
    private static final int HGAP = 5;
    private static final int VGAP = 5;
    private static final int HMARGIN = 10;
    private static final int VMARGIN = 5;
    private static final List<Rectangle> RECT_LIST;
    private static final List<Color> COLOR_LIST;
    private static Rectangle selectedRectangle;
    private static Rectangle hoveredRectangle;
    private static int length;
    private List<ColorArrayListener> listenerList;

    static {
        int[] nArray = new int[4];
        nArray[1] = 128;
        nArray[2] = 192;
        nArray[3] = 255;
        VALUES = nArray;
        CELL_SIZE = new Dimension(12, 12);
        RECT_LIST = new ArrayList<Rectangle>();
        COLOR_LIST = new ArrayList<Color>();
    }

    private static void init() {
        if (!RECT_LIST.isEmpty()) {
            return;
        }
        int n = VALUES.length;
        int r = 0;
        while (r < n) {
            int g = 0;
            while (g < n) {
                int b = 0;
                while (b < n) {
                    COLOR_LIST.add(new Color(VALUES[r] << 16 | VALUES[g] << 8 | VALUES[b]));
                    ++b;
                }
                ++g;
            }
            ++r;
        }
        length = (int)Math.sqrt(n * n * n);
        int i = 0;
        while (i < length) {
            int j = 0;
            while (j < length) {
                RECT_LIST.add(new Rectangle(10 + i * (ColorArrayPane.CELL_SIZE.width + 5), 5 + j * (ColorArrayPane.CELL_SIZE.height + 5), ColorArrayPane.CELL_SIZE.width, ColorArrayPane.CELL_SIZE.height));
                ++j;
            }
            ++i;
        }
    }

    public ColorArrayPane() {
        ColorArrayPane.init();
        this.setPreferredSize(new Dimension(length * (ColorArrayPane.CELL_SIZE.width + 5) - 5 + 20, length * (ColorArrayPane.CELL_SIZE.height + 5) - 5 + 10));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public JDialog createDialog(Component parent, String title, final JColorChooser colorChooser, final ActionListener a) {
        final JDialog d = new JDialog(JOptionPane.getFrameForComponent(parent), title, true);
        d.setDefaultCloseOperation(2);
        d.getContentPane().add((Component)this, "Center");
        JPanel p = new JPanel(new FlowLayout(2, 5, 5));
        d.getContentPane().add((Component)p, "South");
        JButton b = new JButton("More");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JColorChooser.createDialog(d, "More Colors", true, colorChooser, a, null).setVisible(true);
            }
        });
        p.add(b);
        b = new JButton("Close");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                d.dispose();
            }
        });
        p.add(b);
        d.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                d.dispose();
            }
        });
        d.pack();
        d.setLocationRelativeTo(parent);
        return d;
    }

    public void addColorArrayListener(ColorArrayListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listenerList == null) {
            this.listenerList = new ArrayList<ColorArrayListener>();
        }
        this.listenerList.add(listener);
    }

    public void removeColorArrayListener(ColorArrayListener listener) {
        if (listener == null) {
            return;
        }
        this.listenerList.remove(listener);
    }

    protected void notifyColorArrayListeners(ColorArrayEvent e) {
        if (this.listenerList == null || this.listenerList.isEmpty()) {
            return;
        }
        for (ColorArrayListener l : this.listenerList) {
            l.colorSelected(e);
        }
    }

    public void setSelectedColor(Color c) {
        selectedRectangle = null;
        for (Color x : COLOR_LIST) {
            if (!c.equals(x)) continue;
            selectedRectangle = RECT_LIST.get(COLOR_LIST.indexOf(x));
            break;
        }
    }

    public Color getSelectedColor() {
        if (selectedRectangle == null) {
            return null;
        }
        int i = 0;
        int n = RECT_LIST.size();
        while (i < n) {
            if (selectedRectangle == RECT_LIST.get(i)) {
                return COLOR_LIST.get(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.update(g);
    }

    @Override
    public void update(Graphics g) {
        int i = 0;
        int n = RECT_LIST.size();
        while (i < n) {
            Color color = COLOR_LIST.get(i);
            g.setColor(color);
            Rectangle rect = RECT_LIST.get(i);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            g.setColor(rect == hoveredRectangle ? Color.white : Color.black);
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
            if (rect == selectedRectangle) {
                g.setColor(Color.black);
                g.drawRect(rect.x - 2, rect.y - 2, rect.width + 4, rect.height + 4);
            }
            ++i;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int n;
        int m = (e.getX() - 10) / (5 + ColorArrayPane.CELL_SIZE.width);
        int k = m * length + (n = (e.getY() - 5) / (5 + ColorArrayPane.CELL_SIZE.height));
        if (k < 0 || k >= RECT_LIST.size()) {
            return;
        }
        selectedRectangle = RECT_LIST.get(k);
        MenuSelectionManager.defaultManager().clearSelectedPath();
        this.notifyColorArrayListeners(new ColorArrayEvent(this, COLOR_LIST.get(k)));
        hoveredRectangle = null;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        hoveredRectangle = null;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int n;
        int m = (e.getX() - 10) / (5 + ColorArrayPane.CELL_SIZE.width);
        int k = m * length + (n = (e.getY() - 5) / (5 + ColorArrayPane.CELL_SIZE.height));
        if (k < 0 || k >= RECT_LIST.size()) {
            return;
        }
        hoveredRectangle = RECT_LIST.get(k);
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }
}

