/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicBorders;
import org.concord.energy2d.util.ColorFill;
import org.concord.energy2d.util.ColorMenu;
import org.concord.energy2d.util.FillPattern;
import org.concord.energy2d.util.Texture;
import org.concord.energy2d.util.TextureChooser;

public class BackgroundComboBox
extends JComponent
implements FocusListener,
PropertyChangeListener {
    private SelectionPanel selectionPanel;
    private JButton popButton;
    private ColorMenu colorMenu;

    public BackgroundComboBox(Component parent, boolean filled, JColorChooser colorChooser, TextureChooser textureChooser) {
        this(parent, new ColorMenu(parent, "Background", filled, colorChooser, textureChooser));
    }

    public BackgroundComboBox(Component parent, JColorChooser colorChooser, TextureChooser textureChooser) {
        this(parent, new ColorMenu(parent, "Background", colorChooser, textureChooser));
    }

    private BackgroundComboBox(Component parent, final ColorMenu colorMenu) {
        this.setLayout(new BorderLayout());
        this.setBorder(new BasicBorders.ButtonBorder(Color.lightGray, Color.white, Color.black, Color.gray));
        colorMenu.addPropertyChangeListener(this);
        this.colorMenu = colorMenu;
        this.selectionPanel = new SelectionPanel();
        this.selectionPanel.setPreferredSize(new Dimension(80, 18));
        this.selectionPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (BackgroundComboBox.this.selectionPanel.isEnabled()) {
                    colorMenu.getPopupMenu().show(BackgroundComboBox.this.selectionPanel, 0, BackgroundComboBox.this.selectionPanel.getHeight());
                }
            }
        });
        this.add((Component)this.selectionPanel, "Center");
        this.popButton = new JButton(new DownTriangleIcon());
        this.popButton.setBorder(new BasicBorders.ButtonBorder(Color.gray, Color.black, Color.white, Color.lightGray));
        this.popButton.setPreferredSize(new Dimension(20, 18));
        this.popButton.setFocusPainted(false);
        this.popButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                colorMenu.getPopupMenu().show(BackgroundComboBox.this.selectionPanel, 0, BackgroundComboBox.this.selectionPanel.getHeight());
            }
        });
        this.add((Component)this.popButton, "East");
        this.selectionPanel.addFocusListener(this);
        this.popButton.addFocusListener(this);
    }

    public void setParent(Component parent) {
        this.colorMenu.setParent(parent);
    }

    public ColorMenu getColorMenu() {
        return this.colorMenu;
    }

    public void setFillPattern(FillPattern fp) {
        this.selectionPanel.setFillPattern(fp);
    }

    public FillPattern getFillPattern() {
        return this.selectionPanel.getFillPattern();
    }

    @Override
    public void setEnabled(boolean b) {
        this.selectionPanel.setEnabled(b);
        this.popButton.setEnabled(b);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.selectionPanel.setBorder(new LineBorder(this.selectionPanel.unselectedColor, 2));
        this.selectionPanel.repaint();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.selectionPanel.setBorder(new LineBorder(this.selectionPanel.selectedColor, 2));
        this.selectionPanel.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("Filling")) {
            Object obj = e.getNewValue();
            if (obj instanceof ColorFill) {
                this.selectionPanel.setFillPattern((ColorFill)obj);
            } else if (obj instanceof Texture) {
                this.selectionPanel.setFillPattern((Texture)obj);
            }
            this.selectionPanel.repaint();
        }
    }

    private class DownTriangleIcon
    implements Icon {
        private DownTriangleIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            Polygon triangle = new Polygon();
            triangle.addPoint(x, y);
            triangle.addPoint(x + w, y);
            triangle.addPoint(x + w / 2, y + h);
            g.setColor(BackgroundComboBox.this.popButton.isEnabled() ? SystemColor.textText : SystemColor.textInactiveText);
            g.fillPolygon(triangle);
        }

        @Override
        public int getIconWidth() {
            return 6;
        }

        @Override
        public int getIconHeight() {
            return 4;
        }
    }

    protected class SelectionPanel
    extends JComponent {
        private Color selectedColor = Color.black;
        private Color unselectedColor = Color.white;
        private FillPattern fillPattern;

        public SelectionPanel() {
            this.setBorder(new LineBorder(this.unselectedColor, 2));
        }

        public boolean getLockRatio() {
            return false;
        }

        public void setFillPattern(FillPattern fp) {
            this.fillPattern = fp;
        }

        public FillPattern getFillPattern() {
            return this.fillPattern;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.fillPattern instanceof Texture) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setPaint(((Texture)this.fillPattern).getPaint());
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else if (this.fillPattern instanceof ColorFill) {
                g.setColor(((ColorFill)this.fillPattern).getColor());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
    }
}

