/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.concord.energy2d.view.View2D;

public class UndoViewFactorLines
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private boolean oldValue;
    private boolean newValue;
    private View2D view;

    public UndoViewFactorLines(View2D view) {
        this.oldValue = view.isViewFactorLinesOn();
        this.view = view;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.newValue = this.view.isViewFactorLinesOn();
        this.view.setViewFactorLinesOn(this.oldValue);
        this.view.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.view.setViewFactorLinesOn(this.newValue);
        this.view.repaint();
    }

    @Override
    public String getPresentationName() {
        return "View Factor Lines";
    }
}

