/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.undo;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.concord.energy2d.math.Blob2D;
import org.concord.energy2d.math.Polygon2D;
import org.concord.energy2d.math.Ring2D;
import org.concord.energy2d.model.Anemometer;
import org.concord.energy2d.model.Cloud;
import org.concord.energy2d.model.Fan;
import org.concord.energy2d.model.HeatFluxSensor;
import org.concord.energy2d.model.Heliostat;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.model.Model2D;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.model.Particle;
import org.concord.energy2d.model.ParticleFeeder;
import org.concord.energy2d.model.Thermometer;
import org.concord.energy2d.model.Tree;
import org.concord.energy2d.view.TextBox;
import org.concord.energy2d.view.View2D;

public class UndoTranslateManipulable
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private Manipulable selectedManipulable;
    private View2D view;
    private Model2D model;
    private String name;
    private float oldX;
    private float oldY;
    private float newX;
    private float newY;

    public UndoTranslateManipulable(View2D view) {
        this.view = view;
        this.model = view.getModel();
        this.selectedManipulable = view.getSelectedManipulable();
        if (this.selectedManipulable instanceof Part) {
            this.name = "Part";
            this.saveShape();
        } else if (this.selectedManipulable instanceof Particle) {
            this.name = "Particle";
            Particle particle = (Particle)this.selectedManipulable;
            this.oldX = particle.getRx();
            this.oldY = particle.getRy();
        } else if (this.selectedManipulable instanceof ParticleFeeder) {
            this.name = "Particle Feeder";
            ParticleFeeder particleFeeder = (ParticleFeeder)this.selectedManipulable;
            this.oldX = particleFeeder.getX();
            this.oldY = particleFeeder.getY();
        } else if (this.selectedManipulable instanceof Fan) {
            this.name = "Fan";
            this.saveShape();
        } else if (this.selectedManipulable instanceof Heliostat) {
            this.name = "Heliostat";
            this.saveShape();
        } else if (this.selectedManipulable instanceof Thermometer) {
            this.name = "Thermometer";
            Thermometer thermometer = (Thermometer)this.selectedManipulable;
            this.oldX = thermometer.getX();
            this.oldY = thermometer.getY();
        } else if (this.selectedManipulable instanceof HeatFluxSensor) {
            this.name = "Heat Flux Sensor";
            HeatFluxSensor heatFluxSensor = (HeatFluxSensor)this.selectedManipulable;
            this.oldX = heatFluxSensor.getX();
            this.oldY = heatFluxSensor.getY();
        } else if (this.selectedManipulable instanceof Anemometer) {
            this.name = "Anemometer";
            Anemometer anemometer = (Anemometer)this.selectedManipulable;
            this.oldX = anemometer.getX();
            this.oldY = anemometer.getY();
        } else if (this.selectedManipulable instanceof Cloud) {
            this.name = "Cloud";
            Cloud cloud = (Cloud)this.selectedManipulable;
            this.oldX = cloud.getX();
            this.oldY = cloud.getY();
        } else if (this.selectedManipulable instanceof Tree) {
            this.name = "Tree";
            Tree tree = (Tree)this.selectedManipulable;
            this.oldX = tree.getX();
            this.oldY = tree.getY();
        } else if (this.selectedManipulable instanceof TextBox) {
            this.name = "Text Box";
            TextBox textBox = (TextBox)this.selectedManipulable;
            this.oldX = textBox.getX();
            this.oldY = textBox.getY();
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        if (this.selectedManipulable instanceof Part) {
            this.undoShape();
            this.model.refreshPowerArray();
            this.model.refreshTemperatureBoundaryArray();
            this.model.refreshMaterialPropertyArrays();
            this.model.refreshHeliostatsAimedAt((Part)this.selectedManipulable);
            if (this.view.isViewFactorLinesOn()) {
                this.model.generateViewFactorMesh();
            }
        } else if (this.selectedManipulable instanceof Particle) {
            Particle particle = (Particle)this.selectedManipulable;
            this.newX = particle.getRx();
            this.newY = particle.getRy();
            particle.setRx(this.oldX);
            particle.setRy(this.oldY);
            this.model.attachSensors();
        } else if (this.selectedManipulable instanceof ParticleFeeder) {
            ParticleFeeder particleFeeder = (ParticleFeeder)this.selectedManipulable;
            this.newX = particleFeeder.getX();
            this.newY = particleFeeder.getY();
            particleFeeder.setX(this.oldX);
            particleFeeder.setY(this.oldY);
        } else if (this.selectedManipulable instanceof Fan) {
            this.undoShape();
            this.model.refreshMaterialPropertyArrays();
        } else if (this.selectedManipulable instanceof Heliostat) {
            this.undoShape();
            ((Heliostat)this.selectedManipulable).setAngle();
        } else if (this.selectedManipulable instanceof Thermometer) {
            Thermometer thermometer = (Thermometer)this.selectedManipulable;
            this.newX = thermometer.getX();
            this.newY = thermometer.getY();
            thermometer.setX(this.oldX);
            thermometer.setY(this.oldY);
        } else if (this.selectedManipulable instanceof HeatFluxSensor) {
            HeatFluxSensor heatFluxSensor = (HeatFluxSensor)this.selectedManipulable;
            this.newX = heatFluxSensor.getX();
            this.newY = heatFluxSensor.getY();
            heatFluxSensor.setX(this.oldX);
            heatFluxSensor.setY(this.oldY);
        } else if (this.selectedManipulable instanceof Anemometer) {
            Anemometer anemometer = (Anemometer)this.selectedManipulable;
            this.newX = anemometer.getX();
            this.newY = anemometer.getY();
            anemometer.setX(this.oldX);
            anemometer.setY(this.oldY);
        } else if (this.selectedManipulable instanceof Cloud) {
            Cloud cloud = (Cloud)this.selectedManipulable;
            this.newX = cloud.getX();
            this.newY = cloud.getY();
            cloud.setX(this.oldX);
            cloud.setY(this.oldY);
        } else if (this.selectedManipulable instanceof Tree) {
            Tree tree = (Tree)this.selectedManipulable;
            this.newX = tree.getX();
            this.newY = tree.getY();
            tree.setX(this.oldX);
            tree.setY(this.oldY);
        } else if (this.selectedManipulable instanceof TextBox) {
            TextBox textBox = (TextBox)this.selectedManipulable;
            this.newX = textBox.getX();
            this.newY = textBox.getY();
            textBox.setX(this.oldX);
            textBox.setY(this.oldY);
        }
        this.view.setSelectedManipulable(this.selectedManipulable);
        this.view.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this.selectedManipulable instanceof Part) {
            this.redoShape();
            this.model.refreshPowerArray();
            this.model.refreshTemperatureBoundaryArray();
            this.model.refreshMaterialPropertyArrays();
            this.model.refreshHeliostatsAimedAt((Part)this.selectedManipulable);
            if (this.view.isViewFactorLinesOn()) {
                this.model.generateViewFactorMesh();
            }
        } else if (this.selectedManipulable instanceof Particle) {
            Particle particle = (Particle)this.selectedManipulable;
            particle.setRx(this.newX);
            particle.setRy(this.newY);
            this.model.attachSensors();
        } else if (this.selectedManipulable instanceof ParticleFeeder) {
            ParticleFeeder particleFeeder = (ParticleFeeder)this.selectedManipulable;
            particleFeeder.setX(this.newX);
            particleFeeder.setY(this.newY);
        } else if (this.selectedManipulable instanceof Fan) {
            this.redoShape();
            this.model.refreshMaterialPropertyArrays();
        } else if (this.selectedManipulable instanceof Heliostat) {
            this.redoShape();
            ((Heliostat)this.selectedManipulable).setAngle();
        } else if (this.selectedManipulable instanceof Thermometer) {
            Thermometer thermometer = (Thermometer)this.selectedManipulable;
            thermometer.setX(this.newX);
            thermometer.setY(this.newY);
        } else if (this.selectedManipulable instanceof HeatFluxSensor) {
            HeatFluxSensor heatFluxSensor = (HeatFluxSensor)this.selectedManipulable;
            heatFluxSensor.setX(this.newX);
            heatFluxSensor.setY(this.newY);
        } else if (this.selectedManipulable instanceof Anemometer) {
            Anemometer anemometer = (Anemometer)this.selectedManipulable;
            anemometer.setX(this.newX);
            anemometer.setY(this.newY);
        } else if (this.selectedManipulable instanceof Cloud) {
            Cloud cloud = (Cloud)this.selectedManipulable;
            cloud.setX(this.newX);
            cloud.setY(this.newY);
        } else if (this.selectedManipulable instanceof Tree) {
            Tree tree = (Tree)this.selectedManipulable;
            tree.setX(this.newX);
            tree.setY(this.newY);
        } else if (this.selectedManipulable instanceof TextBox) {
            TextBox textBox = (TextBox)this.selectedManipulable;
            textBox.setX(this.newX);
            textBox.setY(this.newY);
        }
        this.view.setSelectedManipulable(this.selectedManipulable);
        this.view.repaint();
    }

    private void saveShape() {
        Shape shape = this.selectedManipulable.getShape();
        if (shape instanceof Rectangle2D.Float) {
            Rectangle2D.Float rect = (Rectangle2D.Float)shape;
            this.oldX = rect.x;
            this.oldY = rect.y;
        } else if (shape instanceof Ellipse2D.Float) {
            Ellipse2D.Float elli = (Ellipse2D.Float)shape;
            this.oldX = elli.x;
            this.oldY = elli.y;
        } else if (shape instanceof Polygon2D) {
            Polygon2D poly = (Polygon2D)shape;
            Point2D.Float center = poly.getCenter();
            this.oldX = center.x;
            this.oldY = center.y;
        } else if (shape instanceof Blob2D) {
            Blob2D blob = (Blob2D)shape;
            Point2D.Float center = blob.getCenter();
            this.oldX = center.x;
            this.oldY = center.y;
        } else if (shape instanceof Ring2D) {
            Ring2D ring = (Ring2D)shape;
            this.oldX = ring.getX();
            this.oldY = ring.getY();
        }
    }

    private void undoShape() {
        Shape shape = this.selectedManipulable.getShape();
        if (shape instanceof Rectangle2D.Float) {
            Rectangle2D.Float rect = (Rectangle2D.Float)shape;
            this.newX = rect.x;
            this.newY = rect.y;
            rect.x = this.oldX;
            rect.y = this.oldY;
        } else if (shape instanceof Ellipse2D.Float) {
            Ellipse2D.Float elli = (Ellipse2D.Float)shape;
            this.newX = elli.x;
            this.newY = elli.y;
            elli.x = this.oldX;
            elli.y = this.oldY;
        } else if (shape instanceof Polygon2D) {
            Polygon2D poly = (Polygon2D)shape;
            Point2D.Float center = poly.getCenter();
            this.newX = center.x;
            this.newY = center.y;
            poly.translateCenterTo(this.oldX, this.oldY);
        } else if (shape instanceof Blob2D) {
            Blob2D blob = (Blob2D)shape;
            Point2D.Float center = blob.getCenter();
            this.newX = center.x;
            this.newY = center.y;
            blob.translateCenterTo(this.oldX, this.oldY);
            blob.update();
        } else if (shape instanceof Ring2D) {
            Ring2D ring = (Ring2D)shape;
            this.newX = ring.getX();
            this.newY = ring.getY();
            ring.translateTo(this.oldX, this.oldY);
        }
    }

    private void redoShape() {
        Shape shape = this.selectedManipulable.getShape();
        if (shape instanceof Rectangle2D.Float) {
            Rectangle2D.Float rect = (Rectangle2D.Float)shape;
            rect.x = this.newX;
            rect.y = this.newY;
        } else if (shape instanceof Ellipse2D.Float) {
            Ellipse2D.Float elli = (Ellipse2D.Float)shape;
            elli.x = this.newX;
            elli.y = this.newY;
        } else if (shape instanceof Polygon2D) {
            Polygon2D poly = (Polygon2D)shape;
            poly.translateCenterTo(this.newX, this.newY);
        } else if (shape instanceof Blob2D) {
            Blob2D blob = (Blob2D)shape;
            blob.translateCenterTo(this.newX, this.newY);
            blob.update();
        } else if (shape instanceof Ring2D) {
            Ring2D ring = (Ring2D)shape;
            ring.translateTo(this.newX, this.newY);
        }
    }

    @Override
    public String getPresentationName() {
        return "Move " + (this.name == null ? "Manipulable" : this.name);
    }
}

