/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.undo;

import java.awt.Shape;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.concord.energy2d.math.Blob2D;
import org.concord.energy2d.math.TransformableShape;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.model.Model2D;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.view.View2D;

public class UndoScaleManipulable
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private Manipulable selectedManipulable;
    private View2D view;
    private Model2D model;
    private String name;
    private float scaleFactor;
    private int scaleDirection;

    public UndoScaleManipulable(View2D view, float scaleFactor, int scaleDirection) {
        this.view = view;
        this.scaleFactor = scaleFactor;
        this.scaleDirection = scaleDirection;
        this.model = view.getModel();
        this.selectedManipulable = view.getSelectedManipulable();
        if (this.selectedManipulable instanceof Part) {
            this.name = "Part";
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        Shape shape;
        super.undo();
        if (this.selectedManipulable instanceof Part && (shape = this.selectedManipulable.getShape()) instanceof TransformableShape) {
            TransformableShape s = (TransformableShape)shape;
            switch (this.scaleDirection) {
                case 0: {
                    s.scaleX(1.0f / this.scaleFactor);
                    break;
                }
                case 1: {
                    s.scaleY(1.0f / this.scaleFactor);
                    break;
                }
                case 2: {
                    s.scale(1.0f / this.scaleFactor);
                }
            }
            if (s instanceof Blob2D) {
                ((Blob2D)s).update();
            }
            this.model.refreshPowerArray();
            this.model.refreshTemperatureBoundaryArray();
            this.model.refreshMaterialPropertyArrays();
            if (this.view.isViewFactorLinesOn()) {
                this.model.generateViewFactorMesh();
            }
        }
        this.view.setSelectedManipulable(this.selectedManipulable);
        this.view.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        Shape shape;
        super.redo();
        if (this.selectedManipulable instanceof Part && (shape = this.selectedManipulable.getShape()) instanceof TransformableShape) {
            TransformableShape s = (TransformableShape)shape;
            switch (this.scaleDirection) {
                case 0: {
                    s.scaleX(this.scaleFactor);
                    break;
                }
                case 1: {
                    s.scaleY(this.scaleFactor);
                    break;
                }
                case 2: {
                    s.scale(this.scaleFactor);
                }
            }
            if (s instanceof Blob2D) {
                ((Blob2D)s).update();
            }
            this.model.refreshPowerArray();
            this.model.refreshTemperatureBoundaryArray();
            this.model.refreshMaterialPropertyArrays();
            if (this.view.isViewFactorLinesOn()) {
                this.model.generateViewFactorMesh();
            }
        }
        this.view.setSelectedManipulable(this.selectedManipulable);
        this.view.repaint();
    }

    @Override
    public String getPresentationName() {
        return "Scale " + (this.name == null ? "Manipulable" : this.name);
    }
}

