/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.concord.energy2d.view.View2D;

public class UndoScaleAll
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private float scaleFactor = 1.0f;
    private View2D view;

    public UndoScaleAll(View2D view, float scaleFactor) {
        this.scaleFactor = scaleFactor;
        this.view = view;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.view.scaleAll(1.0f / this.scaleFactor);
        this.view.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.view.scaleAll(this.scaleFactor);
        this.view.repaint();
    }

    @Override
    public String getPresentationName() {
        return "Scale All";
    }
}

