/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.undo;

import java.awt.Shape;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.concord.energy2d.math.Blob2D;
import org.concord.energy2d.math.TransformableShape;
import org.concord.energy2d.model.Fan;
import org.concord.energy2d.model.HeatFluxSensor;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.model.Model2D;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.model.Particle;
import org.concord.energy2d.view.View2D;

public class UndoRotateManipulable
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private Manipulable selectedManipulable;
    private View2D view;
    private Model2D model;
    private String name;
    private float rotationAngle;
    private float oldAngle;
    private float newAngle;

    public UndoRotateManipulable(View2D view, float rotationAngle) {
        this.view = view;
        this.rotationAngle = rotationAngle;
        this.model = view.getModel();
        this.selectedManipulable = view.getSelectedManipulable();
        if (this.selectedManipulable instanceof Part) {
            this.name = "Part";
        } else if (this.selectedManipulable instanceof Particle) {
            this.name = "Particle";
        } else if (this.selectedManipulable instanceof Fan) {
            this.name = "Fan";
        } else if (this.selectedManipulable instanceof HeatFluxSensor) {
            this.name = "Heat Flux Sensor";
            HeatFluxSensor heatFluxSensor = (HeatFluxSensor)this.selectedManipulable;
            this.oldAngle = heatFluxSensor.getAngle();
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        if (this.selectedManipulable instanceof Part) {
            Shape shape = this.selectedManipulable.getShape();
            if (shape instanceof TransformableShape) {
                TransformableShape s = (TransformableShape)shape;
                s.rotateBy(-this.rotationAngle);
                if (s instanceof Blob2D) {
                    ((Blob2D)s).update();
                }
                this.model.refreshPowerArray();
                this.model.refreshTemperatureBoundaryArray();
                this.model.refreshMaterialPropertyArrays();
                if (this.view.isViewFactorLinesOn()) {
                    this.model.generateViewFactorMesh();
                }
            }
        } else if (!(this.selectedManipulable instanceof Particle) && !(this.selectedManipulable instanceof Fan) && this.selectedManipulable instanceof HeatFluxSensor) {
            HeatFluxSensor heatFluxSensor = (HeatFluxSensor)this.selectedManipulable;
            this.newAngle = heatFluxSensor.getAngle();
            heatFluxSensor.setAngle(this.oldAngle);
        }
        this.view.setSelectedManipulable(this.selectedManipulable);
        this.view.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this.selectedManipulable instanceof Part) {
            Shape shape = this.selectedManipulable.getShape();
            if (shape instanceof TransformableShape) {
                TransformableShape s = (TransformableShape)shape;
                s.rotateBy(this.rotationAngle);
                if (s instanceof Blob2D) {
                    ((Blob2D)s).update();
                }
                this.model.refreshPowerArray();
                this.model.refreshTemperatureBoundaryArray();
                this.model.refreshMaterialPropertyArrays();
                if (this.view.isViewFactorLinesOn()) {
                    this.model.generateViewFactorMesh();
                }
            }
        } else if (!(this.selectedManipulable instanceof Particle) && !(this.selectedManipulable instanceof Fan) && this.selectedManipulable instanceof HeatFluxSensor) {
            HeatFluxSensor heatFluxSensor = (HeatFluxSensor)this.selectedManipulable;
            heatFluxSensor.setAngle(this.newAngle);
        }
        this.view.setSelectedManipulable(this.selectedManipulable);
        this.view.repaint();
    }

    @Override
    public String getPresentationName() {
        return "Rotate " + (this.name == null ? "Manipulable" : this.name);
    }
}

