/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.undo;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.concord.energy2d.math.Blob2D;
import org.concord.energy2d.math.Polygon2D;
import org.concord.energy2d.math.Ring2D;
import org.concord.energy2d.model.Cloud;
import org.concord.energy2d.model.Fan;
import org.concord.energy2d.model.Heliostat;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.model.Model2D;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.model.Particle;
import org.concord.energy2d.model.Tree;
import org.concord.energy2d.view.View2D;

public class UndoResizeManipulable
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private Manipulable selectedManipulable;
    private View2D view;
    private Model2D model;
    private String name;
    private float oldX;
    private float oldY;
    private float newX;
    private float newY;
    private float oldW;
    private float oldH;
    private float newW;
    private float newH;

    public UndoResizeManipulable(View2D view) {
        this.view = view;
        this.model = view.getModel();
        this.selectedManipulable = view.getSelectedManipulable();
        if (this.selectedManipulable instanceof Part) {
            this.name = "Part";
            Shape shape = this.selectedManipulable.getShape();
            if (shape instanceof Rectangle2D.Float) {
                Rectangle2D.Float rect = (Rectangle2D.Float)shape;
                this.oldX = rect.x;
                this.oldY = rect.y;
                this.oldW = rect.width;
                this.oldH = rect.height;
            } else if (shape instanceof Ellipse2D.Float) {
                Ellipse2D.Float elli = (Ellipse2D.Float)shape;
                this.oldX = elli.x;
                this.oldY = elli.y;
                this.oldW = elli.width;
                this.oldH = elli.height;
            } else if (!(shape instanceof Polygon2D) && !(shape instanceof Blob2D)) {
                boolean cfr_ignored_0 = shape instanceof Ring2D;
            }
        } else if (this.selectedManipulable instanceof Fan) {
            this.name = "Fan";
            Shape shape = this.selectedManipulable.getShape();
            Rectangle2D.Float rect = (Rectangle2D.Float)shape;
            this.oldX = rect.x;
            this.oldY = rect.y;
            this.oldW = rect.width;
            this.oldH = rect.height;
        } else if (this.selectedManipulable instanceof Heliostat) {
            this.name = "Heliostat";
            Shape shape = this.selectedManipulable.getShape();
            Rectangle2D.Float rect = (Rectangle2D.Float)shape;
            this.oldX = rect.x;
            this.oldY = rect.y;
            this.oldW = rect.width;
            this.oldH = rect.height;
        } else if (this.selectedManipulable instanceof Cloud) {
            this.name = "Cloud";
            Cloud cloud = (Cloud)this.selectedManipulable;
            this.oldX = cloud.getX();
            this.oldY = cloud.getY();
            this.oldW = cloud.getWidth();
            this.oldH = cloud.getHeight();
        } else if (this.selectedManipulable instanceof Tree) {
            this.name = "Tree";
            Tree tree = (Tree)this.selectedManipulable;
            this.oldX = tree.getX();
            this.oldY = tree.getY();
            this.oldW = tree.getWidth();
            this.oldH = tree.getHeight();
        } else if (this.selectedManipulable instanceof Particle) {
            this.name = "Particle";
            Particle particle = (Particle)this.selectedManipulable;
            this.oldW = particle.getRadius();
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        if (this.selectedManipulable instanceof Part) {
            Shape shape = this.selectedManipulable.getShape();
            if (shape instanceof Rectangle2D.Float) {
                Rectangle2D.Float rect = (Rectangle2D.Float)shape;
                this.newX = rect.x;
                this.newY = rect.y;
                this.newW = rect.width;
                this.newH = rect.height;
                rect.x = this.oldX;
                rect.y = this.oldY;
                rect.width = this.oldW;
                rect.height = this.oldH;
            } else if (shape instanceof Ellipse2D.Float) {
                Ellipse2D.Float elli = (Ellipse2D.Float)shape;
                this.newX = elli.x;
                this.newY = elli.y;
                this.newW = elli.width;
                this.newH = elli.height;
                elli.x = this.oldX;
                elli.y = this.oldY;
                elli.width = this.oldW;
                elli.height = this.oldH;
            } else if (!(shape instanceof Polygon2D) && !(shape instanceof Blob2D)) {
                boolean cfr_ignored_0 = shape instanceof Ring2D;
            }
            this.model.refreshPowerArray();
            this.model.refreshTemperatureBoundaryArray();
            this.model.refreshMaterialPropertyArrays();
            this.model.refreshHeliostatsAimedAt((Part)this.selectedManipulable);
            if (this.view.isViewFactorLinesOn()) {
                this.model.generateViewFactorMesh();
            }
        } else if (this.selectedManipulable instanceof Fan) {
            Shape shape = this.selectedManipulable.getShape();
            Rectangle2D.Float rect = (Rectangle2D.Float)shape;
            this.newX = rect.x;
            this.newY = rect.y;
            this.newW = rect.width;
            this.newH = rect.height;
            rect.x = this.oldX;
            rect.y = this.oldY;
            rect.width = this.oldW;
            rect.height = this.oldH;
            this.model.refreshMaterialPropertyArrays();
        } else if (this.selectedManipulable instanceof Heliostat) {
            Shape shape = this.selectedManipulable.getShape();
            Rectangle2D.Float rect = (Rectangle2D.Float)shape;
            this.newX = rect.x;
            this.newY = rect.y;
            this.newW = rect.width;
            this.newH = rect.height;
            rect.x = this.oldX;
            rect.y = this.oldY;
            rect.width = this.oldW;
            rect.height = this.oldH;
            ((Heliostat)this.selectedManipulable).setAngle();
        } else if (this.selectedManipulable instanceof Cloud) {
            Cloud cloud = (Cloud)this.selectedManipulable;
            this.newX = cloud.getX();
            this.newY = cloud.getY();
            this.newW = cloud.getWidth();
            this.newH = cloud.getHeight();
            cloud.setX(this.oldX);
            cloud.setY(this.oldY);
            cloud.setDimension(this.oldW, this.oldH);
        } else if (this.selectedManipulable instanceof Tree) {
            Tree tree = (Tree)this.selectedManipulable;
            this.newX = tree.getX();
            this.newY = tree.getY();
            this.newW = tree.getWidth();
            this.newH = tree.getHeight();
            tree.setX(this.oldX);
            tree.setY(this.oldY);
            tree.setDimension(this.oldW, this.oldH);
        } else if (this.selectedManipulable instanceof Particle) {
            Particle particle = (Particle)this.selectedManipulable;
            this.newW = particle.getRadius();
            particle.setRadius(this.oldW);
        }
        this.view.setSelectedManipulable(this.selectedManipulable);
        this.view.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this.selectedManipulable instanceof Part) {
            Shape shape = this.selectedManipulable.getShape();
            if (shape instanceof Rectangle2D.Float) {
                Rectangle2D.Float rect = (Rectangle2D.Float)shape;
                rect.x = this.newX;
                rect.y = this.newY;
                rect.width = this.newW;
                rect.height = this.newH;
            } else if (shape instanceof Ellipse2D.Float) {
                Ellipse2D.Float elli = (Ellipse2D.Float)shape;
                elli.x = this.newX;
                elli.y = this.newY;
                elli.width = this.newW;
                elli.height = this.newH;
            } else if (!(shape instanceof Polygon2D) && !(shape instanceof Blob2D)) {
                boolean cfr_ignored_0 = shape instanceof Ring2D;
            }
            this.model.refreshPowerArray();
            this.model.refreshTemperatureBoundaryArray();
            this.model.refreshMaterialPropertyArrays();
            this.model.refreshHeliostatsAimedAt((Part)this.selectedManipulable);
            if (this.view.isViewFactorLinesOn()) {
                this.model.generateViewFactorMesh();
            }
        } else if (this.selectedManipulable instanceof Fan) {
            Shape shape = this.selectedManipulable.getShape();
            Rectangle2D.Float rect = (Rectangle2D.Float)shape;
            rect.x = this.newX;
            rect.y = this.newY;
            rect.width = this.newW;
            rect.height = this.newH;
            this.model.refreshMaterialPropertyArrays();
        } else if (this.selectedManipulable instanceof Heliostat) {
            Shape shape = this.selectedManipulable.getShape();
            Rectangle2D.Float rect = (Rectangle2D.Float)shape;
            rect.x = this.newX;
            rect.y = this.newY;
            rect.width = this.newW;
            rect.height = this.newH;
            ((Heliostat)this.selectedManipulable).setAngle();
        } else if (this.selectedManipulable instanceof Cloud) {
            Cloud cloud = (Cloud)this.selectedManipulable;
            cloud.setX(this.newX);
            cloud.setY(this.newY);
            cloud.setDimension(this.newW, this.newH);
        } else if (this.selectedManipulable instanceof Tree) {
            Tree tree = (Tree)this.selectedManipulable;
            tree.setX(this.newX);
            tree.setY(this.newY);
            tree.setDimension(this.newW, this.newH);
        } else if (this.selectedManipulable instanceof Particle) {
            Particle particle = (Particle)this.selectedManipulable;
            particle.setRadius(this.newW);
        }
        this.view.setSelectedManipulable(this.selectedManipulable);
        this.view.repaint();
    }

    @Override
    public String getPresentationName() {
        return "Resize " + (this.name == null ? "Manipulable" : this.name);
    }
}

