/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.concord.energy2d.model.Anemometer;
import org.concord.energy2d.model.Cloud;
import org.concord.energy2d.model.Fan;
import org.concord.energy2d.model.HeatFluxSensor;
import org.concord.energy2d.model.Heliostat;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.model.Model2D;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.model.Particle;
import org.concord.energy2d.model.ParticleFeeder;
import org.concord.energy2d.model.Thermometer;
import org.concord.energy2d.model.Tree;
import org.concord.energy2d.view.TextBox;
import org.concord.energy2d.view.View2D;

public class UndoRemoveManipulable
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private Manipulable selectedManipulable;
    private int index = 0;
    private View2D view;
    private Model2D model;
    private String name;

    public UndoRemoveManipulable(View2D view) {
        this.view = view;
        this.model = view.getModel();
        this.selectedManipulable = view.getSelectedManipulable();
        if (this.selectedManipulable instanceof Part) {
            this.index = this.model.getParts().indexOf(this.selectedManipulable);
            this.name = "Part";
        } else if (this.selectedManipulable instanceof Fan) {
            this.index = this.model.getFans().indexOf(this.selectedManipulable);
            this.name = "Fan";
        } else if (this.selectedManipulable instanceof Heliostat) {
            this.index = this.model.getHeliostats().indexOf(this.selectedManipulable);
            this.name = "Heliostat";
        } else if (this.selectedManipulable instanceof Particle) {
            this.index = this.model.getParticles().indexOf(this.selectedManipulable);
            this.name = "Particle";
        } else if (this.selectedManipulable instanceof ParticleFeeder) {
            this.index = this.model.getParticleFeeders().indexOf(this.selectedManipulable);
            this.name = "Particle Feedder";
        } else if (this.selectedManipulable instanceof Anemometer) {
            this.index = this.model.getAnemometers().indexOf(this.selectedManipulable);
            this.name = "Anemometer";
        } else if (this.selectedManipulable instanceof HeatFluxSensor) {
            this.index = this.model.getHeatFluxSensors().indexOf(this.selectedManipulable);
            this.name = "Heat Flux Sensor";
        } else if (this.selectedManipulable instanceof Thermometer) {
            this.index = this.model.getThermometers().indexOf(this.selectedManipulable);
            this.name = "Thermometer";
        } else if (this.selectedManipulable instanceof Cloud) {
            this.index = this.model.getClouds().indexOf(this.selectedManipulable);
            this.name = "Cloud";
        } else if (this.selectedManipulable instanceof Tree) {
            this.index = this.model.getTrees().indexOf(this.selectedManipulable);
            this.name = "Tree";
        } else if (this.selectedManipulable instanceof TextBox) {
            this.index = view.getTextBoxes().indexOf(this.selectedManipulable);
            this.name = "Text Box";
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        if (this.selectedManipulable instanceof Part) {
            this.model.addPart((Part)this.selectedManipulable, this.index);
            this.model.refreshPowerArray();
            this.model.refreshTemperatureBoundaryArray();
            this.model.refreshMaterialPropertyArrays();
        } else if (this.selectedManipulable instanceof Fan) {
            this.model.addFan((Fan)this.selectedManipulable, this.index);
            this.model.refreshMaterialPropertyArrays();
        } else if (this.selectedManipulable instanceof Heliostat) {
            this.model.addHeliostat((Heliostat)this.selectedManipulable, this.index);
        } else if (this.selectedManipulable instanceof Particle) {
            this.model.addParticle((Particle)this.selectedManipulable, this.index);
        } else if (this.selectedManipulable instanceof ParticleFeeder) {
            this.model.addParticleFeeder((ParticleFeeder)this.selectedManipulable, this.index);
        } else if (this.selectedManipulable instanceof Anemometer) {
            this.model.addAnemometer((Anemometer)this.selectedManipulable, this.index);
        } else if (this.selectedManipulable instanceof HeatFluxSensor) {
            this.model.addHeatFluxSensor((HeatFluxSensor)this.selectedManipulable, this.index);
        } else if (this.selectedManipulable instanceof Thermometer) {
            this.model.addThermometer((Thermometer)this.selectedManipulable, this.index);
        } else if (this.selectedManipulable instanceof Cloud) {
            this.model.addCloud((Cloud)this.selectedManipulable, this.index);
        } else if (this.selectedManipulable instanceof Tree) {
            this.model.addTree((Tree)this.selectedManipulable, this.index);
        } else if (this.selectedManipulable instanceof TextBox) {
            this.view.addTextBox((TextBox)this.selectedManipulable, this.index);
        }
        this.view.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.view.notifyManipulationListeners(this.selectedManipulable, (byte)0);
        this.view.repaint();
    }

    @Override
    public String getPresentationName() {
        return "Remove " + (this.name == null ? "Manipulable" : this.name);
    }
}

