/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.concord.energy2d.model.Anemometer;
import org.concord.energy2d.model.Cloud;
import org.concord.energy2d.model.Fan;
import org.concord.energy2d.model.HeatFluxSensor;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.model.Model2D;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.model.Particle;
import org.concord.energy2d.model.ParticleFeeder;
import org.concord.energy2d.model.Thermometer;
import org.concord.energy2d.model.Tree;
import org.concord.energy2d.view.TextBox;
import org.concord.energy2d.view.View2D;

public class UndoPaste
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private Manipulable pastedManipulable;
    private View2D view;
    private Model2D model;
    private String name;

    public UndoPaste(Manipulable pastedManipulable, View2D view) {
        this.view = view;
        this.model = view.getModel();
        this.pastedManipulable = pastedManipulable;
        if (pastedManipulable instanceof Part) {
            this.name = "Part";
        } else if (pastedManipulable instanceof Thermometer) {
            this.name = "Thermometer";
        } else if (pastedManipulable instanceof HeatFluxSensor) {
            this.name = "Heat Flux Sensor";
        } else if (pastedManipulable instanceof Anemometer) {
            this.name = "Anemometer";
        } else if (pastedManipulable instanceof Particle) {
            this.name = "Particle";
        } else if (pastedManipulable instanceof ParticleFeeder) {
            this.name = "Particle Feeder";
        } else if (pastedManipulable instanceof Fan) {
            this.name = "Fan";
        } else if (pastedManipulable instanceof Cloud) {
            this.name = "Cloud";
        } else if (pastedManipulable instanceof Tree) {
            this.name = "Tree";
        } else if (pastedManipulable instanceof TextBox) {
            this.name = "Text Box";
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        if (this.pastedManipulable != null) {
            this.view.notifyManipulationListeners(this.pastedManipulable, (byte)0);
        }
        this.view.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this.pastedManipulable instanceof Part) {
            this.model.addPart((Part)this.pastedManipulable);
            this.model.refreshPowerArray();
            this.model.refreshTemperatureBoundaryArray();
            this.model.refreshMaterialPropertyArrays();
            this.model.setInitialTemperature();
        } else if (this.pastedManipulable instanceof Thermometer) {
            this.model.addThermometer((Thermometer)this.pastedManipulable);
        } else if (this.pastedManipulable instanceof HeatFluxSensor) {
            this.model.addHeatFluxSensor((HeatFluxSensor)this.pastedManipulable);
        } else if (this.pastedManipulable instanceof Anemometer) {
            this.model.addAnemometer((Anemometer)this.pastedManipulable);
        } else if (this.pastedManipulable instanceof Particle) {
            this.model.addParticle((Particle)this.pastedManipulable);
        } else if (this.pastedManipulable instanceof ParticleFeeder) {
            this.model.addParticleFeeder((ParticleFeeder)this.pastedManipulable);
        } else if (this.pastedManipulable instanceof Fan) {
            this.model.addFan((Fan)this.pastedManipulable);
            this.model.refreshMaterialPropertyArrays();
        } else if (this.pastedManipulable instanceof Cloud) {
            this.model.addCloud((Cloud)this.pastedManipulable);
        } else if (this.pastedManipulable instanceof Tree) {
            this.model.addTree((Tree)this.pastedManipulable);
        } else if (this.pastedManipulable instanceof TextBox) {
            this.view.addTextBox((TextBox)this.pastedManipulable);
        }
        this.view.setSelectedManipulable(this.pastedManipulable);
        this.view.repaint();
    }

    @Override
    public String getPresentationName() {
        return "Paste " + (this.name == null ? "Manipulable" : this.name);
    }
}

