/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.concord.energy2d.view.View2D;

public class UndoMouseReadType
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private byte oldValue;
    private byte newValue;
    private View2D view;

    public UndoMouseReadType(View2D view) {
        this.oldValue = view.getMouseReadType();
        this.view = view;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.newValue = this.view.getMouseReadType();
        this.view.setMouseReadType(this.oldValue);
        this.view.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.view.setMouseReadType(this.newValue);
        this.view.repaint();
    }

    @Override
    public String getPresentationName() {
        return "Mouse Read Type Change";
    }
}

