/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.undo;

import java.awt.Shape;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.concord.energy2d.math.Blob2D;
import org.concord.energy2d.math.TransformableShape;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.model.Model2D;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.view.View2D;

public class UndoFlipManipulable
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private Manipulable selectedManipulable;
    private View2D view;
    private Model2D model;
    private String name;
    private int flipDirection;

    public UndoFlipManipulable(View2D view, int flipDirection) {
        this.view = view;
        this.flipDirection = flipDirection;
        this.model = view.getModel();
        this.selectedManipulable = view.getSelectedManipulable();
        if (this.selectedManipulable instanceof Part) {
            this.name = "Part";
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        Shape shape;
        super.undo();
        if (this.selectedManipulable instanceof Part && (shape = this.selectedManipulable.getShape()) instanceof TransformableShape) {
            TransformableShape s = (TransformableShape)shape;
            switch (this.flipDirection) {
                case 0: {
                    s.flipX();
                    break;
                }
                case 1: {
                    s.flipY();
                }
            }
            if (s instanceof Blob2D) {
                ((Blob2D)s).update();
            }
            this.model.refreshPowerArray();
            this.model.refreshTemperatureBoundaryArray();
            this.model.refreshMaterialPropertyArrays();
            if (this.view.isViewFactorLinesOn()) {
                this.model.generateViewFactorMesh();
            }
        }
        this.view.setSelectedManipulable(this.selectedManipulable);
        this.view.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        Shape shape;
        super.redo();
        if (this.selectedManipulable instanceof Part && (shape = this.selectedManipulable.getShape()) instanceof TransformableShape) {
            TransformableShape s = (TransformableShape)shape;
            switch (this.flipDirection) {
                case 0: {
                    s.flipX();
                    break;
                }
                case 1: {
                    s.flipY();
                }
            }
            if (s instanceof Blob2D) {
                ((Blob2D)s).update();
            }
            this.model.refreshPowerArray();
            this.model.refreshTemperatureBoundaryArray();
            this.model.refreshMaterialPropertyArrays();
            if (this.view.isViewFactorLinesOn()) {
                this.model.generateViewFactorMesh();
            }
        }
        this.view.setSelectedManipulable(this.selectedManipulable);
        this.view.repaint();
    }

    @Override
    public String getPresentationName() {
        return "Flip " + (this.name == null ? "Manipulable" : this.name);
    }
}

