/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.undo;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.concord.energy2d.math.Polygon2D;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.view.View2D;

public class UndoEditPolygon
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private List<Point2D.Float> oldPoints;
    private List<Point2D.Float> newPoints;
    private View2D view;
    private Polygon2D polygon;
    private Manipulable selectedManipulable;

    public UndoEditPolygon(View2D view, Manipulable selectedManipulable, Polygon2D polygon) {
        this.view = view;
        this.selectedManipulable = selectedManipulable;
        this.polygon = polygon;
        this.oldPoints = new ArrayList<Point2D.Float>();
        this.newPoints = new ArrayList<Point2D.Float>();
        int n = polygon.getVertexCount();
        int i = 0;
        while (i < n) {
            Point2D.Float pi = polygon.getVertex(i);
            this.oldPoints.add(new Point2D.Float(pi.x, pi.y));
            ++i;
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        int n = this.polygon.getVertexCount();
        int i = 0;
        while (i < n) {
            Point2D.Float pi = this.polygon.getVertex(i);
            this.newPoints.add(new Point2D.Float(pi.x, pi.y));
            ++i;
        }
        this.polygon.setVertices(this.oldPoints);
        this.view.getModel().refreshPowerArray();
        this.view.getModel().refreshTemperatureBoundaryArray();
        this.view.getModel().refreshMaterialPropertyArrays();
        if (this.view.isViewFactorLinesOn()) {
            this.view.getModel().generateViewFactorMesh();
        }
        this.view.setSelectedManipulable(this.selectedManipulable);
        this.view.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.polygon.setVertices(this.newPoints);
        this.view.getModel().refreshPowerArray();
        this.view.getModel().refreshTemperatureBoundaryArray();
        this.view.getModel().refreshMaterialPropertyArrays();
        if (this.view.isViewFactorLinesOn()) {
            this.view.getModel().generateViewFactorMesh();
        }
        this.view.setSelectedManipulable(this.selectedManipulable);
        this.view.repaint();
    }

    @Override
    public String getPresentationName() {
        return "Edit Polygon";
    }
}

