/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.concord.energy2d.math.Blob2D;
import org.concord.energy2d.model.Part;
import org.concord.energy2d.view.View2D;

public class UndoEditBlobOrPolygon
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private View2D view;
    private Part oldPart;
    private Part newPart;

    public UndoEditBlobOrPolygon(View2D view, Part oldPart, Part newPart) {
        this.view = view;
        this.oldPart = oldPart;
        this.newPart = newPart;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.view.getModel().removePart(this.newPart);
        this.view.getModel().addPart(this.oldPart);
        this.view.getModel().refreshPowerArray();
        this.view.getModel().refreshTemperatureBoundaryArray();
        this.view.getModel().refreshMaterialPropertyArrays();
        if (this.view.isViewFactorLinesOn()) {
            this.view.getModel().generateViewFactorMesh();
        }
        this.view.setSelectedManipulable(this.oldPart);
        this.view.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.view.getModel().removePart(this.oldPart);
        this.view.getModel().addPart(this.newPart);
        this.view.getModel().refreshPowerArray();
        this.view.getModel().refreshTemperatureBoundaryArray();
        this.view.getModel().refreshMaterialPropertyArrays();
        if (this.view.isViewFactorLinesOn()) {
            this.view.getModel().generateViewFactorMesh();
        }
        this.view.setSelectedManipulable(this.newPart);
        this.view.repaint();
    }

    @Override
    public String getPresentationName() {
        return this.oldPart.getShape() instanceof Blob2D ? "Edit Blob" : "Edit Polygon";
    }
}

