/*
 * Decompiled with CFR 0.152.
 */
package org.concord.energy2d.undo;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.concord.energy2d.math.Blob2D;
import org.concord.energy2d.model.Manipulable;
import org.concord.energy2d.view.View2D;

public class UndoEditBlob
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private List<Point2D.Float> oldPoints;
    private List<Point2D.Float> newPoints;
    private View2D view;
    private Blob2D blob;
    private Manipulable selectedManipulable;

    public UndoEditBlob(View2D view, Manipulable selectedManipulable, Blob2D blob) {
        this.view = view;
        this.selectedManipulable = selectedManipulable;
        this.blob = blob;
        this.oldPoints = new ArrayList<Point2D.Float>();
        this.newPoints = new ArrayList<Point2D.Float>();
        int n = blob.getPointCount();
        int i = 0;
        while (i < n) {
            Point2D.Float pi = blob.getPoint(i);
            this.oldPoints.add(new Point2D.Float(pi.x, pi.y));
            ++i;
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        int n = this.blob.getPointCount();
        int i = 0;
        while (i < n) {
            Point2D.Float pi = this.blob.getPoint(i);
            this.newPoints.add(new Point2D.Float(pi.x, pi.y));
            ++i;
        }
        this.blob.setPoints(this.oldPoints);
        this.view.getModel().refreshPowerArray();
        this.view.getModel().refreshTemperatureBoundaryArray();
        this.view.getModel().refreshMaterialPropertyArrays();
        if (this.view.isViewFactorLinesOn()) {
            this.view.getModel().generateViewFactorMesh();
        }
        this.view.setSelectedManipulable(this.selectedManipulable);
        this.view.repaint();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.blob.setPoints(this.newPoints);
        this.view.getModel().refreshPowerArray();
        this.view.getModel().refreshTemperatureBoundaryArray();
        this.view.getModel().refreshMaterialPropertyArrays();
        if (this.view.isViewFactorLinesOn()) {
            this.view.getModel().generateViewFactorMesh();
        }
        this.view.setSelectedManipulable(this.selectedManipulable);
        this.view.repaint();
    }

    @Override
    public String getPresentationName() {
        return "Edit Blob";
    }
}

